/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.jspecify.annotations.Nullable;

public final class StringCache {
    private final HashMap<Object, String> cache;
    private final SubstringKey substringKey = new SubstringKey();

    public StringCache(int expectedSize) {
        this.cache = Maps.newHashMapWithExpectedSize((int)expectedSize);
    }

    public String get(String str) {
        String result = this.cache.putIfAbsent(str, str);
        return result == null ? str : result;
    }

    public String getSubstring(String superstring, int start, int end) {
        Preconditions.checkArgument((0 <= start && start <= end && end <= superstring.length() ? 1 : 0) != 0);
        this.substringKey.fill(superstring, start, end);
        String result = this.cache.get(this.substringKey);
        if (result == null) {
            result = superstring.substring(start, end);
            this.cache.put(result, result);
        }
        return result;
    }

    private static final class SubstringKey {
        String superstring;
        int start;
        int end;
        int length;

        private SubstringKey() {
        }

        public void fill(String superstring, int start, int end) {
            this.superstring = superstring;
            this.start = start;
            this.end = end;
            this.length = end - start;
        }

        public boolean equals(@Nullable Object that) {
            String thatString = (String)that;
            return thatString.length() == this.length && thatString.regionMatches(0, this.superstring, this.start, this.length);
        }

        public int hashCode() {
            int result = 0;
            for (int i = this.start; i < this.end; ++i) {
                result = 31 * result + this.superstring.charAt(i);
            }
            return result;
        }
    }
}

