/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.BinopMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.MethodArgMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.TypeArgOfMethodArgMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import org.jspecify.annotations.Nullable;

public final class ContainmentMatchers {
    private static final Matcher<ExpressionTree> FIRST_ORDER_MATCHER = Matchers.anyMethod().onDescendantOfAny(new String[]{"java.util.Collection", "java.util.Dictionary", "java.util.Map", "java.util.Collections", "com.google.common.collect.Sets"});
    private static final ImmutableList<MethodArgMatcher> DIRECT_MATCHERS = ImmutableList.of((Object)new MethodArgMatcher("java.util.Collection", 0, 0, "contains", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.Collection", 0, 0, "remove", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.Deque", 0, 0, "removeFirstOccurrence", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.Deque", 0, 0, "removeLastOccurrence", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.Dictionary", 0, 0, "get", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.Dictionary", 0, 0, "remove", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.List", 0, 0, "indexOf", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.List", 0, 0, "lastIndexOf", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.Map", 0, 0, "containsKey", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.Map", 1, 0, "containsValue", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.Map", 0, 0, "get", "java.lang.Object", new String[0]), (Object)new MethodArgMatcher("java.util.Map", 0, 0, "getOrDefault", "java.lang.Object", "java.lang.Object"), (Object[])new MethodArgMatcher[]{new MethodArgMatcher("java.util.Map", 0, 0, "remove", "java.lang.Object", new String[0]), new MethodArgMatcher("java.util.Stack", 0, 0, "search", "java.lang.Object", new String[0]), new MethodArgMatcher("java.util.Vector", 0, 0, "indexOf", "java.lang.Object", "int"), new MethodArgMatcher("java.util.Vector", 0, 0, "lastIndexOf", "java.lang.Object", "int"), new MethodArgMatcher("java.util.Vector", 0, 0, "removeElement", "java.lang.Object", new String[0])});
    private static final ImmutableList<TypeArgOfMethodArgMatcher> TYPE_ARG_MATCHERS = ImmutableList.of((Object)new TypeArgOfMethodArgMatcher("java.util.Collection", 0, 0, "java.util.Collection", 0, "containsAll", "java.util.Collection", new String[0]), (Object)new TypeArgOfMethodArgMatcher("java.util.Collection", 0, 0, "java.util.Collection", 0, "removeAll", "java.util.Collection", new String[0]), (Object)new TypeArgOfMethodArgMatcher("java.util.Collection", 0, 0, "java.util.Collection", 0, "retainAll", "java.util.Collection", new String[0]));
    private static final ImmutableList<BinopMatcher> STATIC_MATCHERS = ImmutableList.of((Object)new BinopMatcher("java.util.Collection", "java.util.Collections", "disjoint"), (Object)new BinopMatcher("java.util.Set", "com.google.common.collect.Sets", "difference"));
    private static final ImmutableList<AbstractCollectionIncompatibleTypeMatcher> ALL_MATCHERS = ImmutableList.builder().addAll(DIRECT_MATCHERS).addAll(TYPE_ARG_MATCHERS).addAll(STATIC_MATCHERS).build();

    public static @Nullable AbstractCollectionIncompatibleTypeMatcher.MatchResult firstNonNullMatchResult(ExpressionTree tree, VisitorState state) {
        if (!FIRST_ORDER_MATCHER.matches((Tree)tree, state)) {
            return null;
        }
        for (AbstractCollectionIncompatibleTypeMatcher matcher : ALL_MATCHERS) {
            AbstractCollectionIncompatibleTypeMatcher.MatchResult result = matcher.matches(tree, state);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private ContainmentMatchers() {
    }
}

