/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.apidiff;

import com.google.common.io.Resources;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.apidiff.ApiDiff;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffChecker;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffProto;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;

@BugPattern(altNames={"AndroidApiChecker"}, summary="Use of class, field, or method that is not compatible with legacy Android devices", severity=BugPattern.SeverityLevel.ERROR)
public class AndroidJdkLibsChecker
extends ApiDiffChecker {
    private static final Matcher<ExpressionTree> FOREACH_ON_COLLECTION = MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("forEach").withParameters("java.util.function.Consumer", new String[0]);

    private static ApiDiff loadApiDiff() {
        try {
            byte[] diffData = Resources.toByteArray((URL)Resources.getResource(AndroidJdkLibsChecker.class, (String)"android_java8.binarypb"));
            ApiDiffProto.Diff diff = ((ApiDiffProto.Diff.Builder)ApiDiffProto.Diff.newBuilder().mergeFrom(diffData, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry())).build();
            return ApiDiff.fromProto(diff);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private AndroidJdkLibsChecker() {
        super(AndroidJdkLibsChecker.loadApiDiff());
    }

    @Override
    protected Description check(ExpressionTree tree, VisitorState state) {
        Description description = super.check(tree, state);
        if (description.equals(Description.NO_MATCH)) {
            return Description.NO_MATCH;
        }
        if (FOREACH_ON_COLLECTION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return description;
    }
}

