/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.HashSet;
import java.util.Set;

@BugPattern(summary="Declaring a type parameter that is only used in the return type is a misuse of generics: operations on the type parameter are unchecked, it hides unsafe casts at invocations of the method, and it interacts badly with method overload resolution.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class TypeParameterUnusedInFormals
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Type.TypeVar retType;
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
        switch (methodSymbol.getReturnType().getKind()) {
            case TYPEVAR: {
                retType = (Type.TypeVar)methodSymbol.getReturnType();
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        if (!methodSymbol.equals(retType.tsym.owner)) {
            return Description.NO_MATCH;
        }
        if (retType.getUpperBound() != null && TypeParameterFinder.visit(retType.getUpperBound()).contains(retType.tsym)) {
            return Description.NO_MATCH;
        }
        for (Symbol.VarSymbol formalParam : methodSymbol.getParameters()) {
            if (!TypeParameterFinder.visit(formalParam.type).contains(retType.tsym)) continue;
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static class TypeParameterFinder
    extends Types.DefaultTypeVisitor<Void, Void> {
        private final Set<Symbol.TypeSymbol> seen = new HashSet<Symbol.TypeSymbol>();

        private TypeParameterFinder() {
        }

        static Set<Symbol.TypeSymbol> visit(Type type) {
            TypeParameterFinder visitor = new TypeParameterFinder();
            type.accept(visitor, null);
            return visitor.seen;
        }

        @Override
        public Void visitClassType(Type.ClassType type, Void unused) {
            if (type instanceof Type.IntersectionClassType) {
                Type.IntersectionClassType intersectionClassType = (Type.IntersectionClassType)type;
                this.visitIntersectionClassType(intersectionClassType);
            } else {
                for (Type t : type.getTypeArguments()) {
                    t.accept(this, null);
                }
            }
            return null;
        }

        public void visitIntersectionClassType(Type.IntersectionClassType type) {
            for (Type component : type.getComponents()) {
                component.accept(this, null);
            }
        }

        @Override
        public Void visitWildcardType(Type.WildcardType type, Void unused) {
            if (type.getSuperBound() != null) {
                type.getSuperBound().accept(this, null);
            }
            if (type.getExtendsBound() != null) {
                type.getExtendsBound().accept(this, null);
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType type, Void unused) {
            type.elemtype.accept(this, null);
            return null;
        }

        @Override
        public Void visitTypeVar(Type.TypeVar type, Void unused) {
            if (!this.seen.add(type.tsym)) {
                return null;
            }
            if (type.getUpperBound() != null) {
                type.getUpperBound().accept(this, null);
            }
            return null;
        }

        @Override
        public Void visitType(Type type, Void unused) {
            return null;
        }
    }
}

