/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NamedParameterComment;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Comments;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import javax.inject.Inject;

@BugPattern(summary="Detects `/* name= */`-style comments on actual parameters where the name doesn't match the formal parameter", severity=BugPattern.SeverityLevel.WARNING)
public class ParameterName
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private final ImmutableList<String> exemptPackages;

    @Inject
    ParameterName(ErrorProneFlags errorProneFlags) {
        this.exemptPackages = (ImmutableList)errorProneFlags.getListOrEmpty("ParameterName:exemptPackagePrefixes").stream().map(p -> p.endsWith(".") ? p : p + ".").collect(ImmutableList.toImmutableList());
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        this.checkArguments(tree, tree.getArguments(), state.getEndPosition((Tree)tree.getMethodSelect()), state);
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        this.checkArguments(tree, tree.getArguments(), state.getEndPosition((Tree)tree.getIdentifier()), state);
        return Description.NO_MATCH;
    }

    private void checkArguments(Tree tree, java.util.List<? extends ExpressionTree> arguments, int argListStartPosition, VisitorState state) {
        if (arguments.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol sym = (Symbol.MethodSymbol)ASTHelpers.getSymbol((Tree)tree);
        if (NamedParameterComment.containsSyntheticParameterName(sym)) {
            return;
        }
        int start = argListStartPosition;
        if (start == -1) {
            return;
        }
        String enclosingClass = ASTHelpers.enclosingClass((Symbol)sym).toString();
        if (this.exemptPackages.stream().anyMatch(enclosingClass::startsWith)) {
            return;
        }
        Iterator<? extends ExpressionTree> argumentIterator = arguments.iterator();
        for (Symbol.VarSymbol param : sym.getParameters()) {
            if (!argumentIterator.hasNext()) {
                return;
            }
            ExpressionTree argument = argumentIterator.next();
            Optional<Range<Integer>> positions = this.positions(argument, state);
            if (positions.isEmpty()) {
                return;
            }
            start = ParameterName.processArgument(positions.get(), start, state, tok -> this.checkArgument(param, argument, (ErrorProneToken)tok, state));
        }
        while (argumentIterator.hasNext()) {
            ExpressionTree argument = argumentIterator.next();
            Optional<Range<Integer>> positions = this.positions(argument, state);
            if (positions.isEmpty()) {
                return;
            }
            start = ParameterName.processArgument(positions.get(), start, state, tok -> this.checkComment(argument, (ErrorProneToken)tok, state));
        }
    }

    Optional<Range<Integer>> positions(Tree tree, VisitorState state) {
        int endPosition = state.getEndPosition(tree);
        if (endPosition == -1) {
            return Optional.empty();
        }
        return Optional.of(Range.closedOpen((Comparable)Integer.valueOf(ASTHelpers.getStartPosition((Tree)tree)), (Comparable)Integer.valueOf(endPosition)));
    }

    private static int processArgument(Range<Integer> positions, int offset, VisitorState state, Consumer<ErrorProneToken> consumer) {
        String source = state.getSourceCode().subSequence(offset, (Integer)positions.upperEndpoint()).toString();
        ArrayDeque<ErrorProneToken> tokens = new ArrayDeque<ErrorProneToken>((Collection<ErrorProneToken>)ErrorProneTokens.getTokens((String)source, (int)offset, (Context)state.context));
        if (ParameterName.advanceTokens(tokens, positions)) {
            consumer.accept((ErrorProneToken)tokens.removeFirst());
        }
        return (Integer)positions.upperEndpoint();
    }

    private static boolean advanceTokens(Deque<ErrorProneToken> tokens, Range<Integer> actual) {
        while (!tokens.isEmpty() && tokens.getFirst().pos() < (Integer)actual.lowerEndpoint()) {
            tokens.removeFirst();
        }
        if (tokens.isEmpty()) {
            return false;
        }
        return actual.contains((Comparable)Integer.valueOf(tokens.getFirst().pos()));
    }

    private void checkArgument(Symbol.VarSymbol formal, ExpressionTree actual, ErrorProneToken token, VisitorState state) {
        ArrayList<FixInfo> matches = new ArrayList<FixInfo>();
        for (ErrorProneComment comment : token.comments()) {
            Matcher m;
            if (comment.getStyle().equals((Object)ErrorProneComment.ErrorProneCommentStyle.LINE) || !(m = NamedParameterComment.PARAMETER_COMMENT_PATTERN.matcher(Comments.getTextFromComment((ErrorProneComment)comment))).matches()) continue;
            boolean isFormatCorrect = ParameterName.isVarargs(formal) ^ Strings.isNullOrEmpty((String)m.group(2));
            String name = m.group(1);
            boolean isNameCorrect = ((Name)formal.getSimpleName()).contentEquals(name);
            if (isNameCorrect && isFormatCorrect) {
                matches.clear();
                break;
            }
            matches.add(FixInfo.create(isFormatCorrect, isNameCorrect, comment, name));
        }
        String fixTemplate = ParameterName.isVarargs(formal) ? "/* %s...= */" : "/* %s= */";
        for (FixInfo match : matches) {
            Description description;
            SuggestedFix rewriteCommentFix = ParameterName.rewriteComment(match.comment(), String.format(fixTemplate, formal.getSimpleName()));
            SuggestedFix rewriteToRegularCommentFix = ParameterName.rewriteComment(match.comment(), String.format("/* %s */", match.name()));
            if (match.isFormatCorrect() && !match.isNameCorrect()) {
                description = this.buildDescription(actual).setMessage(String.format("`%s` does not match formal parameter name `%s`; either fix the name or use a regular comment", match.comment().getText(), formal.getSimpleName())).addFix((Fix)rewriteCommentFix).addFix((Fix)rewriteToRegularCommentFix).build();
            } else if (!match.isFormatCorrect() && match.isNameCorrect()) {
                description = this.buildDescription(actual).setMessage(String.format("parameter name comment `%s` uses incorrect format", match.comment().getText())).addFix((Fix)rewriteCommentFix).build();
            } else if (!match.isFormatCorrect() && !match.isNameCorrect()) {
                description = this.buildDescription(actual).setMessage(String.format("`%s` does not match formal parameter name `%s` and uses incorrect format; either fix the format or use a regular comment", match.comment().getText(), formal.getSimpleName())).addFix((Fix)rewriteCommentFix).addFix((Fix)rewriteToRegularCommentFix).build();
            } else {
                throw new AssertionError((Object)("Unexpected match with both isNameCorrect and isFormatCorrect true: " + String.valueOf(match)));
            }
            state.reportMatch(description);
        }
    }

    private static SuggestedFix rewriteComment(ErrorProneComment comment, String format) {
        int replacementStartPos = comment.getSourcePos(0);
        int replacementEndPos = comment.getSourcePos(comment.getText().length() - 1) + 1;
        return SuggestedFix.replace((int)replacementStartPos, (int)replacementEndPos, (String)format);
    }

    private void checkComment(ExpressionTree arg, ErrorProneToken token, VisitorState state) {
        for (ErrorProneComment comment : token.comments()) {
            Matcher m = NamedParameterComment.PARAMETER_COMMENT_PATTERN.matcher(Comments.getTextFromComment((ErrorProneComment)comment));
            if (!m.matches()) continue;
            SuggestedFix rewriteCommentFix = ParameterName.rewriteComment(comment, String.format("/* %s%s */", m.group(1), MoreObjects.firstNonNull((Object)m.group(2), (Object)"")));
            state.reportMatch(this.buildDescription(arg).addFix((Fix)rewriteCommentFix).setMessage("parameter name comment only allowed on first varargs argument").build());
        }
    }

    private static boolean isVarargs(Symbol.VarSymbol sym) {
        Preconditions.checkArgument((boolean)(sym.owner instanceof Symbol.MethodSymbol), (Object)"sym must be a parameter to a method");
        Symbol.MethodSymbol method = (Symbol.MethodSymbol)sym.owner;
        return method.isVarArgs() && ((List)method.getParameters()).last() == sym;
    }

    private record FixInfo(boolean isFormatCorrect, boolean isNameCorrect, ErrorProneComment comment, String name) {
        static FixInfo create(boolean isFormatCorrect, boolean isNameCorrect, ErrorProneComment comment, String name) {
            return new FixInfo(isFormatCorrect, isNameCorrect, comment, name);
        }
    }
}

