/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.MisusedDateFormat;
import java.util.Optional;

@BugPattern(summary="Use of \"YYYY\" (week year) in a date pattern without \"ww\" (week in year). You probably meant to use \"yyyy\" (year) instead.", severity=BugPattern.SeverityLevel.ERROR)
public final class MisusedWeekYear
extends MisusedDateFormat {
    @Override
    Optional<String> rewriteTo(String pattern) {
        final boolean[] containsY = new boolean[1];
        final boolean[] containsW = new boolean[1];
        MisusedWeekYear.parseDateFormat(pattern, new MisusedDateFormat.DateFormatConsumer(){
            final /* synthetic */ MisusedWeekYear this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void consumeLiteral(char literal) {
            }

            @Override
            public void consumeSpecial(char special) {
                if (special == 'Y') {
                    containsY[0] = true;
                }
                if (special == 'w') {
                    containsW[0] = true;
                }
            }
        });
        if (containsY[0] && !containsW[0]) {
            return Optional.of(MisusedWeekYear.replaceFormatChar(pattern, 'Y', 'y'));
        }
        return Optional.empty();
    }
}

