/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@BugPattern(summary="This looks like a test method but is not run; please add @Test and @Ignore, or, if this is a helper method, reduce its visibility.", severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4TestNotRun
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodTree> POSSIBLE_TEST_METHOD = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.PUBLIC), Matchers.methodReturns((Supplier)Suppliers.VOID_TYPE), Matchers.anyOf((Matcher[])new Matcher[]{(Matcher & Serializable)(t, s) -> JUnit4TestNotRun.hasParameterisationAnnotation(t.getModifiers().getAnnotations()), (Matcher & Serializable)(t, s) -> t.getParameters().stream().allMatch(v -> JUnit4TestNotRun.isInjectable(v, s))}), Matchers.not(JUnitMatchers::hasJUnitAnnotation)});
    private static final ImmutableSet<String> EXEMPTING_METHOD_ANNOTATIONS = ImmutableSet.of((Object)"com.pdsl.runners.PdslTest", (Object)"com.pholser.junit.quickcheck.Property");
    private static final Supplier<Type> FROM_DATA_POINTS = Suppliers.typeFromString((String)"org.junit.experimental.theories.FromDataPoints");
    private static final Matcher<Tree> NOT_STATIC = Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.STATIC));
    private final boolean removeAssertionRequirement;

    private static boolean hasParameterisationAnnotation(List<? extends AnnotationTree> annotations) {
        return annotations.stream().anyMatch(a -> ASTHelpers.getType((Tree)a).tsym.getQualifiedName().toString().startsWith("com.google.testing.junit.testparameterinjector."));
    }

    private static boolean isInjectable(VariableTree variableTree, VisitorState state) {
        if (variableTree.getModifiers().getAnnotations().stream().anyMatch(a -> JUnit4TestNotRun.isParameterAnnotation(a, state))) {
            return true;
        }
        Type type = ASTHelpers.getType((Tree)variableTree);
        return type.tsym.isEnum() || ASTHelpers.isSameType((Type)type, (Type)state.getSymtab().booleanType, (VisitorState)state);
    }

    private static boolean isParameterAnnotation(AnnotationTree annotation, VisitorState state) {
        Type annotationType = ASTHelpers.getType((Tree)annotation);
        return ASTHelpers.isSameType((Type)annotationType, (Type)((Type)FROM_DATA_POINTS.get(state)), (VisitorState)state);
    }

    @Inject
    JUnit4TestNotRun(ErrorProneFlags flags) {
        this.removeAssertionRequirement = flags.getBoolean("JUnit4TestNotRun:RemoveAssertionRequirement").orElse(true);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!JUnitMatchers.isJUnit4TestClass.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        final HashMap<Symbol.MethodSymbol, MethodTree> suspiciousMethods = new HashMap<Symbol.MethodSymbol, MethodTree>();
        for (Tree tree2 : tree.getMembers()) {
            if (!(tree2 instanceof MethodTree)) continue;
            MethodTree methodTree = (MethodTree)tree2;
            if (this.isSuppressed(tree2, state) || !POSSIBLE_TEST_METHOD.matches((Tree)methodTree, state) || this.isSuppressed(tree, state)) continue;
            suspiciousMethods.put(ASTHelpers.getSymbol((MethodTree)methodTree), methodTree);
        }
        tree.accept(new TreeScanner<Void, Void>(this){
            final /* synthetic */ JUnit4TestNotRun this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void scan(Tree tree, Void unused) {
                return suspiciousMethods.isEmpty() ? null : (Void)super.scan(tree, null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                suspiciousMethods.remove(ASTHelpers.getSymbol((MethodInvocationTree)tree));
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
                suspiciousMethods.remove(ASTHelpers.getSymbol((MemberReferenceTree)tree));
                return (Void)super.visitMemberReference(tree, null);
            }
        }, null);
        for (MethodTree methodTree : suspiciousMethods.values()) {
            this.handleMethod(methodTree, state).ifPresent(arg_0 -> ((VisitorState)state).reportMatch(arg_0));
        }
        return Description.NO_MATCH;
    }

    private Optional<Description> handleMethod(MethodTree methodTree, VisitorState state) {
        if (EXEMPTING_METHOD_ANNOTATIONS.stream().anyMatch(anno -> ASTHelpers.hasAnnotation((Tree)methodTree, (String)anno, (VisitorState)state))) {
            return Optional.empty();
        }
        if (JUnit4TestNotRun.hasParameterisationAnnotation(methodTree.getModifiers().getAnnotations()) || methodTree.getParameters().stream().anyMatch(p -> JUnit4TestNotRun.hasParameterisationAnnotation(p.getModifiers().getAnnotations()))) {
            return Optional.of(this.describeFixes(methodTree, state));
        }
        if (JUnitMatchers.isJunit3TestCase.matches((Tree)methodTree, state)) {
            return Optional.of(this.describeFixes(methodTree, state));
        }
        if (methodTree.getName().toString().contains("_")) {
            return Optional.of(this.describeFixes(methodTree, state));
        }
        List<? extends AnnotationTree> annotations = methodTree.getModifiers().getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            return Optional.empty();
        }
        if (NOT_STATIC.matches((Tree)methodTree, state) && (this.removeAssertionRequirement || JUnitMatchers.containsTestMethod((Tree)methodTree))) {
            return Optional.of(this.describeFixes(methodTree, state));
        }
        return Optional.empty();
    }

    private Description describeFixes(MethodTree methodTree, VisitorState state) {
        Optional removeStatic = SuggestedFixes.removeModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC});
        SuggestedFix testFix = removeStatic.orElse(SuggestedFix.emptyFix()).toBuilder().addImport("org.junit.Test").prefixWith((Tree)methodTree, "@Test ").build();
        SuggestedFix ignoreFix = testFix.toBuilder().addImport("org.junit.Ignore").prefixWith((Tree)methodTree, "@Ignore ").build();
        SuggestedFix visibilityFix = SuggestedFix.merge((SuggestedFix)SuggestedFixes.removeModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC}).orElse(SuggestedFix.emptyFix()), (SuggestedFix)SuggestedFixes.addModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PRIVATE}).orElse(SuggestedFix.emptyFix()), (SuggestedFix[])new SuggestedFix[0]);
        String methodName = methodTree.getName().toString();
        if (methodName.startsWith("disabl") || methodName.startsWith("ignor")) {
            return this.buildDescription(methodTree).addFix((Fix)ignoreFix).addFix((Fix)testFix).addFix((Fix)visibilityFix).build();
        }
        return this.buildDescription(methodTree).addFix((Fix)testFix).addFix((Fix)ignoreFix).addFix((Fix)visibilityFix).build();
    }
}

