/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="This expression can be written more clearly with a boolean literal.", severity=BugPattern.SeverityLevel.WARNING)
public class BooleanLiteral
extends BugChecker
implements BugChecker.IdentifierTreeMatcher,
BugChecker.MemberSelectTreeMatcher {
    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    private Description match(ExpressionTree tree, VisitorState state) {
        TargetType targetType;
        boolean value;
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null || sym.owner == null) {
            return Description.NO_MATCH;
        }
        if (!sym.owner.equals(state.getTypes().boxedClass(state.getSymtab().booleanType))) {
            return Description.NO_MATCH;
        }
        if (state.getPath().getParentPath().getLeaf() instanceof MemberReferenceTree) {
            return Description.NO_MATCH;
        }
        switch (sym.getSimpleName().toString()) {
            case "TRUE": {
                value = true;
                break;
            }
            case "FALSE": {
                value = false;
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        TreePath parentPath = state.getPath().getParentPath();
        Tree tree2 = parentPath.getLeaf();
        if (tree2 instanceof MemberSelectTree) {
            MethodInvocationTree invocationTree;
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree2;
            tree2 = parentPath.getParentPath().getLeaf();
            if (tree2 instanceof MethodInvocationTree && (invocationTree = (MethodInvocationTree)tree2).getMethodSelect().equals(memberSelectTree)) {
                Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)invocationTree);
                return switch (((Name)methodSym.getSimpleName()).toString()) {
                    case "toString" -> this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)invocationTree, (String)state.getConstantExpression((Object)Boolean.toString(value))));
                    case "booleanValue" -> this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)invocationTree, (String)Boolean.toString(value)));
                    default -> Description.NO_MATCH;
                };
            }
        }
        if ((targetType = TargetType.targetType((VisitorState)state)) == null || !state.getTypes().unboxedType(targetType.type()).hasTag(TypeTag.NONE)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)Boolean.toString(value)));
    }
}

