/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter;

import java.util.Arrays;
import java.util.List;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.visitor.AllTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataRemover;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.util.WarningLogger;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.visitor.ResourceFileProcessingFlagFilter;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.visitor.KotlinModuleVisitor;
import proguard.util.ProcessingFlagSetter;
import proguard.util.kotlin.asserter.DefaultReporter;
import proguard.util.kotlin.asserter.Reporter;
import proguard.util.kotlin.asserter.constraint.ClassIntegrity;
import proguard.util.kotlin.asserter.constraint.ConstructorIntegrity;
import proguard.util.kotlin.asserter.constraint.DeclarationContainerIntegrity;
import proguard.util.kotlin.asserter.constraint.FileFacadeIntegrity;
import proguard.util.kotlin.asserter.constraint.FunctionIntegrity;
import proguard.util.kotlin.asserter.constraint.KmAnnotationIntegrity;
import proguard.util.kotlin.asserter.constraint.KotlinAsserterConstraint;
import proguard.util.kotlin.asserter.constraint.KotlinModuleIntegrity;
import proguard.util.kotlin.asserter.constraint.MultiFileFacadeIntegrity;
import proguard.util.kotlin.asserter.constraint.MultiFilePartIntegrity;
import proguard.util.kotlin.asserter.constraint.PropertyIntegrity;
import proguard.util.kotlin.asserter.constraint.SyntheticClassIntegrity;
import proguard.util.kotlin.asserter.constraint.TypeIntegrity;
import proguard.util.kotlin.asserter.constraint.ValueParameterIntegrity;

public class KotlinMetadataAsserter {
    private static final List<KotlinAsserterConstraint> DEFAULT_CONSTRAINTS = Arrays.asList(new FunctionIntegrity(), new ConstructorIntegrity(), new PropertyIntegrity(), new ClassIntegrity(), new TypeIntegrity(), new KmAnnotationIntegrity(), new ValueParameterIntegrity(), new SyntheticClassIntegrity(), new FileFacadeIntegrity(), new MultiFilePartIntegrity(), new DeclarationContainerIntegrity(), new KotlinModuleIntegrity(), new MultiFileFacadeIntegrity());

    public void execute(WarningLogger warningLogger, ClassPool programClassPool, ClassPool libraryClassPool, ResourceFilePool resourceFilePool) {
        DefaultReporter reporter = new DefaultReporter(warningLogger);
        MyKotlinMetadataAsserter kotlinMetadataAsserter = new MyKotlinMetadataAsserter(reporter, DEFAULT_CONSTRAINTS, programClassPool, libraryClassPool);
        reporter.setErrorMessage("Warning: Kotlin metadata errors encountered in %s. Not processing the metadata for this class.");
        programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(kotlinMetadataAsserter));
        libraryClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(kotlinMetadataAsserter));
        ReferencedKotlinMetadataVisitor aliasReferenceCleaner = new ReferencedKotlinMetadataVisitor(new KotlinTypeAliasReferenceCleaner(reporter));
        programClassPool.classesAccept(aliasReferenceCleaner);
        libraryClassPool.classesAccept(aliasReferenceCleaner);
        reporter.setErrorMessage("Warning: Kotlin module errors encountered in module %s. Not processing the metadata for this module.");
        resourceFilePool.resourceFilesAccept(new ResourceFileProcessingFlagFilter(0, 32768, kotlinMetadataAsserter));
    }

    private static class KotlinTypeAliasReferenceCleaner
    implements KotlinMetadataVisitor,
    KotlinTypeVisitor,
    KotlinTypeAliasVisitor {
        private final Reporter reporter;
        private int count;

        private KotlinTypeAliasReferenceCleaner(Reporter reporter) {
            this.reporter = reporter;
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
            this.reporter.resetCounter(clazz.getName());
            kotlinMetadata.accept(clazz, new AllTypeVisitor(this));
            if (this.reporter.getCount() > 0) {
                clazz.accept(new KotlinMetadataRemover());
            }
        }

        @Override
        public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
            if (kotlinTypeMetadata.aliasName != null && kotlinTypeMetadata.referencedTypeAlias != null) {
                boolean declarationContainerClazzHasNoMetadata;
                this.count = 0;
                kotlinTypeMetadata.referencedTypeAliasAccept(clazz, this);
                boolean bl = declarationContainerClazzHasNoMetadata = this.count == 0;
                if (declarationContainerClazzHasNoMetadata) {
                    this.reporter.report("Type alias '" + kotlinTypeMetadata.aliasName + "' is declared in a container with no metadata");
                }
            }
        }

        @Override
        public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            kotlinDeclarationContainerMetadata.referencedOwnerClassAccept((__, metadata) -> ++this.count);
        }
    }

    private static class MyKotlinMetadataAsserter
    implements KotlinMetadataVisitor,
    ResourceFileVisitor,
    KotlinModuleVisitor {
        private final List<? extends KotlinAsserterConstraint> constraints;
        private final Reporter reporter;
        private final ClassPool programClassPool;
        private final ClassPool libraryClassPool;

        MyKotlinMetadataAsserter(Reporter reporter, List<KotlinAsserterConstraint> constraints, ClassPool programClassPool, ClassPool libraryClassPool) {
            this.constraints = constraints;
            this.reporter = reporter;
            this.programClassPool = programClassPool;
            this.libraryClassPool = libraryClassPool;
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
            this.reporter.resetCounter(clazz.getName());
            this.constraints.forEach(constraint -> constraint.check(this.reporter, this.programClassPool, this.libraryClassPool, clazz, kotlinMetadata));
            if (this.reporter.getCount() > 0) {
                clazz.accept(new KotlinMetadataRemover());
            }
        }

        @Override
        public void visitKotlinModule(KotlinModule kotlinModule) {
            this.reporter.resetCounter(kotlinModule.name);
            this.constraints.forEach(constraint -> constraint.check(this.reporter, kotlinModule));
            if (this.reporter.getCount() > 0) {
                kotlinModule.accept(new ProcessingFlagSetter(32768));
            }
        }

        @Override
        public void visitResourceFile(ResourceFile resourceFile) {
        }
    }
}

