/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io.kotlin;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.metadata.Attributes;
import kotlin.metadata.ClassKind;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmClassifier;
import kotlin.metadata.KmConstantValue;
import kotlin.metadata.KmConstructor;
import kotlin.metadata.KmContract;
import kotlin.metadata.KmDeclarationContainer;
import kotlin.metadata.KmEffect;
import kotlin.metadata.KmEffectExpression;
import kotlin.metadata.KmEffectInvocationKind;
import kotlin.metadata.KmEffectType;
import kotlin.metadata.KmFlexibleTypeUpperBound;
import kotlin.metadata.KmFunction;
import kotlin.metadata.KmLambda;
import kotlin.metadata.KmPackage;
import kotlin.metadata.KmProperty;
import kotlin.metadata.KmPropertyAccessorAttributes;
import kotlin.metadata.KmType;
import kotlin.metadata.KmTypeAlias;
import kotlin.metadata.KmTypeParameter;
import kotlin.metadata.KmTypeProjection;
import kotlin.metadata.KmValueParameter;
import kotlin.metadata.KmVariance;
import kotlin.metadata.KmVersion;
import kotlin.metadata.KmVersionRequirement;
import kotlin.metadata.KmVersionRequirementLevel;
import kotlin.metadata.KmVersionRequirementVersionKind;
import kotlin.metadata.MemberKind;
import kotlin.metadata.Modality;
import kotlin.metadata.Visibility;
import kotlin.metadata.jvm.JvmAttributes;
import kotlin.metadata.jvm.JvmExtensionsKt;
import kotlin.metadata.jvm.JvmFieldSignature;
import kotlin.metadata.jvm.JvmMetadataUtil;
import kotlin.metadata.jvm.JvmMetadataVersion;
import kotlin.metadata.jvm.JvmMethodSignature;
import kotlin.metadata.jvm.KotlinClassMetadata;
import proguard.classfile.Clazz;
import proguard.classfile.FieldSignature;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AllElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinTypeVariance;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.flags.KotlinClassFlags;
import proguard.classfile.kotlin.flags.KotlinConstructorFlags;
import proguard.classfile.kotlin.flags.KotlinFunctionFlags;
import proguard.classfile.kotlin.flags.KotlinModalityFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyFlags;
import proguard.classfile.kotlin.flags.KotlinValueParameterFlags;
import proguard.classfile.kotlin.flags.KotlinVisibilityFlags;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinContractVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectExprVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinVersionRequirementVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.util.kotlin.AnnotationConstructor;
import proguard.classfile.util.kotlin.KotlinMetadataType;
import proguard.classfile.visitor.ClassVisitor;

public class KotlinMetadataWriter
implements ClassVisitor,
KotlinMetadataVisitor,
ElementValueVisitor {
    private final ClassVisitor extraClassVisitor;
    private int metadataKind;
    private int[] metadataVersion;
    private String[] data1;
    private String[] data2;
    private int extraInt;
    private String extraString;
    private String packageName;
    private ConstantPoolEditor constantPoolEditor;
    private final ConstantPoolShrinker constantPoolShrinker = new ConstantPoolShrinker();
    private KotlinMetadataType currentType;
    private final BiConsumer<Clazz, String> errorHandler;
    public static final KotlinMetadataVersion HIGHEST_ALLOWED_TO_WRITE = new KotlinMetadataVersion(JvmMetadataVersion.HIGHEST_ALLOWED_TO_WRITE.toIntArray());
    public static final KotlinMetadataVersion LATEST_STABLE_SUPPORTED = new KotlinMetadataVersion(JvmMetadataVersion.LATEST_STABLE_SUPPORTED.toIntArray());
    private KotlinMetadataVersion version;

    @Deprecated
    public KotlinMetadataWriter(WarningPrinter warningPrinter) {
        this(warningPrinter, null);
    }

    @Deprecated
    public KotlinMetadataWriter(WarningPrinter warningPrinter, ClassVisitor extraClassVisitor) {
        this((Clazz clazz, String message) -> warningPrinter.print(clazz.getName(), (String)message), extraClassVisitor);
    }

    public KotlinMetadataWriter(BiConsumer<Clazz, String> errorHandler) {
        this(errorHandler, null);
    }

    public KotlinMetadataWriter(BiConsumer<Clazz, String> errorHandler, ClassVisitor extraClassVisitor) {
        this.errorHandler = errorHandler;
        this.extraClassVisitor = extraClassVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        clazz.kotlinMetadataAccept(this);
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        KotlinMetadataVersion originalVersion = new KotlinMetadataVersion(kotlinMetadata.mv);
        this.version = originalVersion.canBeWritten() ? originalVersion : LATEST_STABLE_SUPPORTED;
        switch (kotlinMetadata.k) {
            case 1: {
                kotlinMetadata.accept(clazz, new KotlinClassConstructor());
                break;
            }
            case 2: {
                kotlinMetadata.accept(clazz, new KotlinFileFacadeConstructor());
                break;
            }
            case 3: {
                kotlinMetadata.accept(clazz, new KotlinSyntheticClassConstructor());
                break;
            }
            case 4: {
                kotlinMetadata.accept(clazz, new KotlinMultiFileFacadeConstructor());
                break;
            }
            case 5: {
                kotlinMetadata.accept(clazz, new KotlinMultiFilePartConstructor());
                break;
            }
        }
        Metadata metadata = JvmMetadataUtil.Metadata((Integer)this.metadataKind, (int[])this.metadataVersion, (String[])this.data1, (String[])this.data2, (String)this.extraString, (String)this.packageName, (Integer)this.extraInt);
        try {
            KotlinClassMetadata.readStrict((Metadata)metadata);
        }
        catch (IllegalArgumentException e) {
            String versionString = this.metadataVersion == null ? "unknown" : Arrays.stream(this.metadataVersion).mapToObj(Integer::toString).collect(Collectors.joining("."));
            this.errorHandler.accept(clazz, "Encountered corrupt Kotlin metadata in class " + clazz.getName() + " (version " + versionString + "). Not processing the metadata for this class.");
            return;
        }
        this.constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
        try {
            clazz.accept(new AllAttributeVisitor(new AttributeNameFilter("RuntimeVisibleAnnotations", (AttributeVisitor)new AllAnnotationVisitor(new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)new AllElementValueVisitor(this))))));
        }
        catch (IllegalArgumentException e) {
            this.errorHandler.accept(clazz, "Invalid Kotlin metadata annotation for " + clazz.getName() + " (invalid Kotlin metadata field names). Not writing the metadata for this class.");
        }
        clazz.accept(this.constantPoolShrinker);
        if (this.extraClassVisitor != null) {
            clazz.accept(this.extraClassVisitor);
        }
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.currentType = KotlinMetadataType.valueOf(constantElementValue.getMethodName(clazz));
        switch (this.currentType) {
            case k: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addIntegerConstant(this.metadataKind);
                break;
            }
            case xi: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addIntegerConstant(this.extraInt);
                break;
            }
            case xs: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addUtf8Constant(this.extraString);
                break;
            }
            case pn: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addUtf8Constant(this.packageName);
                break;
            }
        }
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.currentType = KotlinMetadataType.valueOf(arrayElementValue.getMethodName(clazz));
        switch (this.currentType) {
            case mv: {
                arrayElementValue.u2elementValuesCount = this.metadataVersion.length;
                ElementValue[] newMvElementValues = new ElementValue[this.metadataVersion.length];
                for (int k = 0; k < this.metadataVersion.length; ++k) {
                    newMvElementValues[k] = new ConstantElementValue('I', 0, this.constantPoolEditor.addIntegerConstant(this.metadataVersion[k]));
                }
                arrayElementValue.elementValues = newMvElementValues;
                break;
            }
            case d1: {
                arrayElementValue.u2elementValuesCount = this.data1.length;
                ElementValue[] newD1ElementValues = new ElementValue[this.data1.length];
                for (int k = 0; k < this.data1.length; ++k) {
                    newD1ElementValues[k] = new ConstantElementValue('s', 0, this.constantPoolEditor.addUtf8Constant(this.data1[k]));
                }
                arrayElementValue.elementValues = newD1ElementValues;
                break;
            }
            case d2: {
                arrayElementValue.u2elementValuesCount = this.data2.length;
                ElementValue[] newD2ElementValues = new ElementValue[this.data2.length];
                for (int k = 0; k < this.data2.length; ++k) {
                    newD2ElementValues[k] = new ConstantElementValue('s', 0, this.constantPoolEditor.addUtf8Constant(this.data2[k]));
                }
                arrayElementValue.elementValues = newD2ElementValues;
                break;
            }
        }
    }

    private static JvmMethodSignature convertMethodSignature(MethodSignature methodSignature) {
        if (methodSignature == null) {
            return null;
        }
        return new JvmMethodSignature(methodSignature.method, methodSignature.descriptor.toString());
    }

    private static KmVariance convertTypeVariance(KotlinTypeVariance typeVariance) {
        switch (typeVariance) {
            case IN: {
                return KmVariance.IN;
            }
            case INVARIANT: {
                return KmVariance.INVARIANT;
            }
            case OUT: {
                return KmVariance.OUT;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVariance.");
    }

    private static Visibility convertVisibilityFlags(KotlinVisibilityFlags visibilityFlags) {
        if (visibilityFlags.isInternal) {
            return Visibility.INTERNAL;
        }
        if (visibilityFlags.isLocal) {
            return Visibility.LOCAL;
        }
        if (visibilityFlags.isPrivate) {
            return Visibility.PRIVATE;
        }
        if (visibilityFlags.isProtected) {
            return Visibility.PROTECTED;
        }
        if (visibilityFlags.isPublic) {
            return Visibility.PUBLIC;
        }
        return Visibility.PRIVATE_TO_THIS;
    }

    private static Modality convertModalityFlags(KotlinModalityFlags flags) {
        if (flags.isAbstract) {
            return Modality.ABSTRACT;
        }
        if (flags.isFinal) {
            return Modality.FINAL;
        }
        if (flags.isOpen) {
            return Modality.OPEN;
        }
        return Modality.SEALED;
    }

    private static KmFunction convertFunction(KotlinFunctionMetadata functionMetadata) {
        KmFunction kmFunction = new KmFunction(functionMetadata.name);
        KotlinFunctionFlags flags = functionMetadata.flags;
        Attributes.setVisibility((KmFunction)kmFunction, (Visibility)KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
        Attributes.setModality((KmFunction)kmFunction, (Modality)KotlinMetadataWriter.convertModalityFlags(flags.modality));
        if (flags.isDeclaration) {
            Attributes.setKind((KmFunction)kmFunction, (MemberKind)MemberKind.DECLARATION);
        }
        if (flags.isFakeOverride) {
            Attributes.setKind((KmFunction)kmFunction, (MemberKind)MemberKind.FAKE_OVERRIDE);
        }
        if (flags.isDelegation) {
            Attributes.setKind((KmFunction)kmFunction, (MemberKind)MemberKind.DELEGATION);
        }
        if (flags.isSynthesized) {
            Attributes.setKind((KmFunction)kmFunction, (MemberKind)MemberKind.SYNTHESIZED);
        }
        Attributes.setHasAnnotations((KmFunction)kmFunction, (boolean)flags.hasAnnotations);
        Attributes.setOperator((KmFunction)kmFunction, (boolean)flags.isOperator);
        Attributes.setInfix((KmFunction)kmFunction, (boolean)flags.isInfix);
        Attributes.setInline((KmFunction)kmFunction, (boolean)flags.isInline);
        Attributes.setTailrec((KmFunction)kmFunction, (boolean)flags.isTailrec);
        Attributes.setExternal((KmFunction)kmFunction, (boolean)flags.isExternal);
        Attributes.setSuspend((KmFunction)kmFunction, (boolean)flags.isSuspend);
        return kmFunction;
    }

    private static KmProperty convertProperty(KotlinPropertyMetadata propertyMetadata) {
        KmPropertyAccessorAttributes kmPropertyAccessorAttributes;
        KmProperty kmProperty = new KmProperty(propertyMetadata.name);
        KotlinPropertyFlags flags = propertyMetadata.flags;
        Attributes.setVisibility((KmProperty)kmProperty, (Visibility)KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
        Attributes.setModality((KmProperty)kmProperty, (Modality)KotlinMetadataWriter.convertModalityFlags(flags.modality));
        if (flags.isDeclared) {
            Attributes.setKind((KmProperty)kmProperty, (MemberKind)MemberKind.DECLARATION);
        }
        if (flags.isFakeOverride) {
            Attributes.setKind((KmProperty)kmProperty, (MemberKind)MemberKind.FAKE_OVERRIDE);
        }
        if (flags.isDelegation) {
            Attributes.setKind((KmProperty)kmProperty, (MemberKind)MemberKind.DELEGATION);
        }
        if (flags.isSynthesized) {
            Attributes.setKind((KmProperty)kmProperty, (MemberKind)MemberKind.SYNTHESIZED);
        }
        Attributes.setHasAnnotations((KmProperty)kmProperty, (boolean)flags.hasAnnotations);
        Attributes.setVar((KmProperty)kmProperty, (boolean)flags.isVar);
        Attributes.setConst((KmProperty)kmProperty, (boolean)flags.isConst);
        Attributes.setLateinit((KmProperty)kmProperty, (boolean)flags.isLateinit);
        Attributes.setHasConstant((KmProperty)kmProperty, (boolean)flags.hasConstant);
        Attributes.setExternal((KmProperty)kmProperty, (boolean)flags.isExternal);
        Attributes.setDelegated((KmProperty)kmProperty, (boolean)flags.isDelegated);
        Attributes.setExpect((KmProperty)kmProperty, (boolean)flags.isExpect);
        if (propertyMetadata.setterFlags != null) {
            kmPropertyAccessorAttributes = new KmPropertyAccessorAttributes();
            Attributes.setVisibility((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (Visibility)KotlinMetadataWriter.convertVisibilityFlags(propertyMetadata.setterFlags.visibility));
            Attributes.setModality((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (Modality)KotlinMetadataWriter.convertModalityFlags(propertyMetadata.setterFlags.modality));
            Attributes.setHasAnnotations((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (boolean)propertyMetadata.setterFlags.hasAnnotations);
            Attributes.setNotDefault((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (!propertyMetadata.setterFlags.isDefault ? 1 : 0) != 0);
            Attributes.setInline((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (boolean)propertyMetadata.setterFlags.isInline);
            Attributes.setExternal((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (boolean)propertyMetadata.setterFlags.isExternal);
            kmProperty.setSetter(kmPropertyAccessorAttributes);
        }
        if (propertyMetadata.getterFlags != null) {
            kmPropertyAccessorAttributes = kmProperty.getGetter();
            Attributes.setVisibility((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (Visibility)KotlinMetadataWriter.convertVisibilityFlags(propertyMetadata.getterFlags.visibility));
            Attributes.setModality((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (Modality)KotlinMetadataWriter.convertModalityFlags(propertyMetadata.getterFlags.modality));
            Attributes.setHasAnnotations((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (boolean)propertyMetadata.getterFlags.hasAnnotations);
            Attributes.setNotDefault((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (!propertyMetadata.getterFlags.isDefault ? 1 : 0) != 0);
            Attributes.setInline((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (boolean)propertyMetadata.getterFlags.isInline);
            Attributes.setExternal((KmPropertyAccessorAttributes)kmPropertyAccessorAttributes, (boolean)propertyMetadata.getterFlags.isExternal);
        }
        return kmProperty;
    }

    static /* synthetic */ int[] access$902(KotlinMetadataWriter x0, int[] x1) {
        x0.metadataVersion = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1002(KotlinMetadataWriter x0, String[] x1) {
        x0.data1 = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1102(KotlinMetadataWriter x0, String[] x1) {
        x0.data2 = x1;
        return x1;
    }

    private static class VersionRequirementConstructor
    implements KotlinVersionRequirementVisitor {
        private KmVersionRequirement kmVersionRequirement;
        private KmConstructor kmConstructor;
        private KmClass kmClass;
        private KmProperty kmProperty;
        private KmFunction kmFunction;
        private KmTypeAlias kmTypeAlias;

        VersionRequirementConstructor(KmConstructor kmConstructor) {
            this.kmConstructor = kmConstructor;
        }

        VersionRequirementConstructor(KmClass kmClass) {
            this.kmClass = kmClass;
        }

        VersionRequirementConstructor(KmProperty kmProperty) {
            this.kmProperty = kmProperty;
        }

        VersionRequirementConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        VersionRequirementConstructor(KmTypeAlias kmTypeAlias) {
            this.kmTypeAlias = kmTypeAlias;
        }

        @Override
        public void visitClassVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmClass.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitConstructorVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmConstructor.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitPropertyVersionRequirement(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmProperty.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitFunctionVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmFunction.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitTypeAliasVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmTypeAlias.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitAnyVersionRequirement(Clazz clazz, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            switch (kotlinVersionRequirementMetadata.kind) {
                case API_VERSION: {
                    this.kmVersionRequirement.kind = KmVersionRequirementVersionKind.API_VERSION;
                    break;
                }
                case COMPILER_VERSION: {
                    this.kmVersionRequirement.kind = KmVersionRequirementVersionKind.COMPILER_VERSION;
                    break;
                }
                case LANGUAGE_VERSION: {
                    this.kmVersionRequirement.kind = KmVersionRequirementVersionKind.LANGUAGE_VERSION;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Encountered unknown enum value for KotlinVersionRequirementVersionKind.");
                }
            }
            switch (kotlinVersionRequirementMetadata.level) {
                case ERROR: {
                    this.kmVersionRequirement.level = KmVersionRequirementLevel.ERROR;
                    break;
                }
                case HIDDEN: {
                    this.kmVersionRequirement.level = KmVersionRequirementLevel.HIDDEN;
                    break;
                }
                case WARNING: {
                    this.kmVersionRequirement.level = KmVersionRequirementLevel.WARNING;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Encountered unknown enum value for KotlinVersionRequirementLevel.");
                }
            }
            this.kmVersionRequirement.setErrorCode(kotlinVersionRequirementMetadata.errorCode);
            this.kmVersionRequirement.setMessage(kotlinVersionRequirementMetadata.message);
            KmVersion kmVersion = new KmVersion(kotlinVersionRequirementMetadata.major, kotlinVersionRequirementMetadata.minor, kotlinVersionRequirementMetadata.patch);
            this.kmVersionRequirement.setVersion(kmVersion);
        }
    }

    private class KotlinMultiFilePartConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor {
        private final KmPackage kmPackage;

        KotlinMultiFilePartConstructor() {
            this(new KmPackage());
        }

        private KotlinMultiFilePartConstructor(KmPackage kmPackage) {
            super((KmDeclarationContainer)kmPackage);
            this.kmPackage = kmPackage;
        }

        @Override
        public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
            kotlinMultiFilePartKindMetadata.propertiesAccept(clazz, this);
            kotlinMultiFilePartKindMetadata.functionsAccept(clazz, this);
            kotlinMultiFilePartKindMetadata.typeAliasesAccept(clazz, this);
            for (KotlinPropertyMetadata propertyMetadata : kotlinMultiFilePartKindMetadata.localDelegatedProperties) {
                JvmExtensionsKt.getLocalDelegatedProperties((KmPackage)this.kmPackage).add(KotlinMetadataWriter.convertProperty(propertyMetadata));
            }
            Metadata metadata = new KotlinClassMetadata.MultiFileClassPart(this.kmPackage, kotlinMultiFilePartKindMetadata.facadeName, new JvmMetadataVersion(KotlinMetadataWriter.this.version.toArray()), kotlinMultiFilePartKindMetadata.xi).write();
            KotlinMetadataWriter.this.metadataKind = metadata.k();
            KotlinMetadataWriter.access$902(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1002(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1102(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.extraInt = metadata.xi();
            KotlinMetadataWriter.this.extraString = metadata.xs();
            KotlinMetadataWriter.this.packageName = metadata.pn();
        }
    }

    private class KotlinMultiFileFacadeConstructor
    implements KotlinMetadataVisitor {
        private KotlinMultiFileFacadeConstructor() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
            Metadata metadata = new KotlinClassMetadata.MultiFileClassFacade(kotlinMultiFileFacadeKindMetadata.partClassNames, new JvmMetadataVersion(KotlinMetadataWriter.this.version.toArray()), kotlinMultiFileFacadeKindMetadata.xi).write();
            KotlinMetadataWriter.this.metadataKind = metadata.k();
            KotlinMetadataWriter.access$902(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1002(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1102(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.extraInt = metadata.xi();
            KotlinMetadataWriter.this.extraString = metadata.xs();
            KotlinMetadataWriter.this.packageName = metadata.pn();
        }
    }

    private class KotlinSyntheticClassConstructor
    implements KotlinMetadataVisitor,
    KotlinFunctionVisitor {
        private KmLambda kmLambda = null;

        KotlinSyntheticClassConstructor() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
            if (kotlinSyntheticClassKindMetadata.flavor == KotlinSyntheticClassKindMetadata.Flavor.LAMBDA) {
                kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this);
            }
            Metadata metadata = new KotlinClassMetadata.SyntheticClass(this.kmLambda, new JvmMetadataVersion(KotlinMetadataWriter.this.version.toArray()), kotlinSyntheticClassKindMetadata.xi).write();
            KotlinMetadataWriter.this.metadataKind = metadata.k();
            KotlinMetadataWriter.access$902(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1002(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1102(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.extraInt = metadata.xi();
            KotlinMetadataWriter.this.extraString = metadata.xs();
            KotlinMetadataWriter.this.packageName = metadata.pn();
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitSyntheticFunction(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            KmFunction kmFunction = KotlinMetadataWriter.convertFunction(kotlinFunctionMetadata);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinSyntheticClassKindMetadata, new ValueParameterConstructor(kmFunction));
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeParameterConstructor(kmFunction));
            kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinSyntheticClassKindMetadata, new VersionRequirementConstructor(kmFunction));
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinSyntheticClassKindMetadata, new ContractConstructor(kmFunction));
            JvmExtensionsKt.setSignature((KmFunction)kmFunction, (JvmMethodSignature)KotlinMetadataWriter.convertMethodSignature(kotlinFunctionMetadata.jvmSignature));
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                JvmExtensionsKt.setLambdaClassOriginName((KmFunction)kmFunction, (String)kotlinFunctionMetadata.lambdaClassOriginName);
            }
            this.kmLambda = new KmLambda();
            this.kmLambda.setFunction(kmFunction);
        }
    }

    private class KotlinFileFacadeConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor {
        private KmPackage kmPackage;

        KotlinFileFacadeConstructor() {
            this(new KmPackage());
        }

        private KotlinFileFacadeConstructor(KmPackage kmPackage) {
            super((KmDeclarationContainer)kmPackage);
            this.kmPackage = kmPackage;
        }

        @Override
        public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
            kotlinFileFacadeKindMetadata.propertiesAccept(clazz, this);
            kotlinFileFacadeKindMetadata.functionsAccept(clazz, this);
            kotlinFileFacadeKindMetadata.typeAliasesAccept(clazz, this);
            for (KotlinPropertyMetadata propertyMetadata : kotlinFileFacadeKindMetadata.localDelegatedProperties) {
                JvmExtensionsKt.getLocalDelegatedProperties((KmPackage)this.kmPackage).add(KotlinMetadataWriter.convertProperty(propertyMetadata));
            }
            Metadata metadata = new KotlinClassMetadata.FileFacade(this.kmPackage, new JvmMetadataVersion(KotlinMetadataWriter.this.version.toArray()), kotlinFileFacadeKindMetadata.xi).write();
            KotlinMetadataWriter.this.metadataKind = metadata.k();
            KotlinMetadataWriter.access$902(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1002(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1102(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.extraInt = metadata.xi();
            KotlinMetadataWriter.this.extraString = metadata.xs();
            KotlinMetadataWriter.this.packageName = metadata.pn();
        }
    }

    private static class TypeParameterConstructor
    implements KotlinTypeParameterVisitor {
        private KmTypeParameter kmTypeParameter;
        private KmClass kmClass;
        private KmProperty kmProperty;
        private KmFunction kmFunction;
        private KmTypeAlias kmTypeAlias;

        TypeParameterConstructor(KmClass kmClass) {
            this.kmClass = kmClass;
        }

        TypeParameterConstructor(KmProperty kmProperty) {
            this.kmProperty = kmProperty;
        }

        TypeParameterConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        TypeParameterConstructor(KmTypeAlias kmTypeAlias) {
            this.kmTypeAlias = kmTypeAlias;
        }

        @Override
        public void visitClassTypeParameter(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kmTypeParameter = TypeParameterConstructor.convertTypeParameter(kotlinTypeParameterMetadata);
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
            this.kmClass.getTypeParameters().add(this.kmTypeParameter);
        }

        @Override
        public void visitPropertyTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kmTypeParameter = TypeParameterConstructor.convertTypeParameter(kotlinTypeParameterMetadata);
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
            this.kmProperty.getTypeParameters().add(this.kmTypeParameter);
        }

        @Override
        public void visitFunctionTypeParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kmTypeParameter = TypeParameterConstructor.convertTypeParameter(kotlinTypeParameterMetadata);
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
            this.kmFunction.getTypeParameters().add(this.kmTypeParameter);
        }

        @Override
        public void visitAliasTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kmTypeParameter = TypeParameterConstructor.convertTypeParameter(kotlinTypeParameterMetadata);
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
            this.kmTypeAlias.getTypeParameters().add(this.kmTypeParameter);
        }

        @Override
        public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            kotlinTypeParameterMetadata.upperBoundsAccept(clazz, new TypeConstructor(this.kmTypeParameter));
            kotlinTypeParameterMetadata.annotationsAccept(clazz, new AnnotationConstructor(kmAnnotation -> JvmExtensionsKt.getAnnotations((KmTypeParameter)this.kmTypeParameter).add(kmAnnotation)));
        }

        private static KmTypeParameter convertTypeParameter(KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            KmTypeParameter kmTypeParameter = new KmTypeParameter(kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, KotlinMetadataWriter.convertTypeVariance(kotlinTypeParameterMetadata.variance));
            Attributes.setReified((KmTypeParameter)kmTypeParameter, (boolean)kotlinTypeParameterMetadata.flags.isReified);
            return kmTypeParameter;
        }
    }

    private static class TypeConstructor
    implements KotlinTypeVisitor {
        private KmType kmType;
        private KmType nestedKmType;
        private KmValueParameter kmValueParameter;
        private KmClass kmClass;
        private KmProperty kmProperty;
        private KmFunction kmFunction;
        private KmTypeAlias kmTypeAlias;
        private KmTypeParameter kmTypeParameter;
        private KmEffectExpression kmEffectExpression;

        TypeConstructor(KmType nestedKmType) {
            this.nestedKmType = nestedKmType;
        }

        TypeConstructor(KmValueParameter kmValueParameter) {
            this.kmValueParameter = kmValueParameter;
        }

        TypeConstructor(KmClass kmClass) {
            this.kmClass = kmClass;
        }

        TypeConstructor(KmProperty kmProperty) {
            this.kmProperty = kmProperty;
        }

        TypeConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        TypeConstructor(KmTypeAlias kmTypeAlias) {
            this.kmTypeAlias = kmTypeAlias;
        }

        TypeConstructor(KmTypeParameter kmTypeParameter) {
            this.kmTypeParameter = kmTypeParameter;
        }

        TypeConstructor(KmEffectExpression kmEffectExpression) {
            this.kmEffectExpression = kmEffectExpression;
        }

        @Override
        public void visitTypeUpperBound(Clazz clazz, KotlinTypeMetadata boundedType, KotlinTypeMetadata upperBound) {
            this.kmType = TypeConstructor.convertType(boundedType);
            this.visitAnyType(clazz, upperBound);
            KmFlexibleTypeUpperBound kmFlexibleTypeUpperBound = new KmFlexibleTypeUpperBound(this.kmType, upperBound.flexibilityID);
            this.nestedKmType.setFlexibleTypeUpperBound(kmFlexibleTypeUpperBound);
        }

        @Override
        public void visitAbbreviation(Clazz clazz, KotlinTypeMetadata abbreviatedType, KotlinTypeMetadata abbreviation) {
            this.kmType = TypeConstructor.convertType(abbreviatedType);
            this.visitAnyType(clazz, abbreviation);
            this.nestedKmType.setAbbreviatedType(this.kmType);
        }

        @Override
        public void visitParameterUpperBound(Clazz clazz, KotlinTypeParameterMetadata boundedTypeParameter, KotlinTypeMetadata upperBound) {
            this.kmType = TypeConstructor.convertType(upperBound);
            this.visitAnyType(clazz, upperBound);
            this.kmTypeParameter.getUpperBounds().add(this.kmType);
        }

        @Override
        public void visitTypeOfIsExpression(Clazz clazz, KotlinEffectExpressionMetadata kotlinEffectExprMetadata, KotlinTypeMetadata typeOfIs) {
            this.kmType = TypeConstructor.convertType(typeOfIs);
            this.visitAnyType(clazz, typeOfIs);
            this.kmEffectExpression.setInstanceType(this.kmType);
        }

        @Override
        public void visitTypeArgument(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata, KotlinTypeMetadata typeArgument) {
            this.kmType = TypeConstructor.convertType(typeArgument);
            this.visitAnyType(clazz, typeArgument);
            KmTypeProjection kmTypeProjection = new KmTypeProjection(KotlinMetadataWriter.convertTypeVariance(typeArgument.variance), this.kmType);
            this.nestedKmType.getArguments().add(kmTypeProjection);
        }

        @Override
        public void visitStarProjection(Clazz clazz, KotlinTypeMetadata typeWithStarArg) {
            this.nestedKmType.getArguments().add(KmTypeProjection.STAR);
        }

        @Override
        public void visitOuterClass(Clazz clazz, KotlinTypeMetadata innerClass, KotlinTypeMetadata outerClass) {
            this.kmType = TypeConstructor.convertType(outerClass);
            this.visitAnyType(clazz, outerClass);
            this.nestedKmType.setOuterType(this.kmType);
        }

        @Override
        public void visitConstructorValParamType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.type = this.kmType;
        }

        @Override
        public void visitConstructorValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.type = this.kmType;
        }

        @Override
        public void visitInlineClassUnderlyingPropertyType(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            if (kotlinMetadata.underlyingPropertyName != null) {
                this.kmClass.setInlineClassUnderlyingPropertyName(kotlinMetadata.underlyingPropertyName);
            }
            if (kotlinMetadata.underlyingPropertyType != null) {
                this.kmType = TypeConstructor.convertType(kotlinMetadata.underlyingPropertyType);
                this.kmClass.setInlineClassUnderlyingType(this.kmType);
            }
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitSuperType(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmClass.getSupertypes().add(this.kmType);
        }

        @Override
        public void visitPropertyType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmProperty.returnType = this.kmType;
        }

        @Override
        public void visitPropertyReceiverType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmProperty.setReceiverParameterType(this.kmType);
        }

        @Override
        public void visitPropertyValParamType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.type = this.kmType;
        }

        @Override
        public void visitPropertyValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.setVarargElementType(this.kmType);
        }

        @Override
        public void visitFunctionReturnType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmFunction.setReturnType(this.kmType);
        }

        @Override
        public void visitFunctionReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmFunction.setReceiverParameterType(this.kmType);
        }

        @Override
        public void visitFunctionContextReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmFunction.getContextReceiverTypes().add(this.kmType);
        }

        @Override
        public void visitClassContextReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmClass.getContextReceiverTypes().add(this.kmType);
        }

        @Override
        public void visitPropertyContextReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmProperty.getContextReceiverTypes().add(this.kmType);
        }

        @Override
        public void visitFunctionValParamType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.type = this.kmType;
        }

        @Override
        public void visitFunctionValParamVarArgType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.setVarargElementType(this.kmType);
        }

        @Override
        public void visitAliasUnderlyingType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmTypeAlias.underlyingType = this.kmType;
        }

        @Override
        public void visitAliasExpandedType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = TypeConstructor.convertType(kotlinTypeMetadata);
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmTypeAlias.setExpandedType(this.kmType);
        }

        @Override
        public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
            KmClassifier.TypeParameter classifier;
            if (kotlinTypeMetadata.className != null) {
                String className = kotlinTypeMetadata.className.replace('$', '.');
                KmClassifier.Class classifier2 = new KmClassifier.Class(className);
                this.kmType.classifier = classifier2;
            }
            if (kotlinTypeMetadata.typeParamID >= 0) {
                classifier = new KmClassifier.TypeParameter(kotlinTypeMetadata.typeParamID);
                this.kmType.classifier = classifier;
            }
            if (kotlinTypeMetadata.aliasName != null) {
                classifier = new KmClassifier.TypeAlias(kotlinTypeMetadata.aliasName);
                this.kmType.classifier = classifier;
            }
            kotlinTypeMetadata.abbreviationAccept(clazz, new TypeConstructor(this.kmType));
            kotlinTypeMetadata.outerClassAccept(clazz, new TypeConstructor(this.kmType));
            kotlinTypeMetadata.typeArgumentsAccept(clazz, new TypeConstructor(this.kmType));
            kotlinTypeMetadata.upperBoundsAccept(clazz, new TypeConstructor(this.kmType));
            JvmExtensionsKt.setRaw((KmType)this.kmType, (boolean)kotlinTypeMetadata.isRaw);
            kotlinTypeMetadata.annotationsAccept(clazz, new AnnotationConstructor(kmAnnotation -> JvmExtensionsKt.getAnnotations((KmType)this.kmType).add(kmAnnotation)));
        }

        private static KmType convertType(KotlinTypeMetadata typeMetadata) {
            KmType kmType = new KmType();
            Attributes.setNullable((KmType)kmType, (boolean)typeMetadata.flags.isNullable);
            Attributes.setSuspend((KmType)kmType, (boolean)typeMetadata.flags.isSuspend);
            Attributes.setDefinitelyNonNull((KmType)kmType, (boolean)typeMetadata.flags.isDefinitelyNonNull);
            return kmType;
        }
    }

    private static class ValueParameterConstructor
    implements KotlinValueParameterVisitor {
        private KmValueParameter kmValueParameter;
        private KmConstructor kmConstructor;
        private KmProperty kmProperty;
        private KmFunction kmFunction;

        ValueParameterConstructor(KmConstructor kmConstructor) {
            this.kmConstructor = kmConstructor;
        }

        ValueParameterConstructor(KmProperty kmProperty) {
            this.kmProperty = kmProperty;
        }

        ValueParameterConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        @Override
        public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        }

        @Override
        public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.kmValueParameter = new KmValueParameter(kotlinValueParameterMetadata.parameterName);
            ValueParameterConstructor.convertValueParameterFlags(this.kmValueParameter, kotlinValueParameterMetadata.flags);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)new TypeConstructor(this.kmValueParameter));
            this.kmConstructor.getValueParameters().add(this.kmValueParameter);
        }

        @Override
        public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.kmValueParameter = new KmValueParameter(kotlinValueParameterMetadata.parameterName);
            ValueParameterConstructor.convertValueParameterFlags(this.kmValueParameter, kotlinValueParameterMetadata.flags);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)new TypeConstructor(this.kmValueParameter));
            this.kmProperty.setSetterParameter(this.kmValueParameter);
        }

        @Override
        public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.kmValueParameter = new KmValueParameter(kotlinValueParameterMetadata.parameterName);
            ValueParameterConstructor.convertValueParameterFlags(this.kmValueParameter, kotlinValueParameterMetadata.flags);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)new TypeConstructor(this.kmValueParameter));
            this.kmFunction.getValueParameters().add(this.kmValueParameter);
        }

        private static void convertValueParameterFlags(KmValueParameter kmValueParameter, KotlinValueParameterFlags flags) {
            Attributes.setHasAnnotations((KmValueParameter)kmValueParameter, (boolean)flags.hasAnnotations);
            Attributes.setDeclaresDefaultValue((KmValueParameter)kmValueParameter, (boolean)flags.hasDefaultValue);
            Attributes.setNoinline((KmValueParameter)kmValueParameter, (boolean)flags.isNoInline);
            Attributes.setCrossinline((KmValueParameter)kmValueParameter, (boolean)flags.isCrossInline);
        }
    }

    private class KotlinClassConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor,
    KotlinConstructorVisitor {
        KmClass kmClass;

        KotlinClassConstructor() {
            this(new KmClass());
        }

        private KotlinClassConstructor(KmClass kmClass) {
            super((KmDeclarationContainer)kmClass);
            this.kmClass = kmClass;
        }

        @Override
        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            this.convertClassFlags(this.kmClass, kotlinClassKindMetadata.flags);
            this.kmClass.setName(kotlinClassKindMetadata.className.replace('$', '.'));
            if (kotlinClassKindMetadata.companionObjectName != null) {
                this.kmClass.setCompanionObject(kotlinClassKindMetadata.companionObjectName);
            }
            kotlinClassKindMetadata.propertiesAccept(clazz, this);
            kotlinClassKindMetadata.functionsAccept(clazz, this);
            kotlinClassKindMetadata.typeAliasesAccept(clazz, this);
            for (String enumEntry : kotlinClassKindMetadata.enumEntryNames) {
                this.kmClass.getEnumEntries().add(enumEntry);
            }
            for (String nestedClass : kotlinClassKindMetadata.nestedClassNames) {
                this.kmClass.getNestedClasses().add(nestedClass);
            }
            for (String sealedSubClass : kotlinClassKindMetadata.sealedSubclassNames) {
                this.kmClass.getSealedSubclasses().add(sealedSubClass.replace('$', '.'));
            }
            kotlinClassKindMetadata.constructorsAccept(clazz, this);
            kotlinClassKindMetadata.superTypesAccept(clazz, new TypeConstructor(this.kmClass));
            kotlinClassKindMetadata.typeParametersAccept(clazz, new TypeParameterConstructor(this.kmClass));
            kotlinClassKindMetadata.contextReceiverTypesAccept(clazz, new TypeConstructor(this.kmClass));
            kotlinClassKindMetadata.versionRequirementAccept(clazz, new VersionRequirementConstructor(this.kmClass));
            kotlinClassKindMetadata.inlineClassUnderlyingPropertyTypeAccept(clazz, new TypeConstructor(this.kmClass));
            for (KotlinPropertyMetadata propertyMetadata : kotlinClassKindMetadata.localDelegatedProperties) {
                JvmExtensionsKt.getLocalDelegatedProperties((KmClass)this.kmClass).add(KotlinMetadataWriter.convertProperty(propertyMetadata));
            }
            if (kotlinClassKindMetadata.anonymousObjectOriginName != null) {
                JvmExtensionsKt.setAnonymousObjectOriginName((KmClass)this.kmClass, (String)kotlinClassKindMetadata.anonymousObjectOriginName);
            }
            this.convertClassFlags(this.kmClass, kotlinClassKindMetadata.flags);
            JvmAttributes.setCompiledInCompatibilityMode((KmClass)this.kmClass, (boolean)kotlinClassKindMetadata.flags.isCompiledInCompatibilityMode);
            JvmAttributes.setHasMethodBodiesInInterface((KmClass)this.kmClass, (boolean)kotlinClassKindMetadata.flags.hasMethodBodiesInInterface);
            Metadata metadata = new KotlinClassMetadata.Class(this.kmClass, new JvmMetadataVersion(KotlinMetadataWriter.this.version.toArray()), kotlinClassKindMetadata.xi).write();
            KotlinMetadataWriter.this.metadataKind = metadata.k();
            KotlinMetadataWriter.access$902(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1002(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1102(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.extraInt = metadata.xi();
            KotlinMetadataWriter.this.extraString = metadata.xs();
            KotlinMetadataWriter.this.packageName = metadata.pn();
        }

        @Override
        public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
            KmConstructor kmConstructor = this.convertConstructorFlags(kotlinConstructorMetadata.flags);
            kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, new ValueParameterConstructor(kmConstructor));
            kotlinConstructorMetadata.versionRequirementAccept(clazz, kotlinClassKindMetadata, new VersionRequirementConstructor(kmConstructor));
            if (kotlinConstructorMetadata.jvmSignature != null) {
                JvmExtensionsKt.setSignature((KmConstructor)kmConstructor, (JvmMethodSignature)KotlinMetadataWriter.convertMethodSignature(kotlinConstructorMetadata.jvmSignature));
            }
            this.kmClass.getConstructors().add(kmConstructor);
        }

        private void convertClassFlags(KmClass kmClass, KotlinClassFlags flags) {
            Attributes.setHasAnnotations((KmClass)kmClass, (boolean)flags.hasAnnotations);
            Attributes.setVisibility((KmClass)kmClass, (Visibility)KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
            Attributes.setModality((KmClass)kmClass, (Modality)KotlinMetadataWriter.convertModalityFlags(flags.modality));
            if (flags.isUsualClass) {
                Attributes.setKind((KmClass)kmClass, (ClassKind)ClassKind.CLASS);
            }
            if (flags.isInterface) {
                Attributes.setKind((KmClass)kmClass, (ClassKind)ClassKind.INTERFACE);
            }
            if (flags.isEnumClass) {
                Attributes.setKind((KmClass)kmClass, (ClassKind)ClassKind.ENUM_CLASS);
            }
            if (flags.isEnumEntry) {
                Attributes.setKind((KmClass)kmClass, (ClassKind)ClassKind.ENUM_ENTRY);
            }
            if (flags.isAnnotationClass) {
                Attributes.setKind((KmClass)kmClass, (ClassKind)ClassKind.ANNOTATION_CLASS);
            }
            if (flags.isObject) {
                Attributes.setKind((KmClass)kmClass, (ClassKind)ClassKind.OBJECT);
            }
            if (flags.isCompanionObject) {
                Attributes.setKind((KmClass)kmClass, (ClassKind)ClassKind.COMPANION_OBJECT);
            }
            Attributes.setInner((KmClass)kmClass, (boolean)flags.isInner);
            Attributes.setData((KmClass)kmClass, (boolean)flags.isData);
            Attributes.setExternal((KmClass)kmClass, (boolean)flags.isExternal);
            Attributes.setExpect((KmClass)kmClass, (boolean)flags.isExpect);
            Attributes.setValue((KmClass)kmClass, (boolean)flags.isValue);
            Attributes.setFunInterface((KmClass)kmClass, (boolean)flags.isFun);
        }

        private KmConstructor convertConstructorFlags(KotlinConstructorFlags flags) {
            KmConstructor kmConstructor = new KmConstructor();
            Attributes.setHasAnnotations((KmConstructor)kmConstructor, (boolean)flags.hasAnnotations);
            Attributes.setVisibility((KmConstructor)kmConstructor, (Visibility)KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
            Attributes.setSecondary((KmConstructor)kmConstructor, (boolean)flags.isSecondary);
            Attributes.setHasNonStableParameterNames((KmConstructor)kmConstructor, (boolean)flags.hasNonStableParameterNames);
            return kmConstructor;
        }
    }

    private static class KotlinDeclarationContainerConstructor
    implements KotlinPropertyVisitor,
    KotlinFunctionVisitor,
    KotlinTypeAliasVisitor {
        KmDeclarationContainer kmDeclarationContainer;
        KmProperty kmProperty;

        KotlinDeclarationContainerConstructor(KmDeclarationContainer kmDeclarationContainer) {
            this.kmDeclarationContainer = kmDeclarationContainer;
        }

        @Override
        public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmProperty));
            kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmProperty));
            kotlinPropertyMetadata.contextReceiverTypesAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmProperty));
            kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, new ValueParameterConstructor(this.kmProperty));
            kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(this.kmProperty));
            kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(this.kmProperty));
            JvmAttributes.setMovedFromInterfaceCompanion((KmProperty)this.kmProperty, (boolean)kotlinPropertyMetadata.flags.isMovedFromInterfaceCompanion);
            JvmExtensionsKt.setGetterSignature((KmProperty)this.kmProperty, (JvmMethodSignature)KotlinMetadataWriter.convertMethodSignature(kotlinPropertyMetadata.getterSignature));
            JvmExtensionsKt.setSetterSignature((KmProperty)this.kmProperty, (JvmMethodSignature)KotlinMetadataWriter.convertMethodSignature(kotlinPropertyMetadata.setterSignature));
            JvmExtensionsKt.setFieldSignature((KmProperty)this.kmProperty, (JvmFieldSignature)KotlinDeclarationContainerConstructor.convertFieldSignature(kotlinPropertyMetadata.backingFieldSignature));
            if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
                JvmExtensionsKt.setSyntheticMethodForAnnotations((KmProperty)this.kmProperty, (JvmMethodSignature)KotlinMetadataWriter.convertMethodSignature(kotlinPropertyMetadata.syntheticMethodForAnnotations));
            }
            if (kotlinPropertyMetadata.syntheticMethodForDelegate != null) {
                JvmExtensionsKt.setSyntheticMethodForDelegate((KmProperty)this.kmProperty, (JvmMethodSignature)KotlinMetadataWriter.convertMethodSignature(kotlinPropertyMetadata.syntheticMethodForDelegate));
            }
        }

        @Override
        public void visitProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kmProperty = KotlinMetadataWriter.convertProperty(kotlinPropertyMetadata);
            this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
            this.kmDeclarationContainer.getProperties().add(this.kmProperty);
        }

        @Override
        public void visitDelegatedProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kmProperty = KotlinMetadataWriter.convertProperty(kotlinPropertyMetadata);
            this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
            this.kmDeclarationContainer.getProperties().add(this.kmProperty);
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            KmFunction kmFunction = KotlinMetadataWriter.convertFunction(kotlinFunctionMetadata);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinDeclarationContainerMetadata, new ValueParameterConstructor(kmFunction));
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.contextReceiverTypesAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(kmFunction));
            kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(kmFunction));
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinDeclarationContainerMetadata, new ContractConstructor(kmFunction));
            JvmExtensionsKt.setSignature((KmFunction)kmFunction, (JvmMethodSignature)KotlinMetadataWriter.convertMethodSignature(kotlinFunctionMetadata.jvmSignature));
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                JvmExtensionsKt.setLambdaClassOriginName((KmFunction)kmFunction, (String)kotlinFunctionMetadata.lambdaClassOriginName);
            }
            this.kmDeclarationContainer.getFunctions().add(kmFunction);
        }

        @Override
        public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            KmTypeAlias kmTypeAlias = KotlinDeclarationContainerConstructor.convertTypeAlias(kotlinTypeAliasMetadata);
            kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(kmTypeAlias));
            kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmTypeAlias));
            kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmTypeAlias));
            kotlinTypeAliasMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(kmTypeAlias));
            kotlinTypeAliasMetadata.annotationsAccept(clazz, new AnnotationConstructor(kmAnnotation -> kmTypeAlias.getAnnotations().add(kmAnnotation)));
            this.kmDeclarationContainer.getTypeAliases().add(kmTypeAlias);
        }

        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        private static KmTypeAlias convertTypeAlias(KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            KmTypeAlias kmTypeAlias = new KmTypeAlias(kotlinTypeAliasMetadata.name);
            Attributes.setVisibility((KmTypeAlias)kmTypeAlias, (Visibility)KotlinMetadataWriter.convertVisibilityFlags(kotlinTypeAliasMetadata.flags.visibility));
            Attributes.setHasAnnotations((KmTypeAlias)kmTypeAlias, (boolean)kotlinTypeAliasMetadata.flags.hasAnnotations);
            return kmTypeAlias;
        }

        private static JvmFieldSignature convertFieldSignature(FieldSignature fieldSignature) {
            if (fieldSignature == null) {
                return null;
            }
            return new JvmFieldSignature(fieldSignature.memberName, fieldSignature.descriptor);
        }
    }

    private static class EffectExprConstructor
    implements KotlinEffectExprVisitor {
        private KmEffectExpression kmEffectExpression;
        private KmEffect kmEffect;
        private KmEffectExpression nestedKmEffectExpression;

        private EffectExprConstructor(KmEffect kmEffect) {
            this.kmEffect = kmEffect;
        }

        private EffectExprConstructor(KmEffectExpression nestedKmEffectExpression) {
            this.nestedKmEffectExpression = nestedKmEffectExpression;
        }

        @Override
        public void visitAnyEffectExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.kmEffectExpression.setParameterIndex(Integer.valueOf(kotlinEffectExpressionMetadata.parameterIndex));
            Attributes.setNegated((KmEffectExpression)this.kmEffectExpression, (boolean)kotlinEffectExpressionMetadata.flags.isNegated);
            Attributes.setNullCheckPredicate((KmEffectExpression)this.kmEffectExpression, (boolean)kotlinEffectExpressionMetadata.flags.isNullCheckPredicate);
            if (kotlinEffectExpressionMetadata.hasConstantValue) {
                this.kmEffectExpression.setConstantValue(new KmConstantValue(kotlinEffectExpressionMetadata.constantValue));
            }
            kotlinEffectExpressionMetadata.andRightHandSideAccept(clazz, kotlinEffectMetadata, new EffectExprConstructor(this.kmEffectExpression));
            kotlinEffectExpressionMetadata.orRightHandSideAccept(clazz, kotlinEffectMetadata, new EffectExprConstructor(this.kmEffectExpression));
            kotlinEffectExpressionMetadata.typeOfIsAccept(clazz, new TypeConstructor(this.kmEffectExpression));
        }

        @Override
        public void visitAndRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
            this.kmEffectExpression = new KmEffectExpression();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
            this.nestedKmEffectExpression.getAndArguments().addAll(this.kmEffectExpression.getAndArguments());
        }

        @Override
        public void visitOrRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
            this.kmEffectExpression = new KmEffectExpression();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
            this.nestedKmEffectExpression.getOrArguments().addAll(this.kmEffectExpression.getOrArguments());
        }

        @Override
        public void visitConstructorArgExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.kmEffectExpression = new KmEffectExpression();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, kotlinEffectExpressionMetadata);
            this.kmEffect.getConstructorArguments().add(this.kmEffectExpression);
        }

        @Override
        public void visitConclusionExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.kmEffectExpression = new KmEffectExpression();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, kotlinEffectExpressionMetadata);
            this.kmEffect.setConclusion(this.kmEffectExpression);
        }
    }

    private static class EffectConstructor
    implements KotlinEffectVisitor {
        private KmContract kmContract;

        private EffectConstructor(KmContract kmContract) {
            this.kmContract = kmContract;
        }

        @Override
        public void visitEffect(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata, KotlinEffectMetadata kotlinEffectMetadata) {
            KmEffectType effectType;
            switch (kotlinEffectMetadata.effectType) {
                case CALLS: {
                    effectType = KmEffectType.CALLS;
                    break;
                }
                case RETURNS_CONSTANT: {
                    effectType = KmEffectType.RETURNS_CONSTANT;
                    break;
                }
                case RETURNS_NOT_NULL: {
                    effectType = KmEffectType.RETURNS_NOT_NULL;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Encountered unknown enum value for KotlinEffectType.");
                }
            }
            KmEffectInvocationKind effectInvocationKind = null;
            if (kotlinEffectMetadata.invocationKind != null) {
                switch (kotlinEffectMetadata.invocationKind) {
                    case AT_MOST_ONCE: {
                        effectInvocationKind = KmEffectInvocationKind.AT_MOST_ONCE;
                        break;
                    }
                    case EXACTLY_ONCE: {
                        effectInvocationKind = KmEffectInvocationKind.EXACTLY_ONCE;
                        break;
                    }
                    case AT_LEAST_ONCE: {
                        effectInvocationKind = KmEffectInvocationKind.AT_LEAST_ONCE;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Encountered unknown enum value for KmEffectInvocationKind.");
                    }
                }
            }
            KmEffect kmEffect = new KmEffect(effectType, effectInvocationKind);
            kotlinEffectMetadata.conclusionOfConditionalEffectAccept(clazz, new EffectExprConstructor(kmEffect));
            kotlinEffectMetadata.constructorArgumentAccept(clazz, new EffectExprConstructor(kmEffect));
            this.kmContract.getEffects().add(kmEffect);
        }
    }

    private static class ContractConstructor
    implements KotlinContractVisitor {
        private KmFunction kmFunction;

        ContractConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        @Override
        public void visitContract(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata) {
            KmContract kmContract = new KmContract();
            kotlinContractMetadata.effectsAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, new EffectConstructor(kmContract));
            this.kmFunction.setContract(kmContract);
        }
    }
}

