/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.dataflow.AutoValue_AccessPath;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.checkerframework.errorprone.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.errorprone.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.errorprone.javacutil.TreeUtils;
import org.jspecify.annotations.Nullable;

@AutoValue
public abstract class AccessPath {
    public abstract @Nullable Element base();

    public abstract ImmutableList<String> path();

    private static AccessPath create(@Nullable Element base, ImmutableList<String> path) {
        return new AutoValue_AccessPath(base, path);
    }

    public static boolean isAutoValueAccessor(Tree tree) {
        Type type;
        if (!(tree instanceof MethodInvocationTree)) {
            return false;
        }
        JCTree.JCMethodInvocation invocationTree = (JCTree.JCMethodInvocation)tree;
        JCTree.JCExpression methodSelect = invocationTree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)methodSelect;
            type = jCFieldAccess.selected.type;
        } else {
            type = ((JCTree.JCIdent)methodSelect).sym.owner.type;
        }
        Type rcvrType = type;
        return ((List)invocationTree.getArguments()).isEmpty() && TreeUtils.elementFromUse((MethodInvocationTree)invocationTree).getModifiers().contains((Object)Modifier.ABSTRACT) && rcvrType.tsym.getKind() == ElementKind.CLASS && MoreAnnotations.getDeclarationAndTypeAttributes(rcvrType.tsym).map(Object::toString).anyMatch("@com.google.auto.value.AutoValue"::equals);
    }

    public static @Nullable AccessPath fromFieldAccess(FieldAccessNode fieldAccess) {
        IdentifierTree id;
        boolean isFieldAccess;
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        Tree tree = fieldAccess.getTree();
        while ((isFieldAccess = TreeUtils.isFieldAccess((Tree)tree)) || AccessPath.isAutoValueAccessor(tree)) {
            if (isFieldAccess) {
                pathBuilder.add((Object)TreeUtils.getFieldName((Tree)tree));
            } else {
                tree = ((MethodInvocationTree)tree).getMethodSelect();
                pathBuilder.add((Object)(TreeUtils.getMethodName((Tree)tree) + "()"));
            }
            if (tree instanceof IdentifierTree) {
                return AccessPath.create(null, (ImmutableList<String>)pathBuilder.build());
            }
            tree = ((MemberSelectTree)tree).getExpression();
        }
        if (tree instanceof IdentifierTree && (id = (IdentifierTree)tree).getName().contentEquals("this")) {
            return AccessPath.create(null, (ImmutableList<String>)pathBuilder.build());
        }
        if (tree instanceof IdentifierTree) {
            return AccessPath.create(TreeUtils.elementFromTree((Tree)tree), (ImmutableList<String>)pathBuilder.build());
        }
        return null;
    }

    public static AccessPath fromLocalVariable(LocalVariableNode node) {
        return AccessPath.create(node.getElement(), (ImmutableList<String>)ImmutableList.of());
    }

    public static AccessPath fromVariableDecl(VariableDeclarationNode node) {
        return AccessPath.create(TreeUtils.elementFromDeclaration((VariableTree)node.getTree()), (ImmutableList<String>)ImmutableList.of());
    }

    public static @Nullable AccessPath fromNodeIfTrackable(Node node) {
        if (node instanceof LocalVariableNode) {
            LocalVariableNode localVariableNode = (LocalVariableNode)node;
            return AccessPath.fromLocalVariable(localVariableNode);
        }
        if (node instanceof VariableDeclarationNode) {
            VariableDeclarationNode variableDeclarationNode = (VariableDeclarationNode)node;
            return AccessPath.fromVariableDecl(variableDeclarationNode);
        }
        if (node instanceof FieldAccessNode) {
            FieldAccessNode fieldAccessNode = (FieldAccessNode)node;
            return AccessPath.fromFieldAccess(fieldAccessNode);
        }
        if (node instanceof AssignmentNode) {
            AssignmentNode assignmentNode = (AssignmentNode)node;
            return AccessPath.fromNodeIfTrackable(assignmentNode.getTarget());
        }
        return null;
    }
}

