/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.PackageSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineVisibility;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineAnnotationMirror;
import com.google.turbine.processing.TurbineElement;
import com.google.turbine.processing.TurbineName;
import com.google.turbine.processing.TurbineTypeMirror;
import com.google.turbine.processing.TurbineTypes;
import com.google.turbine.type.AnnoInfo;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.jspecify.annotations.Nullable;

public class TurbineElements
implements Elements {
    private final ModelFactory factory;
    private final TurbineTypes types;

    public TurbineElements(ModelFactory factory, TurbineTypes types) {
        this.factory = factory;
        this.types = types;
    }

    private static Symbol asSymbol(Element element) {
        if (!(element instanceof TurbineElement)) {
            throw new IllegalArgumentException(element.toString());
        }
        TurbineElement turbineElement = (TurbineElement)element;
        return turbineElement.sym();
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        ImmutableList packageName;
        ImmutableList immutableList = packageName = name.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split(name));
        if (this.factory.tli().lookupPackage((Iterable<String>)packageName) == null) {
            return null;
        }
        return this.factory.packageElement(new PackageSymbol(Joiner.on((char)'/').join((Iterable)packageName)));
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        ClassSymbol sym = this.factory.inferSymbol(name);
        if (sym == null) {
            return null;
        }
        if (this.factory.getSymbol(sym) == null) {
            return null;
        }
        return this.factory.typeElement(sym);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return ((TurbineAnnotationMirror)a).getElementValuesWithDefaults();
    }

    @Override
    public String getDocComment(Element e) {
        if (!(e instanceof TurbineElement)) {
            throw new IllegalArgumentException(e.toString());
        }
        TurbineElement turbineElement = (TurbineElement)e;
        String comment = turbineElement.javadoc();
        if (comment == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String line : Splitter.on((char)'\n').split((CharSequence)comment)) {
            int start;
            if (!first) {
                sb.append('\n');
                for (start = 0; start < line.length() && CharMatcher.whitespace().matches(line.charAt(start)); ++start) {
                }
                while (start < line.length() && line.charAt(start) == '*') {
                    ++start;
                }
            }
            sb.append(line, start, line.length());
            first = false;
        }
        return sb.toString();
    }

    @Override
    public boolean isDeprecated(Element element) {
        if (!(element instanceof TurbineElement)) {
            throw new IllegalArgumentException(element.toString());
        }
        TurbineElement turbineElement = (TurbineElement)element;
        for (AnnoInfo a : turbineElement.annos()) {
            if (!a.sym().equals(ClassSymbol.DEPRECATED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Name getBinaryName(TypeElement element) {
        if (!(element instanceof TurbineElement.TurbineTypeElement)) {
            throw new IllegalArgumentException(element.toString());
        }
        TurbineElement.TurbineTypeElement turbineTypeElement = (TurbineElement.TurbineTypeElement)element;
        return this.getName(turbineTypeElement.sym().binaryName().replace('/', '.'));
    }

    @Override
    public PackageElement getPackageOf(Element element) {
        Symbol sym = TurbineElements.asSymbol(element);
        return this.factory.packageElement(TurbineElements.packageSymbol(sym));
    }

    private static PackageSymbol packageSymbol(Symbol sym) {
        if (sym.symKind().equals((Object)Symbol.Kind.PACKAGE)) {
            return (PackageSymbol)sym;
        }
        return ModelFactory.enclosingClass(sym).owner();
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        ClassSymbol s = (ClassSymbol)TurbineElements.asSymbol(type);
        PackageSymbol from = TurbineElements.packageSymbol(s);
        SetMultimap methods = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        ImmutableList.Builder results = ImmutableList.builder();
        for (ClassSymbol superType : this.factory.cha().transitiveSupertypes(s)) {
            block5: for (Element element : this.factory.typeElement(superType).getEnclosedElements()) {
                Symbol sym = TurbineElements.asSymbol(element);
                switch (sym.symKind()) {
                    case METHOD: {
                        TurbineElement.TurbineExecutableElement m = (TurbineElement.TurbineExecutableElement)element;
                        if (!this.shouldAdd(s, from, (Multimap<String, TurbineElement.TurbineExecutableElement>)methods, m)) continue block5;
                        methods.put((Object)m.info().name(), (Object)m);
                        results.add((Object)element);
                        break;
                    }
                    case FIELD: {
                        if (!TurbineElements.shouldAdd(s, from, (TurbineElement.TurbineFieldElement)element)) continue block5;
                        results.add((Object)element);
                        break;
                    }
                    default: {
                        results.add((Object)element);
                    }
                }
            }
        }
        return results.build();
    }

    private boolean shouldAdd(ClassSymbol s, PackageSymbol from, Multimap<String, TurbineElement.TurbineExecutableElement> methods, TurbineElement.TurbineExecutableElement m) {
        if (m.sym().owner().equals(s)) {
            return true;
        }
        if (m.getKind() == ElementKind.CONSTRUCTOR) {
            return false;
        }
        if (!TurbineElements.isVisible(from, TurbineElements.packageSymbol(m.sym()), TurbineVisibility.fromAccess(m.info().access()))) {
            return false;
        }
        HashSet<TurbineElement.TurbineExecutableElement> overrides = new HashSet<TurbineElement.TurbineExecutableElement>();
        HashSet<TurbineElement.TurbineExecutableElement> overridden = new HashSet<TurbineElement.TurbineExecutableElement>();
        String name = m.info().name();
        for (TurbineElement.TurbineExecutableElement other : methods.get((Object)name)) {
            if (this.overrides(m, other, (TypeElement)m.getEnclosingElement())) {
                overrides.add(other);
                continue;
            }
            if (!this.overrides(other, m, (TypeElement)other.getEnclosingElement())) continue;
            overridden.add(other);
        }
        if (!overridden.isEmpty()) {
            Preconditions.checkState((boolean)overrides.isEmpty());
            return false;
        }
        for (TurbineElement.TurbineExecutableElement override : overrides) {
            methods.remove((Object)name, (Object)override);
        }
        return true;
    }

    private static boolean shouldAdd(ClassSymbol s, PackageSymbol from, TurbineElement.TurbineFieldElement f) {
        FieldSymbol sym = f.sym();
        if (sym.owner().equals(s)) {
            return true;
        }
        return TurbineElements.isVisible(from, TurbineElements.packageSymbol(sym), TurbineVisibility.fromAccess(f.info().access()));
    }

    private static boolean isVisible(PackageSymbol from, PackageSymbol to, TurbineVisibility visibility) {
        switch (visibility) {
            case PUBLIC: 
            case PROTECTED: {
                break;
            }
            case PACKAGE: {
                return from.equals(to);
            }
            case PRIVATE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element element) {
        return ((TurbineElement)element).getAllAnnotationMirrors();
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        if (!(hider instanceof TurbineElement)) {
            throw new IllegalArgumentException(hider.toString());
        }
        TurbineElement hiderElement = (TurbineElement)hider;
        if (!(hidden instanceof TurbineElement)) {
            throw new IllegalArgumentException(hidden.toString());
        }
        TurbineElement hiddenElement = (TurbineElement)hidden;
        return this.hides(hiderElement, hiddenElement);
    }

    private boolean hides(TurbineElement hider, TurbineElement hidden) {
        if (!hider.sym().symKind().equals((Object)hidden.sym().symKind())) {
            return false;
        }
        if (!hider.getSimpleName().equals(hidden.getSimpleName())) {
            return false;
        }
        if (hider.sym().equals(hidden.sym())) {
            return false;
        }
        if (!TurbineElements.isVisibleForHiding(hider, hidden)) {
            return false;
        }
        if (hider.sym().symKind().equals((Object)Symbol.Kind.METHOD)) {
            int access = ((TurbineElement.TurbineExecutableElement)hider).info().access();
            if ((access & 8) != 8) {
                return false;
            }
            if (!this.types.isSubsignature((TurbineTypeMirror.TurbineExecutableType)hider.asType(), (TurbineTypeMirror.TurbineExecutableType)hidden.asType())) {
                return false;
            }
        }
        Element containingHider = TurbineElements.containingClass(hider);
        Element containingHidden = TurbineElements.containingClass(hidden);
        if (containingHider == null || containingHidden == null) {
            return false;
        }
        return this.types.isSubtype(containingHider.asType(), containingHidden.asType());
    }

    private static @Nullable Element containingClass(TurbineElement element) {
        Element enclosing = element.getEnclosingElement();
        if (enclosing == null) {
            return null;
        }
        if (!TurbineElements.isClassOrInterface(enclosing.getKind())) {
            return null;
        }
        return enclosing;
    }

    private static boolean isClassOrInterface(ElementKind kind) {
        return kind.isClass() || kind.isInterface();
    }

    private static boolean isVisibleForHiding(TurbineElement hider, TurbineElement hidden) {
        int access;
        switch (hidden.sym().symKind()) {
            case CLASS: {
                access = ((TurbineElement.TurbineTypeElement)hidden).info().access();
                break;
            }
            case FIELD: {
                access = ((TurbineElement.TurbineFieldElement)hidden).info().access();
                break;
            }
            case METHOD: {
                access = ((TurbineElement.TurbineExecutableElement)hidden).info().access();
                break;
            }
            default: {
                return false;
            }
        }
        return TurbineElements.isVisible(TurbineElements.packageSymbol(TurbineElements.asSymbol(hider)), TurbineElements.packageSymbol(TurbineElements.asSymbol(hidden)), TurbineVisibility.fromAccess(access));
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        if (!overrider.getSimpleName().contentEquals(overridden.getSimpleName())) {
            return false;
        }
        TypeMirror a = overrider.asType();
        TypeMirror b = this.types.asMemberOfInternal((DeclaredType)type.asType(), overridden);
        if (b == null) {
            return false;
        }
        if (!this.types.isSubsignature((TurbineTypeMirror.TurbineExecutableType)a, (TurbineTypeMirror.TurbineExecutableType)b)) {
            return false;
        }
        return TurbineElements.isVisible(TurbineElements.packageSymbol(TurbineElements.asSymbol(overrider)), TurbineElements.packageSymbol(TurbineElements.asSymbol(overridden)), TurbineVisibility.fromAccess(((TurbineElement.TurbineExecutableElement)overridden).info().access()));
    }

    @Override
    public String getConstantExpression(Object value) {
        if (value instanceof Byte) {
            Byte b = (Byte)value;
            return new Const.ByteValue(b).toString();
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return new Const.LongValue(l).toString();
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return new Const.FloatValue(f.floatValue()).toString();
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return new Const.DoubleValue(d).toString();
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return String.format("(short)%d", s);
        }
        if (value instanceof String) {
            String string = (String)value;
            return new Const.StringValue(string).toString();
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return new Const.CharValue(c.charValue()).toString();
        }
        return String.valueOf(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        PrintWriter pw = new PrintWriter(w, true);
        for (Element element : elements) {
            pw.println(element.toString());
        }
    }

    @Override
    public Name getName(CharSequence cs) {
        return new TurbineName(cs.toString());
    }

    @Override
    public boolean isFunctionalInterface(TypeElement type) {
        throw new UnsupportedOperationException();
    }
}

