/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.testing.ElementTypesAreNonnullByDefault;
import com.google.common.testing.RelationshipTester;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class EqualsTester {
    private static final int REPETITIONS = 3;
    private final List<List<Object>> equalityGroups = Lists.newArrayList();
    private final RelationshipTester.ItemReporter itemReporter;

    public EqualsTester() {
        this(new RelationshipTester.ItemReporter());
    }

    EqualsTester(RelationshipTester.ItemReporter itemReporter) {
        this.itemReporter = (RelationshipTester.ItemReporter)Preconditions.checkNotNull((Object)itemReporter);
    }

    @CanIgnoreReturnValue
    public EqualsTester addEqualityGroup(Object ... equalityGroup) {
        Preconditions.checkNotNull((Object)equalityGroup);
        ArrayList<Object> list = new ArrayList<Object>(equalityGroup.length);
        for (int i = 0; i < equalityGroup.length; ++i) {
            Object element = equalityGroup[i];
            if (element == null) {
                throw new NullPointerException("at index " + i);
            }
            list.add(element);
        }
        this.equalityGroups.add(list);
        return this;
    }

    @CanIgnoreReturnValue
    public EqualsTester testEquals() {
        RelationshipTester<Object> delegate = new RelationshipTester<Object>(Equivalence.equals(), "Object#equals", "Object#hashCode", this.itemReporter);
        for (List<Object> group : this.equalityGroups) {
            delegate.addRelatedGroup(group);
        }
        for (int run = 0; run < 3; ++run) {
            this.testItems();
            delegate.test();
        }
        return this;
    }

    private void testItems() {
        for (Object item : Iterables.concat(this.equalityGroups)) {
            Assert.assertTrue((String)(item + " must not be Object#equals to null"), (!item.equals(null) ? 1 : 0) != 0);
            Assert.assertTrue((String)(item + " must not be Object#equals to an arbitrary object of another class"), (!item.equals((Object)NotAnInstance.EQUAL_TO_NOTHING) ? 1 : 0) != 0);
            Assert.assertTrue((String)(item + " must be Object#equals to itself"), (boolean)item.equals(item));
            Assert.assertEquals((String)("the Object#hashCode of " + item + " must be consistent"), (int)item.hashCode(), (int)item.hashCode());
            if (item instanceof String) continue;
            Assert.assertTrue((String)(item + " must not be Object#equals to its Object#toString representation"), (!item.equals(item.toString()) ? 1 : 0) != 0);
        }
    }

    private static enum NotAnInstance {
        EQUAL_TO_NOTHING;

    }
}

