/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.ErrorProneLog;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Position;
import java.util.HashMap;
import java.util.Map;

public class ErrorProneTokens {
    private final int offset;
    private final CommentSavingTokenizer commentSavingTokenizer;
    private final ScannerFactory scannerFactory;
    private final Log log;

    public ErrorProneTokens(String source, Context context) {
        this(source, 0, context);
    }

    public ErrorProneTokens(String source, int offset, Context context) {
        this.offset = offset;
        this.scannerFactory = ScannerFactory.instance(context);
        this.log = Log.instance(context);
        char[] buffer = source == null ? new char[]{} : source.toCharArray();
        this.commentSavingTokenizer = new CommentSavingTokenizer(this.scannerFactory, buffer, buffer.length);
    }

    public Position.LineMap getLineMap() {
        return this.commentSavingTokenizer.getLineMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<ErrorProneToken> getTokens() {
        Log.DiagnosticHandler diagHandler = ErrorProneLog.discardDiagnosticHandler(this.log);
        try {
            AccessibleScanner scanner = new AccessibleScanner(this.scannerFactory, this.commentSavingTokenizer);
            ImmutableList.Builder tokens = ImmutableList.builder();
            do {
                scanner.nextToken();
                Tokens.Token token = scanner.token();
                tokens.add((Object)new ErrorProneToken(token, this.offset, ErrorProneTokens.getComments(token, this.commentSavingTokenizer.comments())));
            } while (scanner.token().kind != Tokens.TokenKind.EOF);
            ImmutableList immutableList = tokens.build();
            return immutableList;
        }
        finally {
            this.log.popDiagnosticHandler(diagHandler);
        }
    }

    private static final ImmutableList<ErrorProneComment> getComments(Tokens.Token token, Map<Tokens.Comment, ErrorProneComment> comments) {
        if (token.comments == null) {
            return ImmutableList.of();
        }
        return ((ImmutableList)token.comments.stream().map(comments::get).collect(ImmutableList.toImmutableList())).reverse();
    }

    public static ImmutableList<ErrorProneToken> getTokens(String source, Context context) {
        return ErrorProneTokens.getTokens(source, 0, context);
    }

    public static ImmutableList<ErrorProneToken> getTokens(String source, int offset, Context context) {
        return new ErrorProneTokens(source, offset, context).getTokens();
    }

    static class CommentSavingTokenizer
    extends JavaTokenizer {
        private final Map<Tokens.Comment, ErrorProneComment> comments = new HashMap<Tokens.Comment, ErrorProneComment>();

        CommentSavingTokenizer(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }

        public Map<Tokens.Comment, ErrorProneComment> comments() {
            return this.comments;
        }

        @Override
        protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
            char[] buf = this.getRawCharactersReflectively(pos, endPos);
            Tokens.Comment comment = super.processComment(pos, endPos, style);
            AccessibleReader reader = new AccessibleReader(this.fac, buf, buf.length);
            ErrorProneComment errorProneComment = new ErrorProneComment(pos, endPos, 0, (Supplier<String>)((Supplier)() -> new String(reader.getRawCharacters())), ErrorProneComment.ErrorProneCommentStyle.from(style));
            this.comments.put(comment, errorProneComment);
            return comment;
        }

        private char[] getRawCharactersReflectively(int beginIndex, int endIndex) {
            Object instance;
            try {
                instance = JavaTokenizer.class.getDeclaredField("reader").get(this);
            }
            catch (ReflectiveOperationException e) {
                instance = this;
            }
            try {
                return (char[])instance.getClass().getMethod("getRawCharacters", Integer.TYPE, Integer.TYPE).invoke(instance, beginIndex, endIndex);
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }
    }

    static class AccessibleScanner
    extends Scanner {
        protected AccessibleScanner(ScannerFactory fac, JavaTokenizer tokenizer) {
            super(fac, tokenizer);
        }
    }

    static class AccessibleReader
    extends UnicodeReader {
        protected AccessibleReader(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }
    }
}

