/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.Sampler;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.cache.Cache;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.cache.CacheBuilder;
import java.lang.instrument.Instrumentation;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public class AllocationRecorder {
    private static volatile Instrumentation instrumentation;
    private static volatile Sampler[] additionalSamplers;
    private static final Object samplerLock;
    private static final ThreadLocal<Boolean> recordingAllocation;
    private static final Cache<Class<?>, Long> classSizesCache;

    static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    static void setInstrumentation(Instrumentation inst) {
        instrumentation = inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSampler(Sampler sampler) {
        Object object = samplerLock;
        synchronized (object) {
            Sampler[] samplers = additionalSamplers;
            if (samplers != null) {
                Sampler[] newSamplers = new Sampler[samplers.length + 1];
                System.arraycopy(samplers, 0, newSamplers, 0, samplers.length);
                newSamplers[samplers.length] = sampler;
                additionalSamplers = newSamplers;
            } else {
                Sampler[] newSamplers = new Sampler[]{sampler};
                additionalSamplers = newSamplers;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSampler(Sampler sampler) {
        Object object = samplerLock;
        synchronized (object) {
            Sampler[] samplers = additionalSamplers;
            int samplerCount = samplers.length;
            for (Sampler s : samplers) {
                if (!s.equals(sampler)) continue;
                --samplerCount;
            }
            Sampler[] newSamplers = new Sampler[samplerCount];
            int i = 0;
            for (Sampler s : samplers) {
                if (s.equals(sampler)) continue;
                newSamplers[i++] = s;
            }
            additionalSamplers = newSamplers;
        }
    }

    private static long getObjectSize(Object obj, boolean isArray, Instrumentation instr) {
        if (isArray) {
            return instr.getObjectSize(obj);
        }
        try {
            return classSizesCache.get(obj.getClass(), () -> instr.getObjectSize(obj));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void recordAllocation(Class<?> cls, Object newObj) {
        String typename = cls.getName().replace('.', '/');
        AllocationRecorder.recordAllocation(-1, typename, newObj);
    }

    public static void recordAllocation(int count, String desc, Object newObj) {
        Instrumentation instr;
        if (Objects.equals(recordingAllocation.get(), Boolean.TRUE)) {
            return;
        }
        recordingAllocation.set(Boolean.TRUE);
        if (count >= 0) {
            desc = desc.replace('.', '/');
        }
        if ((instr = instrumentation) != null) {
            long objectSize = -1L;
            Sampler[] samplers = additionalSamplers;
            if (samplers != null) {
                if (objectSize < 0L) {
                    objectSize = AllocationRecorder.getObjectSize(newObj, count >= 0, instr);
                }
                for (Sampler sampler : samplers) {
                    sampler.sampleAllocation(count, desc, newObj, objectSize);
                }
            }
        }
        recordingAllocation.set(Boolean.FALSE);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AllocationRecorder.setInstrumentation(null);
            }
        });
        instrumentation = null;
        samplerLock = new Object();
        recordingAllocation = new ThreadLocal();
        classSizesCache = CacheBuilder.newBuilder().weakKeys().maximumSize(100000L).build();
    }
}

