/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.ULabeledStatement;
import com.google.errorprone.refaster.USimpleStatement;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

final class UBreak
extends USimpleStatement
implements BreakTree {
    private final StringName label;

    UBreak(StringName label) {
        this.label = label;
    }

    static UBreak create(@Nullable CharSequence label) {
        return new UBreak(label == null ? null : StringName.of(label));
    }

    public @Nullable ExpressionTree getValue() {
        return null;
    }

    @Override
    public @Nullable StringName getLabel() {
        return this.label;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BREAK;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitBreak(this, data);
    }

    private ULabeledStatement.Key key() {
        return new ULabeledStatement.Key(this.getLabel());
    }

    @Override
    public JCTree.JCBreak inline(Inliner inliner) {
        return inliner.maker().Break(ULabeledStatement.inlineLabel(this.getLabel(), inliner));
    }

    @Override
    public Choice<Unifier> visitBreak(BreakTree node, Unifier unifier) {
        if (this.getLabel() == null) {
            return Choice.condition(node.getLabel() == null, unifier);
        }
        CharSequence boundName = unifier.getBinding(this.key());
        return Choice.condition(boundName != null && node.getLabel().contentEquals(boundName), unifier);
    }

    public int hashCode() {
        return Objects.hashCode(this.label);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof UBreak)) return false;
        UBreak other = (UBreak)obj;
        if (!Objects.equals(this.label, other.label)) return false;
        return true;
    }
}

