/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.names.LevenshteinEditDistance;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DCTree;
import java.util.Optional;
import java.util.regex.Pattern;

@BugPattern(summary="This @param tag doesn't refer to a parameter of the method.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class InvalidParam
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final Pattern POSSIBLE_PARAMETER = Pattern.compile("[a-z][A-Za-z0-9]*");
    private static final ImmutableSet<String> EXCLUSIONS = ImmutableSet.of((Object)"true", (Object)"false");
    private static final double LIKELY_PARAMETER_THRESHOLD = 0.25;

    public Description matchClass(ClassTree classTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = ASTHelpers.isRecord((Symbol)ASTHelpers.getSymbol((Tree)classTree)) ? (ImmutableSet)InvalidParam.getCanonicalRecordConstructor(classTree).getParameters().stream().map(p -> p.getName().toString()).collect(ImmutableSet.toImmutableSet()) : ImmutableSet.of();
            ImmutableSet typeParameters = (ImmutableSet)classTree.getTypeParameters().stream().map(t -> t.getName().toString()).collect(ImmutableSet.toImmutableSet());
            new ParamsChecker(state, classTree, (ImmutableSet<String>)parameters, (ImmutableSet<String>)typeParameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = (ImmutableSet)methodTree.getParameters().stream().map(v -> v.getName().toString()).collect(ImmutableSet.toImmutableSet());
            ImmutableSet typeParameters = (ImmutableSet)methodTree.getTypeParameters().stream().map(t -> t.getName().toString()).collect(ImmutableSet.toImmutableSet());
            new ParamsChecker(state, methodTree, (ImmutableSet<String>)parameters, (ImmutableSet<String>)typeParameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private static MethodTree getCanonicalRecordConstructor(ClassTree classTree) {
        return (MethodTree)classTree.getMembers().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).filter(tree -> ASTHelpers.isRecord((Symbol)ASTHelpers.getSymbol((Tree)tree))).collect(MoreCollectors.onlyElement());
    }

    private static ImmutableSet<String> extractDocumentedParams(DCTree.DCDocComment docCommentTree, boolean isTypeParameter) {
        ImmutableSet.Builder parameters = ImmutableSet.builder();
        for (DocTree docTree : docCommentTree.getBlockTags()) {
            ParamTree paramTree;
            if (!(docTree instanceof ParamTree) || (paramTree = (ParamTree)docTree).isTypeParameter() != isTypeParameter) continue;
            parameters.add((Object)paramTree.getName().getName().toString());
        }
        return parameters.build();
    }

    private final class ParamsChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final ImmutableSet<String> documentedParameters;
        private final ImmutableSet<String> documentedTypeParameters;
        private final ImmutableSet<String> parameters;
        private final ImmutableSet<String> typeParameters;

        private ParamsChecker(VisitorState state, Tree tree, ImmutableSet<String> parameters, ImmutableSet<String> typeParameters) {
            this.state = state;
            DCTree.DCDocComment dcDocComment = Utils.getDocComment(state, tree);
            this.documentedParameters = InvalidParam.extractDocumentedParams(dcDocComment, false);
            this.documentedTypeParameters = InvalidParam.extractDocumentedParams(dcDocComment, true);
            this.parameters = parameters;
            this.typeParameters = typeParameters;
        }

        @Override
        public Void visitParam(ParamTree paramTree, Void unused) {
            DCTree.DCText dcText;
            DocTree firstDescription;
            ImmutableSet<String> paramNames;
            ImmutableSet<String> immutableSet = paramNames = paramTree.isTypeParameter() ? this.typeParameters : this.parameters;
            if (!paramTree.getDescription().isEmpty() && (firstDescription = paramTree.getDescription().get(0)) instanceof DCTree.DCText && (dcText = (DCTree.DCText)firstDescription).getBody().startsWith(":")) {
                int colonLocation = Utils.getEndPosition(paramTree.getName(), this.state);
                if (this.state.getSourceCode().charAt(colonLocation) == ':') {
                    this.state.reportMatch(InvalidParam.this.describeMatch(Utils.diagnosticPosition(this.getCurrentPath(), this.state), (Fix)SuggestedFix.replace((int)colonLocation, (int)(colonLocation + 1), (String)"")));
                }
            }
            if (!paramNames.contains((Object)paramTree.getName().toString())) {
                ImmutableSet<String> documentedParamNames = paramTree.isTypeParameter() ? this.documentedTypeParameters : this.documentedParameters;
                Sets.SetView undocumentedParameters = Sets.difference(paramNames, documentedParamNames);
                Optional<String> bestMatch = Utils.getBestMatch(paramTree.getName().toString(), 5, (Iterable<String>)undocumentedParameters);
                String message = String.format("Parameter name `%s` is unknown.", paramTree.getName());
                this.state.reportMatch(bestMatch.map(bm -> InvalidParam.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + String.format(" Did you mean %s?", bm)).addFix((Fix)Utils.replace(paramTree.getName(), bm, this.state)).build()).orElse(InvalidParam.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(paramTree, "", this.state)).build()));
            }
            return (Void)super.visitParam(paramTree, null);
        }

        @Override
        public Void visitLiteral(LiteralTree node, Void unused) {
            if (node.getKind() != DocTree.Kind.CODE) {
                return (Void)super.visitLiteral(node, null);
            }
            String body = node.getBody().getBody();
            if (!POSSIBLE_PARAMETER.matcher(body).matches() || EXCLUSIONS.contains((Object)body)) {
                return (Void)super.visitLiteral(node, null);
            }
            String bestMatch = null;
            int minDistance = Integer.MAX_VALUE;
            for (String parameter : this.parameters) {
                int distance = LevenshteinEditDistance.getEditDistance((String)body, (String)parameter);
                if (distance >= minDistance) continue;
                bestMatch = parameter;
                minDistance = distance;
            }
            if (bestMatch != null && !bestMatch.equals(body) && (double)minDistance / (double)body.length() <= 0.25) {
                String message = String.format("`%s` is very close to the parameter `%s`. Did you mean to reference the parameter?", body, bestMatch);
                this.state.reportMatch(InvalidParam.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(node.getBody(), bestMatch, this.state)).build());
            }
            return (Void)super.visitLiteral(node, null);
        }
    }
}

