/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypesWithUndefinedEquality;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

@BugPattern(summary="This type is not guaranteed to implement a useful equals() method.", severity=BugPattern.SeverityLevel.WARNING)
public final class UndefinedEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> IS_EQUAL_TO = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").named("isEqualTo");
    private static final Matcher<MethodInvocationTree> ASSERT_THAT_EQUALS = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf(new String[]{"isEqualTo", "isNotEqualTo"}), Matchers.receiverOfInvocation((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")}))});
    private static final Supplier<Type> MULTIMAP = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.common.collect.Multimap"));
    private static final Supplier<Type> CHAR_SEQUENCE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.CharSequence"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Tree argument;
        Tree receiver;
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (Matchers.staticEqualsInvocation().matches((Tree)tree, state) || Matchers.assertEqualsInvocation().matches((Tree)tree, state) || Matchers.assertNotEqualsInvocation().matches((Tree)tree, state)) {
            receiver = arguments.get(arguments.size() - 2);
            argument = (Tree)Iterables.getLast(arguments);
        } else if (Matchers.instanceEqualsInvocation().matches((Tree)tree, state)) {
            receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            argument = arguments.get(0);
        } else if (ASSERT_THAT_EQUALS.matches((Tree)tree, state)) {
            receiver = (Tree)Iterables.getOnlyElement(arguments);
            argument = (Tree)Iterables.getOnlyElement(((MethodInvocationTree)ASTHelpers.getReceiver((ExpressionTree)tree)).getArguments());
        } else {
            return Description.NO_MATCH;
        }
        return Arrays.stream(TypesWithUndefinedEquality.values()).filter(b -> b.matchesType(ASTHelpers.getType((Tree)receiver), state) || b.matchesType(ASTHelpers.getType((Tree)argument), state)).findFirst().map(b -> this.buildDescription(tree).setMessage(b.shortName() + " does not have well-defined equality semantics").addFix((Fix)UndefinedEquals.generateFix(tree, state, receiver, argument).orElse(SuggestedFix.emptyFix())).build()).orElse(Description.NO_MATCH);
    }

    private static Optional<SuggestedFix> generateFix(MethodInvocationTree tree, VisitorState state, Tree receiver, Tree argument) {
        if (IS_EQUAL_TO.matches((Tree)tree, state)) {
            String methodText = state.getSourceForNode((Tree)tree.getMethodSelect());
            String assertThatWithArg = methodText.substring(0, methodText.lastIndexOf(46));
            BiFunction<Type, String, Optional> generateTruthFix = (type, replacementMethod) -> {
                if (type != null && ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)argument), (Type)type, (VisitorState)state) && ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)receiver), (Type)type, (VisitorState)state)) {
                    return Optional.of(SuggestedFix.replace((Tree)tree, (String)String.format("%s.%s(%s)", assertThatWithArg, replacementMethod, state.getSourceForNode(receiver))));
                }
                return Optional.empty();
            };
            Type iterableType = state.getSymtab().iterableType;
            Type multimapType = (Type)MULTIMAP.get(state);
            Optional<SuggestedFix> fix = generateTruthFix.apply(iterableType, "containsExactlyElementsIn").or(() -> (Optional)generateTruthFix.apply(multimapType, "containsExactlyEntriesIn"));
            if (fix.isPresent()) {
                return fix;
            }
        }
        Type charSequenceType = (Type)CHAR_SEQUENCE.get(state);
        BiFunction<Tree, Tree, Optional> generateCharSequenceFix = (maybeCharSequence, maybeString) -> {
            if (charSequenceType != null && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)maybeCharSequence), (Type)charSequenceType, (VisitorState)state) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)maybeString), (Type)state.getSymtab().stringType, (VisitorState)state)) {
                return Optional.of(SuggestedFix.postfixWith((Tree)maybeCharSequence, (String)".toString()"));
            }
            return Optional.empty();
        };
        return generateCharSequenceFix.apply(receiver, argument).or(() -> (Optional)generateCharSequenceFix.apply(argument, receiver));
    }
}

