/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.time.Duration;
import java.time.ZoneId;
import java.util.TimeZone;

@BugPattern(summary="Three-letter time zone identifiers are deprecated, may be ambiguous, and might not do what you intend; the full IANA time zone ID should be used instead.", severity=BugPattern.SeverityLevel.WARNING)
public class ThreeLetterTimeZoneID
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> METHOD_MATCHER = MethodMatchers.staticMethod().onClass("java.util.TimeZone").named("getTimeZone").withParameters("java.lang.String", new String[0]);
    private static final Matcher<ExpressionTree> JODATIME_METHOD_MATCHER = MethodMatchers.staticMethod().onClass("org.joda.time.DateTimeZone").named("forTimeZone").withParameters("java.util.TimeZone", new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHOD_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String value = (String)ASTHelpers.constValue((Tree)tree.getArguments().get(0), String.class);
        if (value == null) {
            return Description.NO_MATCH;
        }
        Replacement replacement = ThreeLetterTimeZoneID.getReplacement(value, ThreeLetterTimeZoneID.isInJodaTimeContext(state), this.message());
        if (replacement.replacements.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder builder = this.buildDescription(tree).setMessage(replacement.message);
        for (String r : replacement.replacements) {
            builder.addFix((Fix)SuggestedFix.replace((Tree)tree.getArguments().get(0), (String)state.getConstantExpression((Object)r)));
        }
        return builder.build();
    }

    @VisibleForTesting
    static Replacement getReplacement(String id, boolean inJodaTimeContext, String message) {
        long hours;
        long millis;
        TimeZone timeZone;
        switch (id) {
            case "EST": {
                return ThreeLetterTimeZoneID.handleNonDaylightSavingsZone(inJodaTimeContext, "America/New_York", "Etc/GMT+5", message);
            }
            case "HST": {
                return ThreeLetterTimeZoneID.handleNonDaylightSavingsZone(inJodaTimeContext, "Pacific/Honolulu", "Etc/GMT+10", message);
            }
            case "MST": {
                return ThreeLetterTimeZoneID.handleNonDaylightSavingsZone(inJodaTimeContext, "America/Denver", "Etc/GMT+7", message);
            }
        }
        String zoneIdReplacement = ZoneId.SHORT_IDS.get(id);
        if (zoneIdReplacement == null) {
            return Replacement.NO_REPLACEMENT;
        }
        if (id.endsWith("ST") && (timeZone = TimeZone.getTimeZone(id)).observesDaylightTime() && (millis = Duration.ofHours(hours = Duration.ofMillis(timeZone.getRawOffset()).toHours()).toMillis()) == (long)timeZone.getRawOffset()) {
            String fixedOffset = String.format("Etc/GMT%+d", -hours);
            String newDescription = message + "\n\n" + ThreeLetterTimeZoneID.observesDaylightSavingsMessage("TimeZone", zoneIdReplacement, fixedOffset);
            return new Replacement(newDescription, (ImmutableList<String>)ImmutableList.of((Object)zoneIdReplacement, (Object)fixedOffset));
        }
        return new Replacement(message, (ImmutableList<String>)ImmutableList.of((Object)zoneIdReplacement));
    }

    static Replacement handleNonDaylightSavingsZone(boolean inJodaTimeContext, String daylightSavingsZone, String fixedOffset, String message) {
        if (inJodaTimeContext) {
            String newDescription = message + "\n\n" + ThreeLetterTimeZoneID.observesDaylightSavingsMessage("DateTimeZone", daylightSavingsZone, fixedOffset);
            return new Replacement(newDescription, (ImmutableList<String>)ImmutableList.of((Object)daylightSavingsZone, (Object)fixedOffset));
        }
        String newDescription = message + "\n\nThis TimeZone will not observe daylight savings. If this is intended, use " + fixedOffset + " instead; to observe daylight savings, use " + daylightSavingsZone + ".";
        return new Replacement(newDescription, (ImmutableList<String>)ImmutableList.of((Object)fixedOffset, (Object)daylightSavingsZone));
    }

    private static String observesDaylightSavingsMessage(String type, String daylightSavingsZone, String fixedOffset) {
        return "This " + type + " will observe daylight savings. If this is intended, use " + daylightSavingsZone + " instead; otherwise use " + fixedOffset + ".";
    }

    private static boolean isInJodaTimeContext(VisitorState state) {
        ExpressionTree expressionTree;
        Tree parentLeaf;
        return state.getPath().getParentPath() != null && (parentLeaf = state.getPath().getParentPath().getLeaf()) instanceof ExpressionTree && JODATIME_METHOD_MATCHER.matches((Tree)(expressionTree = (ExpressionTree)parentLeaf), state);
    }

    @VisibleForTesting
    static final class Replacement {
        static final Replacement NO_REPLACEMENT = new Replacement("", (ImmutableList<String>)ImmutableList.of());
        final String message;
        final ImmutableList<String> replacements;

        Replacement(String message, ImmutableList<String> replacements) {
            this.message = message;
            this.replacements = replacements;
        }
    }
}

