/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMustBeClosedChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@BugPattern(altNames={"FilesLinesLeak"}, summary="Streams that encapsulate a closeable resource should be closed using try-with-resources", severity=BugPattern.SeverityLevel.WARNING)
public class StreamResourceLeak
extends AbstractMustBeClosedChecker
implements BugChecker.MethodTreeMatcher {
    public static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.nio.file.Files").namedAnyOf(new String[]{"lines", "newDirectoryStream", "list", "walk", "find"});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.scanEntireMethodFor(MATCHER, tree, state);
    }

    @Override
    protected Optional<AbstractMustBeClosedChecker.Change> fix(ExpressionTree tree, VisitorState state, AbstractMustBeClosedChecker.NameSuggester suggester) {
        return AbstractMustBeClosedChecker.Change.of(StreamResourceLeak.definiteFix(tree, state));
    }

    private static SuggestedFix definiteFix(ExpressionTree tree, VisitorState state) {
        TreePath parentPath = state.getPath().getParentPath();
        final Tree parent = parentPath.getLeaf();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String streamType = SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)ASTHelpers.getReturnType((ExpressionTree)tree));
        if (parent instanceof MemberSelectTree) {
            StatementTree statement = (StatementTree)state.findEnclosing(new Class[]{StatementTree.class});
            if (statement instanceof VariableTree) {
                VariableTree var = (VariableTree)statement;
                int pos = ASTHelpers.getStartPosition((Tree)var);
                int initPos = ASTHelpers.getStartPosition((Tree)var.getInitializer());
                int eqPos = pos + state.getSourceForNode((Tree)var).substring(0, initPos - pos).lastIndexOf(61);
                fix.replace(eqPos, initPos, String.format(";\ntry (%s stream = %s) {\n%s =", streamType, state.getSourceForNode((Tree)tree), var.getName()));
            } else {
                fix.prefixWith((Tree)statement, String.format("try (%s stream = %s) {\n", streamType, state.getSourceForNode((Tree)tree)));
            }
            fix.replace((Tree)tree, "stream");
            fix.postfixWith((Tree)statement, "}");
            return fix.build();
        }
        if (parent instanceof VariableTree) {
            int idx;
            VariableTree variableTree = (VariableTree)parent;
            Tree grandParent = parentPath.getParentPath().getLeaf();
            if (!(grandParent instanceof BlockTree)) {
                return SuggestedFix.emptyFix();
            }
            BlockTree blockTree = (BlockTree)grandParent;
            List<? extends StatementTree> statements = blockTree.getStatements();
            int lastUse = idx = statements.indexOf(parent);
            for (int i = idx + 1; i < statements.size(); ++i) {
                final boolean[] found = new boolean[]{false};
                statements.get(i).accept(new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree tree, Void unused) {
                        if (Objects.equals(ASTHelpers.getSymbol((Tree)tree), ASTHelpers.getSymbol((Tree)parent))) {
                            found[0] = true;
                        }
                        return null;
                    }
                }, null);
                if (!found[0]) continue;
                lastUse = i;
            }
            fix.prefixWith(parent, "try (");
            fix.replace(state.getEndPosition((Tree)variableTree.getInitializer()), state.getEndPosition(parent), ") {");
            fix.postfixWith((Tree)statements.get(lastUse), "}");
            return fix.build();
        }
        if (parent instanceof EnhancedForLoopTree) {
            fix.prefixWith(parent, String.format("try (%s stream = %s) {\n", streamType, state.getSourceForNode((Tree)tree)));
            fix.replace((Tree)tree, "stream");
            fix.postfixWith(parent, "}");
            return fix.build();
        }
        if (parent instanceof MethodInvocationTree) {
            Tree grandParent = parentPath.getParentPath().getLeaf();
            if (!(grandParent instanceof ExpressionStatementTree)) {
                return SuggestedFix.emptyFix();
            }
            fix.prefixWith(parent, String.format("try (%s stream = %s) {\n", streamType, state.getSourceForNode((Tree)tree)));
            fix.replace((Tree)tree, "stream");
            fix.postfixWith(grandParent, "}");
            return fix.build();
        }
        return SuggestedFix.emptyFix();
    }
}

