/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;

@BugPattern(summary="Mapping to another Optional will yield a nested Optional. Did you mean flatMap?", severity=BugPattern.SeverityLevel.WARNING)
public final class OptionalMapToOptional
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MAP = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("java.util.Optional").named("map"), MethodMatchers.instanceMethod().onExactClass("com.google.common.base.Optional").named("transform")});
    private static final Matcher<ExpressionTree> ANYTHING_BUT_ISPRESENT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("java.util.Optional"), Matchers.not((Matcher)MethodMatchers.instanceMethod().onExactClass("java.util.Optional").named("isPresent"))}), Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("com.google.common.base.Optional"), Matchers.not((Matcher)MethodMatchers.instanceMethod().onExactClass("com.google.common.base.Optional").named("isPresent"))})});
    private static final TypePredicate OPTIONAL = TypePredicates.isDescendantOfAny((Iterable)ImmutableList.of((Object)"java.util.Optional", (Object)"com.google.common.base.Optional"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        MethodInvocationTree methodInvocationTree;
        Tree tree2;
        if (!MAP.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        TreePath path = state.getPath();
        if (path.getParentPath().getLeaf() instanceof MemberSelectTree && (tree2 = path.getParentPath().getParentPath().getLeaf()) instanceof MethodInvocationTree && ANYTHING_BUT_ISPRESENT.matches((Tree)(methodInvocationTree = (MethodInvocationTree)tree2), state)) {
            return Description.NO_MATCH;
        }
        TargetType targetType = TargetType.targetType((VisitorState)state.withPath(new TreePath(state.getPath(), tree.getArguments().get(0))));
        if (targetType == null) {
            return Description.NO_MATCH;
        }
        List<Type> typeArguments = targetType.type().getTypeArguments();
        if (typeArguments.isEmpty()) {
            return Description.NO_MATCH;
        }
        Type typeMappedTo = (Type)typeArguments.get(1);
        if (!OPTIONAL.apply(typeMappedTo, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

