/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;
import javax.lang.model.element.ElementKind;

public abstract class MisusedDateFormat
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String JAVA_SIMPLE_DATE_FORMAT = "java.text.SimpleDateFormat";
    private static final String ICU_SIMPLE_DATE_FORMAT = "com.ibm.icu.text.SimpleDateFormat";
    private static final Matcher<NewClassTree> PATTERN_CTOR_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("java.text.SimpleDateFormat").withParameters("java.lang.String", new String[0]), Matchers.constructor().forClass("java.text.SimpleDateFormat").withParameters("java.lang.String", new String[]{"java.text.DateFormatSymbols"}), Matchers.constructor().forClass("java.text.SimpleDateFormat").withParameters("java.lang.String", new String[]{"java.util.Locale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters("java.lang.String", new String[0]), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters("java.lang.String", new String[]{"com.ibm.icu.text.DateFormatSymbols"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters("java.lang.String", new String[]{"com.ibm.icu.text.DateFormatSymbols", "com.ibm.icu.util.ULocale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters("java.lang.String", new String[]{"java.util.Locale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters("java.lang.String", new String[]{"java.lang.String", "com.ibm.icu.util.ULocale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters("java.lang.String", new String[]{"com.ibm.icu.util.ULocale"})});
    private static final Matcher<ExpressionTree> PATTERN_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onExactClass("java.text.SimpleDateFormat").named("applyPattern"), Matchers.instanceMethod().onExactClass("java.text.SimpleDateFormat").named("applyLocalizedPattern"), Matchers.instanceMethod().onExactClass("com.ibm.icu.text.SimpleDateFormat").named("applyPattern"), Matchers.instanceMethod().onExactClass("com.ibm.icu.text.SimpleDateFormat").named("applyLocalizedPattern"), MethodMatchers.staticMethod().onClass("java.time.format.DateTimeFormatter").named("ofPattern")});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!PATTERN_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String argument = (String)ASTHelpers.constValue((Tree)tree.getArguments().get(0), String.class);
        if (argument == null) {
            return Description.NO_MATCH;
        }
        return this.constructDescription(tree, tree.getArguments().get(0), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!PATTERN_CTOR_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.constructDescription(tree, tree.getArguments().get(0), state);
    }

    abstract Optional<String> rewriteTo(String var1);

    Description constructDescription(Tree tree, ExpressionTree patternArg, VisitorState state) {
        return Optional.ofNullable((String)ASTHelpers.constValue((Tree)patternArg, String.class)).flatMap(this::rewriteTo).map(replacement -> this.describeMatch(tree, (Fix)MisusedDateFormat.replaceArgument(patternArg, replacement, state))).orElse(Description.NO_MATCH);
    }

    private static SuggestedFix replaceArgument(ExpressionTree patternArg, String replacement, VisitorState state) {
        final String quotedReplacement = String.format("\"%s\"", replacement);
        if (patternArg.getKind() == Tree.Kind.STRING_LITERAL) {
            return SuggestedFix.replace((Tree)patternArg, (String)quotedReplacement);
        }
        final Symbol sym = ASTHelpers.getSymbol((Tree)patternArg);
        if (!(sym instanceof Symbol.VarSymbol) || sym.getKind() != ElementKind.FIELD) {
            return SuggestedFix.emptyFix();
        }
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree node, Void unused) {
                if (sym.equals(ASTHelpers.getSymbol((VariableTree)node)) && node.getInitializer() != null && node.getInitializer().getKind() == Tree.Kind.STRING_LITERAL) {
                    fix.replace((Tree)node.getInitializer(), quotedReplacement);
                    return null;
                }
                return (Void)super.visitVariable(node, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return fix.build();
    }

    static String replaceFormatChar(String format, final char from, final char to) {
        final StringBuilder builder = new StringBuilder();
        MisusedDateFormat.parseDateFormat(format, new DateFormatConsumer(){

            @Override
            public void consumeLiteral(char literal) {
                builder.append(literal);
            }

            @Override
            public void consumeSpecial(char special) {
                builder.append(special == from ? to : special);
            }
        });
        return builder.toString();
    }

    static void parseDateFormat(String format, DateFormatConsumer consumer) {
        block0: for (int pos = 0; pos < format.length(); ++pos) {
            char c = format.charAt(pos);
            if (c == '\'') {
                consumer.consumeSpecial('\'');
                ++pos;
                while (pos < format.length()) {
                    consumer.consumeLiteral(format.charAt(pos));
                    if (format.charAt(pos) == '\'') {
                        if (pos + 1 >= format.length() || format.charAt(pos + 1) != '\'') continue block0;
                        consumer.consumeSpecial('\'');
                        ++pos;
                    }
                    ++pos;
                }
                continue;
            }
            consumer.consumeSpecial(c);
        }
    }

    static interface DateFormatConsumer {
        public void consumeLiteral(char var1);

        public void consumeSpecial(char var1);
    }
}

