/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="This method searches the class path for the given file, prefer to read the file and call getInstance(byte[]) or getInstance(InputStream)", severity=BugPattern.SeverityLevel.WARNING, tags={"Performance"})
public class ICCProfileGetInstance
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.awt.color.ICC_Profile").named("getInstance").withParameters("java.lang.String", new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().prefixWith((Tree)arg, "Files.readAllBytes(Paths.get(").postfixWith((Tree)arg, "))").addImport("java.nio.file.Files").addImport("java.nio.file.Paths").build());
    }
}

