/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Possible class initialization deadlock", severity=BugPattern.SeverityLevel.WARNING)
public class ClassInitializationDeadlock
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Pattern AUTO_VALUE_PREFIX = Pattern.compile("\\$*AutoValue_.*");

    public Description matchClass(ClassTree tree, VisitorState state) {
        final Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)tree);
        if (classSymbol.isInterface() && !classSymbol.members().anyMatch(ClassInitializationDeadlock::defaultMethod)) {
            return Description.NO_MATCH;
        }
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ ClassInitializationDeadlock this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitClass(ClassTree node, Void unused) {
                for (Tree tree : node.getMembers()) {
                    if (tree instanceof ClassTree) continue;
                    this.scan(tree, null);
                }
                return null;
            }

            public Void visitBlock(BlockTree tree, Void unused) {
                if (tree.isStatic()) {
                    this.this$0.scanForSubtypes(this.getCurrentPath(), classSymbol, this.state);
                }
                return null;
            }

            public Void visitVariable(VariableTree tree, Void unused) {
                ExpressionTree initializer = tree.getInitializer();
                if (ASTHelpers.getSymbol((VariableTree)tree).isStatic() && initializer != null) {
                    this.this$0.scanForSubtypes(new TreePath(this.getCurrentPath(), initializer), classSymbol, this.state);
                }
                return null;
            }
        }.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private void scanForSubtypes(TreePath path, final Symbol.ClassSymbol classSymbol, final VisitorState state) {
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ ClassInitializationDeadlock this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitClass(ClassTree node, Void unused) {
                return null;
            }

            @Override
            public Void visitMethod(MethodTree node, Void unused) {
                return null;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                if (ASTHelpers.constValue((Tree)tree) != null) {
                    return null;
                }
                if (tree.getIdentifier().contentEquals("class")) {
                    return null;
                }
                this.handle(tree);
                return (Void)super.visitMemberSelect(tree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (ASTHelpers.constValue((Tree)tree) != null) {
                    return null;
                }
                this.handle(tree);
                return null;
            }

            private void handle(ExpressionTree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (!(symbol instanceof Symbol.ClassSymbol)) {
                    return;
                }
                Symbol.ClassSymbol use = (Symbol.ClassSymbol)symbol;
                if (use.equals(classSymbol)) {
                    return;
                }
                if (!use.isSubClass(classSymbol, state.getTypes())) {
                    return;
                }
                if (use.isEnclosedBy(classSymbol) && !ASTHelpers.isStatic((Symbol)use)) {
                    return;
                }
                ImmutableSet<Symbol.ClassSymbol> nonPrivateInstantiators = this.this$0.nonPrivateInstantiators(use, classSymbol, state.getTypes());
                if (nonPrivateInstantiators.isEmpty()) {
                    return;
                }
                StringBuilder message = new StringBuilder();
                message.append(String.format("Possible class initialization deadlock: %s is a subclass of the containing class %s", SuggestedFixes.prettyType((Type)use.asType(), (VisitorState)state), SuggestedFixes.prettyType((Type)classSymbol.asType(), (VisitorState)state)));
                if (!nonPrivateInstantiators.contains((Object)use)) {
                    message.append(String.format(" (via %s, which can be initialized from outside the current file)", nonPrivateInstantiators.stream().map(s -> SuggestedFixes.prettyType((Type)s.asType(), (VisitorState)state)).collect(Collectors.joining(", "))));
                }
                state.reportMatch(this.this$0.buildDescription(tree).setMessage(message.toString()).build());
            }
        }.scan(path, (Void)null);
    }

    private ImmutableSet<Symbol.ClassSymbol> nonPrivateInstantiators(Symbol.ClassSymbol from, Symbol.ClassSymbol to, Types types) {
        MutableGraph superTypes = GraphBuilder.directed().build();
        ClassInitializationDeadlock.superTypeClosure(from, to, types, (MutableGraph<Symbol.ClassSymbol>)superTypes);
        return (ImmutableSet)Streams.stream((Iterable)Traverser.forGraph(arg_0 -> ((MutableGraph)superTypes).predecessors(arg_0)).depthFirstPreOrder((Object)to)).filter(current -> current != to && this.nonPrivateInstantiator((Symbol.ClassSymbol)current)).collect(ImmutableSet.toImmutableSet());
    }

    private static void superTypeClosure(Symbol.ClassSymbol current, Symbol.ClassSymbol stop, Types types, MutableGraph<Symbol.ClassSymbol> superTypes) {
        if (current == stop) {
            return;
        }
        for (Type t : types.directSupertypes(current.type)) {
            Symbol.ClassSymbol s = (Symbol.ClassSymbol)t.tsym;
            superTypes.putEdge((Object)current, (Object)s);
            ClassInitializationDeadlock.superTypeClosure(s, stop, types, superTypes);
        }
    }

    boolean nonPrivateInstantiator(Symbol.ClassSymbol use) {
        if (ASTHelpers.isEffectivelyPrivate((Symbol)use)) {
            return false;
        }
        if (!use.members().anyMatch(ClassInitializationDeadlock::nonPrivateConstructorOrFactory)) {
            return false;
        }
        return !AUTO_VALUE_PREFIX.matcher(use.getSimpleName().toString()).matches();
    }

    private static boolean nonPrivateConstructorOrFactory(Symbol symbol) {
        if (symbol.isPrivate()) {
            return false;
        }
        return symbol.isConstructor() || ASTHelpers.isStatic((Symbol)symbol);
    }

    private static boolean defaultMethod(Symbol s) {
        return s.getKind().equals((Object)ElementKind.METHOD) && ((Symbol.MethodSymbol)s).isDefault();
    }
}

