/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;

@BugPattern(summary="This method cannot throw a checked exception that it claims to. This may cause consumers of the API to incorrectly attempt to handle, or propagate, this exception.", severity=BugPattern.SeverityLevel.WARNING)
public final class CheckedExceptionNotThrown
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getThrows().isEmpty()) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)symbol) || state.errorProneOptions().isTestOnlyTarget() || tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        ImmutableSet thrownExceptions = (ImmutableSet)CheckedExceptionNotThrown.treesToScanForCheckedExceptions(tree, state).flatMap(t -> ASTHelpers.getThrownExceptions((Tree)t, (VisitorState)state).stream()).filter(t -> ASTHelpers.isCheckedExceptionType((Type)t, (VisitorState)state)).collect(ImmutableSet.toImmutableSet());
        ImmutableList canActuallyBeThrown = (ImmutableList)tree.getThrows().stream().filter(et -> {
            Type type = ASTHelpers.getType((Tree)et);
            return !ASTHelpers.isCheckedExceptionType((Type)type, (VisitorState)state) || thrownExceptions.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)t, (Type)type, (VisitorState)state));
        }).collect(ImmutableList.toImmutableList());
        if (tree.getThrows().equals(canActuallyBeThrown)) {
            return Description.NO_MATCH;
        }
        ImmutableSet thrownTypes = (ImmutableSet)canActuallyBeThrown.stream().map(ASTHelpers::getType).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        String unthrown = tree.getThrows().stream().filter(et -> !canActuallyBeThrown.contains(et)).map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).sorted().collect(Collectors.joining(", ", "(", ")"));
        String description = String.format("This method does not throw checked exceptions %s despite claiming to. This may cause consumers of the API to incorrectly attempt to handle, or propagate, this exception.", unthrown);
        SuggestedFix throwsFix = canActuallyBeThrown.isEmpty() ? CheckedExceptionNotThrown.deleteEntireThrowsClause(tree, state) : SuggestedFix.replace((int)ASTHelpers.getStartPosition((Tree)tree.getThrows().get(0)), (int)state.getEndPosition((Tree)Iterables.getLast(tree.getThrows())), (String)canActuallyBeThrown.stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", ")));
        SuggestedFix fix = this.fixJavadoc((ImmutableSet<Type>)thrownTypes, state).toBuilder().merge(throwsFix).build();
        ExpressionTree firstUnthrown = tree.getThrows().stream().filter(x -> !canActuallyBeThrown.contains(x)).findFirst().get();
        return this.buildDescription(firstUnthrown).setMessage(description).addFix((Fix)fix).build();
    }

    private static Stream<Tree> treesToScanForCheckedExceptions(MethodTree tree, VisitorState state) {
        if (ASTHelpers.getSymbol((MethodTree)tree).isStatic()) {
            return Stream.of(tree.getBody());
        }
        return Streams.concat((Stream[])new Stream[]{Stream.of(tree.getBody()), CheckedExceptionNotThrown.fieldInitializers((ClassTree)state.findEnclosing(new Class[]{ClassTree.class}))});
    }

    private static Stream<ExpressionTree> fieldInitializers(ClassTree tree) {
        return tree.getMembers().stream().filter(VariableTree.class::isInstance).map(VariableTree.class::cast).filter(v -> !ASTHelpers.getSymbol((VariableTree)v).isStatic()).map(VariableTree::getInitializer).filter(i -> i != null);
    }

    private SuggestedFix fixJavadoc(final ImmutableSet<Type> actuallyThrownTypes, final VisitorState state) {
        final DocCommentTree docCommentTree = JavacTrees.instance(state.context).getDocCommentTree(state.getPath());
        if (docCommentTree == null) {
            return SuggestedFix.emptyFix();
        }
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        DocTreePath docTreePath = new DocTreePath(state.getPath(), docCommentTree);
        new DocTreePathScanner<Void, Void>(this){
            final /* synthetic */ CheckedExceptionNotThrown this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitThrows(ThrowsTree throwsTree, Void unused) {
                Type type;
                ReferenceTree exName = throwsTree.getExceptionName();
                Element element = JavacTrees.instance(state.context).getElement(new DocTreePath(this.getCurrentPath(), exName));
                if (element != null && !actuallyThrownTypes.contains((Object)(type = (Type)element.asType()))) {
                    DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
                    CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
                    fix.replace((int)positions.getStartPosition(compilationUnitTree, docCommentTree, throwsTree), (int)positions.getEndPosition(compilationUnitTree, docCommentTree, throwsTree), "");
                }
                return (Void)super.visitThrows(throwsTree, null);
            }
        }.scan(docTreePath, (Void)null);
        return fix.build();
    }

    private static SuggestedFix deleteEntireThrowsClause(MethodTree tree, VisitorState state) {
        int endPos = state.getEndPosition((Tree)Iterables.getLast(tree.getThrows()));
        int methodStartPos = ASTHelpers.getStartPosition((Tree)tree);
        int startPos = ErrorProneTokens.getTokens((String)state.getSourceCode().subSequence(methodStartPos, endPos).toString(), (int)methodStartPos, (Context)state.context).stream().filter(token -> token.kind().equals(Tokens.TokenKind.THROWS)).findFirst().map(ErrorProneToken::pos).get();
        return SuggestedFix.replace((int)startPos, (int)endPos, (String)"");
    }
}

