/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.dagger.DaggerAnnotations;
import com.google.errorprone.bugpatterns.inject.dagger.Util;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(summary="@Binds is a more efficient and declarative mechanism for delegating a binding.", severity=BugPattern.SeverityLevel.WARNING)
public class UseBinds
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> SIMPLE_METHOD = new Matcher<MethodTree>(){

        public boolean matches(MethodTree t, VisitorState state) {
            List<? extends VariableTree> parameters = t.getParameters();
            if (parameters.size() != 1) {
                return false;
            }
            VariableTree onlyParameter = (VariableTree)Iterables.getOnlyElement(parameters);
            BlockTree body = t.getBody();
            if (body == null) {
                return false;
            }
            List<? extends StatementTree> statements = body.getStatements();
            if (statements.size() != 1) {
                return false;
            }
            StatementTree onlyStatement = (StatementTree)Iterables.getOnlyElement(statements);
            if (!(onlyStatement instanceof ReturnTree)) {
                return false;
            }
            ReturnTree returnTree = (ReturnTree)onlyStatement;
            Symbol returnedSymbol = ASTHelpers.getSymbol((Tree)returnTree.getExpression());
            if (returnedSymbol == null) {
                return false;
            }
            return ASTHelpers.getSymbol((VariableTree)onlyParameter).equals(returnedSymbol);
        }
    };
    private static final Matcher<MethodTree> CAN_BE_A_BINDS_METHOD = Matchers.allOf((Matcher[])new Matcher[]{DaggerAnnotations.isBindingMethod(), SIMPLE_METHOD});

    public Description matchMethod(MethodTree method, VisitorState state) {
        if (!CAN_BE_A_BINDS_METHOD.matches((Tree)method, state)) {
            return Description.NO_MATCH;
        }
        ClassTree enclosingClass = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (!Util.IS_DAGGER_2_MODULE.matches((Tree)enclosingClass, state)) {
            return Description.NO_MATCH;
        }
        if (enclosingClass.getExtendsClause() != null) {
            return UseBinds.fixByDelegating();
        }
        for (Tree tree : enclosingClass.getMembers()) {
            Set<Modifier> siblingFlags;
            if (!(tree instanceof MethodTree)) continue;
            MethodTree siblingMethod = (MethodTree)tree;
            if (ASTHelpers.getSymbol((Tree)tree).isConstructor() || (siblingFlags = siblingMethod.getModifiers().getFlags()).contains((Object)Modifier.STATIC) || siblingFlags.contains((Object)Modifier.ABSTRACT) || CAN_BE_A_BINDS_METHOD.matches((Tree)siblingMethod, state)) continue;
            return UseBinds.fixByDelegating();
        }
        return this.fixByModifyingMethod(state, enclosingClass, method);
    }

    private Description fixByModifyingMethod(VisitorState state, ClassTree enclosingClass, MethodTree method) {
        return this.describeMatch(method, (Fix)SuggestedFix.builder().addImport("dagger.Binds").merge(UseBinds.convertMethodToBinds(method, enclosingClass, state)).merge(Util.makeConcreteClassAbstract(enclosingClass, state)).build());
    }

    private static SuggestedFix.Builder convertMethodToBinds(MethodTree method, ClassTree enclosingClass, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ModifiersTree modifiers = method.getModifiers();
        ImmutableList.Builder modifierStringsBuilder = ImmutableList.builder().add((Object)"@Binds");
        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
            Name annotationQualifiedName = ASTHelpers.getSymbol((Tree)annotationTree).getQualifiedName();
            if (annotationQualifiedName.contentEquals("dagger.Provides") || annotationQualifiedName.contentEquals("dagger.producers.Produces")) {
                String typeName;
                List<? extends ExpressionTree> arguments = annotationTree.getArguments();
                if (arguments.isEmpty()) continue;
                ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(arguments);
                Preconditions.checkState((boolean)(argument instanceof AssignmentTree));
                AssignmentTree assignment = (AssignmentTree)argument;
                Preconditions.checkState((boolean)ASTHelpers.getSymbol((Tree)assignment.getVariable()).getSimpleName().contentEquals("type"));
                switch (typeName = ASTHelpers.getSymbol((Tree)assignment.getExpression()).getSimpleName().toString()) {
                    case "SET": {
                        modifierStringsBuilder.add((Object)"@IntoSet");
                        fix.addImport("dagger.multibindings.IntoSet");
                        break;
                    }
                    case "SET_VALUES": {
                        modifierStringsBuilder.add((Object)"@ElementsIntoSet");
                        fix.addImport("dagger.multibindings.ElementsIntoSet");
                        break;
                    }
                    case "MAP": {
                        modifierStringsBuilder.add((Object)"@IntoMap");
                        fix.addImport("dagger.multibindings.IntoMap");
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown type name: " + typeName));
                    }
                }
                continue;
            }
            modifierStringsBuilder.add((Object)state.getSourceForNode((Tree)annotationTree));
        }
        HashSet<Modifier> methodFlags = new HashSet<Modifier>(modifiers.getFlags());
        methodFlags.remove((Object)Modifier.STATIC);
        methodFlags.remove((Object)Modifier.FINAL);
        if (!enclosingClass.getKind().equals((Object)Tree.Kind.INTERFACE)) {
            methodFlags.add(Modifier.ABSTRACT);
        }
        for (Modifier flag : methodFlags) {
            modifierStringsBuilder.add((Object)flag.toString());
        }
        fix.replace((Tree)modifiers, Joiner.on((char)' ').join((Iterable)modifierStringsBuilder.build()));
        fix.replace((Tree)method.getBody(), ";");
        return fix;
    }

    private static Description fixByDelegating() {
        return Description.NO_MATCH;
    }
}

