/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.List;

@BugPattern(summary="Setting the caught exception as the cause of the log message may provide more context for anyone debugging errors.", severity=BugPattern.SeverityLevel.WARNING)
public final class FloggerLogWithCause
extends BugChecker
implements BugChecker.CatchTreeMatcher {
    private static final Matcher<ExpressionTree> LOG_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log");
    private static final Matcher<ExpressionTree> WITH_CAUSE = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("withCause");
    private static final Matcher<ExpressionTree> HIGH_LEVEL = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.AbstractLogger").namedAnyOf(new String[]{"atWarning", "atSevere"});

    public Description matchCatch(CatchTree tree, VisitorState state) {
        if (this.isSuppressed(tree.getParameter(), state)) {
            return Description.NO_MATCH;
        }
        List<? extends StatementTree> statements = tree.getBlock().getStatements();
        if (statements.size() != 1) {
            return Description.NO_MATCH;
        }
        StatementTree statementTree = statements.get(0);
        if (!(statementTree instanceof ExpressionStatementTree)) {
            return Description.NO_MATCH;
        }
        ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)statementTree;
        ExpressionTree expressionTree = expressionStatementTree.getExpression();
        if (!LOG_MATCHER.matches((Tree)expressionTree, state)) {
            return Description.NO_MATCH;
        }
        boolean isHighLevelLog = false;
        ExpressionTree receiver = expressionTree;
        while (receiver instanceof MethodInvocationTree) {
            if (WITH_CAUSE.matches((Tree)receiver, state)) {
                return Description.NO_MATCH;
            }
            if (HIGH_LEVEL.matches((Tree)receiver, state)) {
                isHighLevelLog = true;
            }
            receiver = ASTHelpers.getReceiver((ExpressionTree)receiver);
        }
        if (!isHighLevelLog) {
            return Description.NO_MATCH;
        }
        final Symbol.VarSymbol parameter = ASTHelpers.getSymbol((VariableTree)tree.getParameter());
        boolean exceptionUsed = (Boolean)new TreeScanner<Boolean, Void>(this){
            final /* synthetic */ FloggerLogWithCause this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Boolean visitIdentifier(IdentifierTree node, Void unused) {
                return parameter.equals(ASTHelpers.getSymbol((Tree)node));
            }

            @Override
            public Boolean reduce(Boolean a, Boolean b) {
                return Boolean.TRUE.equals(a) || Boolean.TRUE.equals(b);
            }
        }.scan(tree.getBlock(), null);
        if (exceptionUsed) {
            return Description.NO_MATCH;
        }
        String withCause = String.format(".withCause(%s)", tree.getParameter().getName());
        return this.describeMatch(expressionTree, (Fix)SuggestedFix.postfixWith((Tree)ASTHelpers.getReceiver((ExpressionTree)expressionTree), (String)withCause));
    }
}

