/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="These parentheses are unnecessary; it is unlikely the code will be misinterpreted without them", severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryParentheses
extends BugChecker
implements BugChecker.ParenthesizedTreeMatcher,
BugChecker.AnnotationTreeMatcher {
    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!ASTHelpers.hasExplicitSource((Tree)tree, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return state.getSourceForNode((Tree)tree).endsWith("()") ? this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)("@" + state.getSourceForNode(tree.getAnnotationType())))) : Description.NO_MATCH;
    }

    public Description matchParenthesized(ParenthesizedTree tree, VisitorState state) {
        ExpressionTree expression = tree.getExpression();
        Tree parent = state.getPath().getParentPath().getLeaf();
        switch (parent.getKind()) {
            case IF: 
            case WHILE_LOOP: 
            case DO_WHILE_LOOP: 
            case FOR_LOOP: 
            case SWITCH: 
            case SYNCHRONIZED: 
            case SWITCH_EXPRESSION: {
                return Description.NO_MATCH;
            }
        }
        if (ASTHelpers.requiresParentheses((ExpressionTree)expression, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)expression), " ").replace(state.getEndPosition((Tree)expression), state.getEndPosition((Tree)tree), "").build());
    }
}

