/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.regex.Pattern;

@BugPattern(summary="Truth Library assert is called on a constant.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class TruthConstantAsserts
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ASSERT_THAT = MethodMatchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat");
    private static final Pattern EQ_NEQ = Pattern.compile("isEqualTo|isNotEqualTo");
    private static final Matcher<ExpressionTree> TRUTH_SUBJECT_CALL = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").withNameMatching(EQ_NEQ).withParameters("java.lang.Object", new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (methodInvocationTree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (!TRUTH_SUBJECT_CALL.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree rec = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
        if (rec == null) {
            return Description.NO_MATCH;
        }
        if (!ASSERT_THAT.matches((Tree)rec, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree expr = (ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)rec).getArguments());
        if (expr == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.constValue((Tree)expr) == null) {
            return Description.NO_MATCH;
        }
        ExpressionTree expectation = (ExpressionTree)Iterables.getOnlyElement(methodInvocationTree.getArguments());
        if (ASTHelpers.constValue((Tree)expectation) != null) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.swap((Tree)expr, (Tree)expectation, (VisitorState)state);
        return this.describeMatch(methodInvocationTree, (Fix)fix);
    }
}

