/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import javax.lang.model.element.Modifier;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Saving instances of Throwable in static fields is discouraged, prefer to create them on-demand when an exception is thrown")
public final class StaticAssignmentOfThrowable
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget() || !variableTree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            return Description.NO_MATCH;
        }
        ExpressionTree initializer = variableTree.getInitializer();
        if (initializer == null) {
            return Description.NO_MATCH;
        }
        Type throwableType = state.getSymtab().throwableType;
        Type variableType = ASTHelpers.getType((Tree)variableTree.getType());
        if (!ASTHelpers.isSubtype((Type)variableType, (Type)throwableType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(variableTree);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (methodSymbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        this.buildTreeScanner(state).scan(tree.getBody(), null);
        return Description.NO_MATCH;
    }

    private final TreeScanner<Void, Void> buildTreeScanner(final VisitorState state) {
        final Type throwableType = state.getSymtab().throwableType;
        return new TreeScanner<Void, Void>(this){
            final /* synthetic */ StaticAssignmentOfThrowable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                return null;
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Void unused) {
                return null;
            }

            @Override
            public Void visitAssignment(AssignmentTree assignmentTree, Void unused) {
                Symbol variableSymbol = ASTHelpers.getSymbol((Tree)assignmentTree.getVariable());
                Type variableType = ASTHelpers.getType((Tree)assignmentTree.getVariable());
                if (variableSymbol != null && ASTHelpers.isStatic((Symbol)variableSymbol) && ASTHelpers.isSubtype((Type)variableType, (Type)throwableType, (VisitorState)state)) {
                    state.reportMatch(this.this$0.describeMatch(assignmentTree));
                }
                return (Void)super.visitAssignment(assignmentTree, null);
            }
        };
    }
}

