/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_AutoValueBoxedValues_Getter;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.beans.Introspector;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="AutoValue instances should not usually contain boxed types that are not Nullable. We recommend removing the unnecessary boxing.", severity=BugPattern.SeverityLevel.WARNING)
public class AutoValueBoxedValues
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodTree> ABSTRACT_MATCHER = Matchers.hasModifier((Modifier)Modifier.ABSTRACT);
    private static final Matcher<MethodTree> STATIC_MATCHER = Matchers.hasModifier((Modifier)Modifier.STATIC);

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!ASTHelpers.hasAnnotation((Tree)tree, (String)AutoValue.class.getName(), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Optional<ClassTree> builderClass = AutoValueBoxedValues.findBuilderClass(tree, state);
        ImmutableList<Getter> getters = this.handleGetterMethods(tree, state, builderClass);
        if (getters.stream().allMatch(getter -> getter.fix().isEmpty())) {
            return Description.NO_MATCH;
        }
        if (builderClass.isPresent()) {
            this.handleSetterMethods(builderClass.get(), state, (List<Getter>)getters);
        } else {
            this.handleFactoryMethods(tree, state, (List<Getter>)getters);
        }
        getters.stream().filter(getter -> !getter.fix().isEmpty()).forEach(getter -> state.reportMatch(this.describeMatch(getter.method(), (Fix)getter.fix().build())));
        return Description.NO_MATCH;
    }

    private ImmutableList<Getter> handleGetterMethods(ClassTree classTree, VisitorState state, Optional<ClassTree> builderClass) {
        return (ImmutableList)classTree.getMembers().stream().filter(MethodTree.class::isInstance).map(memberTree -> (MethodTree)memberTree).filter(methodTree -> ABSTRACT_MATCHER.matches((Tree)methodTree, state) && methodTree.getParameters().isEmpty() && !AutoValueBoxedValues.isToBuilderMethod(methodTree, state, builderClass)).map(methodTree -> this.maybeFixGetter((MethodTree)methodTree, state)).collect(ImmutableList.toImmutableList());
    }

    private Getter maybeFixGetter(MethodTree method, VisitorState state) {
        Getter getter = Getter.of(method);
        Type type = ASTHelpers.getType((Tree)method.getReturnType());
        if (!this.isSuppressed(method, state) && !AutoValueBoxedValues.hasNullableAnnotation(method) && !AutoValueBoxedValues.isOverride(method, state) && AutoValueBoxedValues.isBoxedPrimitive(state, type)) {
            AutoValueBoxedValues.suggestRemoveUnnecessaryBoxing(method.getReturnType(), state, type, getter.fix());
        }
        return getter;
    }

    private void handleSetterMethods(ClassTree classTree, VisitorState state, List<Getter> getters) {
        classTree.getMembers().stream().filter(MethodTree.class::isInstance).map(memberTree -> (MethodTree)memberTree).filter(methodTree -> ABSTRACT_MATCHER.matches((Tree)methodTree, state) && methodTree.getParameters().size() == 1 && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)methodTree.getReturnType()), (Type)ASTHelpers.getType((ClassTree)classTree), (VisitorState)state)).forEach(methodTree -> this.maybeFixSetter((MethodTree)methodTree, state, getters));
        classTree.getMembers().stream().filter(MethodTree.class::isInstance).map(memberTree -> (MethodTree)memberTree).filter(methodTree -> ABSTRACT_MATCHER.matches((Tree)methodTree, state) && methodTree.getParameters().isEmpty()).forEach(methodTree -> AutoValueBoxedValues.maybeFixGetterInBuilder(methodTree, state, getters));
    }

    private void maybeFixSetter(MethodTree methodTree, VisitorState state, List<Getter> getters) {
        VariableTree parameter;
        Type type;
        if (this.isSuppressed(methodTree, state)) {
            return;
        }
        boolean allGettersPrefixed = AutoValueBoxedValues.allGettersPrefixed(getters);
        Optional<Getter> fixedGetter = getters.stream().filter(getter -> !getter.fix().isEmpty() && AutoValueBoxedValues.matchGetterAndSetter(getter.method(), methodTree, allGettersPrefixed)).findAny();
        if (fixedGetter.isPresent() && AutoValueBoxedValues.isBoxedPrimitive(state, type = ASTHelpers.getType((Tree)(parameter = methodTree.getParameters().get(0)))) && !AutoValueBoxedValues.hasNullableAnnotation(parameter)) {
            AutoValueBoxedValues.suggestRemoveUnnecessaryBoxing(parameter.getType(), state, type, fixedGetter.get().fix());
        }
    }

    private static void maybeFixGetterInBuilder(MethodTree methodTree, VisitorState state, List<Getter> getters) {
        Optional<Getter> fixedGetter = getters.stream().filter(getter -> !getter.fix().isEmpty() && getter.method().getName().contentEquals(methodTree.getName().toString()) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)getter.method().getReturnType()), (Type)ASTHelpers.getType((Tree)methodTree.getReturnType()), (VisitorState)state)).findAny();
        if (fixedGetter.isPresent()) {
            Type type = ASTHelpers.getType((Tree)methodTree.getReturnType());
            AutoValueBoxedValues.suggestRemoveUnnecessaryBoxing(methodTree.getReturnType(), state, type, fixedGetter.get().fix());
        }
    }

    private void handleFactoryMethods(ClassTree classTree, VisitorState state, List<Getter> getters) {
        Optional<MethodTree> trivialFactoryMethod = classTree.getMembers().stream().filter(MethodTree.class::isInstance).map(memberTree -> (MethodTree)memberTree).filter(methodTree -> STATIC_MATCHER.matches((Tree)methodTree, state) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)methodTree.getReturnType()), (Type)ASTHelpers.getType((ClassTree)classTree), (VisitorState)state) && AutoValueBoxedValues.isTrivialFactoryMethod(methodTree, getters.size())).findAny();
        if (trivialFactoryMethod.isEmpty()) {
            return;
        }
        for (int idx = 0; idx < getters.size(); ++idx) {
            VariableTree parameter;
            Type type;
            Getter getter = getters.get(idx);
            if (getter.fix().isEmpty() || !AutoValueBoxedValues.isBoxedPrimitive(state, type = ASTHelpers.getType((Tree)(parameter = trivialFactoryMethod.get().getParameters().get(idx)))) || AutoValueBoxedValues.hasNullableAnnotation(parameter)) continue;
            AutoValueBoxedValues.suggestRemoveUnnecessaryBoxing(parameter.getType(), state, type, getter.fix());
        }
    }

    private static boolean hasNullableAnnotation(Tree tree) {
        return NullnessAnnotations.fromAnnotationsOn((Symbol)ASTHelpers.getSymbol((Tree)tree)).orElse(null) == Nullness.NULLABLE;
    }

    private static boolean isOverride(MethodTree methodTree, VisitorState state) {
        return !ASTHelpers.findSuperMethods((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)methodTree), (Types)state.getTypes()).isEmpty();
    }

    private static Type unbox(VisitorState state, Type type) {
        return state.getTypes().unboxedType(type);
    }

    private static boolean isBoxedPrimitive(VisitorState state, Type type) {
        if (type.isPrimitive()) {
            return false;
        }
        Type unboxed = AutoValueBoxedValues.unbox(state, type);
        return unboxed != null && unboxed.getTag() != TypeTag.NONE && unboxed.getTag() != TypeTag.VOID;
    }

    private static Optional<ClassTree> findBuilderClass(ClassTree tree, VisitorState state) {
        return tree.getMembers().stream().filter(memberTree -> memberTree instanceof ClassTree && ASTHelpers.hasAnnotation((Tree)memberTree, (String)AutoValue.Builder.class.getName(), (VisitorState)state)).map(memberTree -> (ClassTree)memberTree).findAny();
    }

    private static boolean isToBuilderMethod(MethodTree methodTree, VisitorState state, Optional<ClassTree> builderClass) {
        return builderClass.isPresent() && !STATIC_MATCHER.matches((Tree)methodTree, state) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)methodTree.getReturnType()), (Type)ASTHelpers.getType((ClassTree)builderClass.get()), (VisitorState)state);
    }

    private static boolean allGettersPrefixed(List<Getter> getters) {
        return getters.stream().allMatch(getter -> !AutoValueBoxedValues.getterPrefix(getter.method()).isEmpty());
    }

    private static String getterPrefix(MethodTree getterMethod) {
        String name = getterMethod.getName().toString();
        if (name.startsWith("get") && !name.equals("get")) {
            return "get";
        }
        if (name.startsWith("is") && !name.equals("is") && ASTHelpers.getType((Tree)getterMethod.getReturnType()).getKind() == TypeKind.BOOLEAN) {
            return "is";
        }
        return "";
    }

    private static boolean matchGetterAndSetter(MethodTree getter, MethodTree setter, boolean allGettersPrefixed) {
        String setterName;
        String getterName = getter.getName().toString();
        if (allGettersPrefixed) {
            String prefix = AutoValueBoxedValues.getterPrefix(getter);
            getterName = Introspector.decapitalize(getterName.substring(prefix.length()));
        }
        return getterName.equals(setterName = setter.getName().toString()) || setterName.equals("set" + Ascii.toUpperCase((char)getterName.charAt(0)) + getterName.substring(1));
    }

    private static boolean isTrivialFactoryMethod(MethodTree methodTree, int gettersCount) {
        StatementTree statementTree;
        List<? extends VariableTree> params = methodTree.getParameters();
        List<? extends StatementTree> statements = methodTree.getBody().getStatements();
        if (params.size() != gettersCount || statements.size() != 1 || !((statementTree = statements.get(0)) instanceof ReturnTree)) {
            return false;
        }
        ReturnTree returnTree = (ReturnTree)statementTree;
        ExpressionTree expressionTree = returnTree.getExpression();
        if (!(expressionTree instanceof NewClassTree)) {
            return false;
        }
        NewClassTree newClassTree = (NewClassTree)expressionTree;
        if (newClassTree.getArguments().stream().anyMatch(r -> !(r instanceof IdentifierTree))) {
            return false;
        }
        ImmutableList paramsNames = (ImmutableList)params.stream().map(p -> p.getName().toString()).collect(ImmutableList.toImmutableList());
        ImmutableList constructorArgs = (ImmutableList)newClassTree.getArguments().stream().map(r -> ((IdentifierTree)r).getName().toString()).collect(ImmutableList.toImmutableList());
        return paramsNames.equals((Object)constructorArgs);
    }

    private static void suggestRemoveUnnecessaryBoxing(Tree tree, VisitorState state, Type type, SuggestedFix.Builder fix) {
        fix.replace(tree, ((Name)AutoValueBoxedValues.unbox((VisitorState)state, (Type)type).tsym.getSimpleName()).toString());
    }

    @AutoValue
    static abstract class Getter {
        Getter() {
        }

        abstract MethodTree method();

        abstract SuggestedFix.Builder fix();

        static Getter of(MethodTree method) {
            return new AutoValue_AutoValueBoxedValues_Getter(method, SuggestedFix.builder());
        }
    }
}

