/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state;

import java.util.List;
import java.util.Objects;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.ListAbstractState;
import proguard.analysis.cpa.defaults.StackAbstractState;

public class JvmFrameAbstractState<StateT extends LatticeAbstractState<StateT>>
implements LatticeAbstractState<JvmFrameAbstractState<StateT>> {
    protected final ListAbstractState<StateT> localVariables;
    protected final StackAbstractState<StateT> operandStack;

    public JvmFrameAbstractState() {
        this(new ListAbstractState(), new StackAbstractState());
    }

    public JvmFrameAbstractState(ListAbstractState<StateT> localVariables, StackAbstractState<StateT> operandStack) {
        this.localVariables = localVariables;
        this.operandStack = operandStack;
    }

    @Override
    public JvmFrameAbstractState<StateT> join(JvmFrameAbstractState<StateT> abstractState) {
        JvmFrameAbstractState<StateT> answer = new JvmFrameAbstractState<StateT>(this.localVariables.join(abstractState.localVariables), this.operandStack.join(abstractState.operandStack));
        return this.equals(answer) ? this : answer;
    }

    @Override
    public boolean isLessOrEqual(JvmFrameAbstractState<StateT> abstractState) {
        return this.localVariables.isLessOrEqual(abstractState.localVariables) && this.operandStack.isLessOrEqual(abstractState.operandStack);
    }

    @Override
    public JvmFrameAbstractState<StateT> copy() {
        return new JvmFrameAbstractState<StateT>(this.localVariables.copy(), this.operandStack.copy());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JvmFrameAbstractState)) {
            return false;
        }
        JvmFrameAbstractState other = (JvmFrameAbstractState)obj;
        return this.localVariables.equals(other.localVariables) && this.operandStack.equals(other.operandStack);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.localVariables, this.operandStack);
    }

    public StateT peekOrDefault(int index, StateT defaultState) {
        return this.operandStack.peekOrDefault(index, defaultState);
    }

    public StateT peek(int index) {
        return this.operandStack.peek(index);
    }

    public StateT pop() {
        return (StateT)((LatticeAbstractState)this.operandStack.pop());
    }

    public StateT popOrDefault(StateT defaultState) {
        return this.operandStack.popOrDefault(defaultState);
    }

    public StateT push(StateT state) {
        return (StateT)((LatticeAbstractState)this.operandStack.push(state));
    }

    public List<StateT> pushAll(List<StateT> states) {
        states.forEach(this.operandStack::push);
        return states;
    }

    public StateT getVariableOrDefault(int index, StateT defaultState) {
        return this.localVariables.getOrDefault(index, defaultState);
    }

    public StateT setVariable(int index, StateT state, StateT defaultState) {
        return this.localVariables.set(index, state, defaultState);
    }

    public ListAbstractState<StateT> getLocalVariables() {
        return this.localVariables;
    }

    public StackAbstractState<StateT> getOperandStack() {
        return this.operandStack;
    }
}

