/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.fixes.AppliedFix;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ImportTree;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.tools.JavaFileObject;

public class JavacErrorDescriptionListener
implements DescriptionListener {
    private final Log log;
    private final JavaFileObject sourceFile;
    private final Function<Fix, AppliedFix> fixToAppliedFix;
    private final Context context;
    private final boolean dontUseErrors;
    private static final String MESSAGE_BUNDLE_KEY = "error.prone";
    private static final ImmutableSet<JCDiagnostic.DiagnosticFlag> DIAGNOSTIC_FLAGS = ImmutableSet.of((Object)((Object)JCDiagnostic.DiagnosticFlag.API));

    private JavacErrorDescriptionListener(Log log, EndPosTable endPositions, JavaFileObject sourceFile, Context context, boolean dontUseErrors) {
        this.log = log;
        this.sourceFile = sourceFile;
        this.context = context;
        this.dontUseErrors = dontUseErrors;
        Preconditions.checkNotNull((Object)endPositions);
        HashMap cache = new HashMap();
        try {
            CharSequence sourceFileContent = sourceFile.getCharContent(true);
            this.fixToAppliedFix = fix -> cache.computeIfAbsent(fix, f -> AppliedFix.apply(sourceFileContent, endPositions, f));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDescribed(Description description) {
        ImmutableList appliedFixes = (ImmutableList)description.fixes.stream().filter(f -> !JavacErrorDescriptionListener.shouldSkipImportTreeFix(description.position, f)).map(this.fixToAppliedFix).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        String message = JavacErrorDescriptionListener.messageForFixes(description, (List<AppliedFix>)appliedFixes);
        JavaFileObject originalSource = this.log.useSource(this.sourceFile);
        try {
            JCDiagnostic.Factory factory = JCDiagnostic.Factory.instance(this.context);
            JCDiagnostic.DiagnosticPosition pos = description.position;
            JCDiagnostic.DiagnosticType type = switch (description.severity()) {
                default -> throw new IncompatibleClassChangeError();
                case BugPattern.SeverityLevel.ERROR -> {
                    if (this.dontUseErrors) {
                        yield JCDiagnostic.DiagnosticType.WARNING;
                    }
                    yield JCDiagnostic.DiagnosticType.ERROR;
                }
                case BugPattern.SeverityLevel.WARNING -> JCDiagnostic.DiagnosticType.WARNING;
                case BugPattern.SeverityLevel.SUGGESTION -> JCDiagnostic.DiagnosticType.NOTE;
            };
            this.log.report(factory.create(type, null, EnumSet.copyOf(DIAGNOSTIC_FLAGS), this.log.currentSource(), pos, MESSAGE_BUNDLE_KEY, message));
        }
        finally {
            if (originalSource != null) {
                this.log.useSource(originalSource);
            }
        }
    }

    private static boolean shouldSkipImportTreeFix(JCDiagnostic.DiagnosticPosition position, Fix f) {
        if (position.getTree() != null && !(position.getTree() instanceof ImportTree)) {
            return false;
        }
        return !f.getImportsToAdd().isEmpty() || !f.getImportsToRemove().isEmpty();
    }

    private static String messageForFixes(Description description, List<AppliedFix> appliedFixes) {
        StringBuilder messageBuilder = new StringBuilder(description.getMessage());
        boolean first = true;
        for (AppliedFix appliedFix : appliedFixes) {
            if (first) {
                messageBuilder.append("\nDid you mean ");
            } else {
                messageBuilder.append(" or ");
            }
            if (appliedFix.isRemoveLine()) {
                messageBuilder.append("to remove this line");
            } else {
                messageBuilder.append("'").append((CharSequence)appliedFix.snippet()).append("'");
            }
            first = false;
        }
        if (!first) {
            messageBuilder.append("?");
        }
        return messageBuilder.toString();
    }

    static DescriptionListener.Factory provider(Context context) {
        return (log, compilation) -> new JavacErrorDescriptionListener(log, compilation.endPositions, compilation.getSourceFile(), context, false);
    }

    static DescriptionListener.Factory providerForRefactoring(Context context) {
        return (log, compilation) -> new JavacErrorDescriptionListener(log, compilation.endPositions, compilation.getSourceFile(), context, true);
    }
}

