/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Parameter;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.List;
import java.util.Objects;

final class CreatesDuplicateCallHeuristic
implements Heuristic {
    CreatesDuplicateCallHeuristic() {
    }

    @Override
    public boolean isAcceptableChange(Changes changes, Tree node, Symbol.MethodSymbol symbol, VisitorState state) {
        return CreatesDuplicateCallHeuristic.findArgumentsForOtherInstances(symbol, node, state).stream().allMatch(arguments -> !CreatesDuplicateCallHeuristic.anyArgumentsMatch(changes.changedPairs(), arguments));
    }

    private static boolean anyArgumentsMatch(List<ParameterPair> changedPairs, List<Parameter> arguments) {
        return changedPairs.stream().anyMatch(change -> Objects.equals(change.actual().text(), ((Parameter)arguments.get(change.formal().index())).text()));
    }

    private static ImmutableList<List<Parameter>> findArgumentsForOtherInstances(final Symbol.MethodSymbol calledMethod, final Tree currentNode, final VisitorState state) {
        Tree enclosingNode = (Tree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), MethodTree.class);
        if (enclosingNode == null) {
            enclosingNode = (Tree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        }
        if (enclosingNode == null) {
            return ImmutableList.of();
        }
        final ImmutableList.Builder resultBuilder = ImmutableList.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
                this.addToResult(ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree), methodInvocationTree);
                return (Void)super.visitMethodInvocation(methodInvocationTree, null);
            }

            @Override
            public Void visitNewClass(NewClassTree newClassTree, Void unused) {
                this.addToResult(ASTHelpers.getSymbol((NewClassTree)newClassTree), newClassTree);
                return (Void)super.visitNewClass(newClassTree, null);
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Void unused) {
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
                this.addToResult(methodSymbol, methodTree);
                for (Symbol.MethodSymbol superSymbol : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes())) {
                    this.addToResult(superSymbol, methodTree);
                }
                return (Void)super.visitMethod(methodTree, null);
            }

            private void addToResult(Symbol.MethodSymbol foundSymbol, Tree tree) {
                if (foundSymbol != null && Objects.equals(calledMethod, foundSymbol) && !currentNode.equals(tree)) {
                    resultBuilder.add(this.createParameterList(tree));
                }
            }

            private ImmutableList<Parameter> createParameterList(Tree tree) {
                if (tree instanceof MethodInvocationTree) {
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                    return Parameter.createListFromExpressionTrees(methodInvocationTree.getArguments());
                }
                if (tree instanceof NewClassTree) {
                    NewClassTree newClassTree = (NewClassTree)tree;
                    return Parameter.createListFromExpressionTrees(newClassTree.getArguments());
                }
                if (tree instanceof MethodTree) {
                    MethodTree methodTree = (MethodTree)tree;
                    return Parameter.createListFromVariableTrees(methodTree.getParameters());
                }
                return ImmutableList.of();
            }
        }.scan(enclosingNode, null);
        return resultBuilder.build();
    }
}

