/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Optional;

@BugPattern(summary="Code that contains System.exit() is untestable.", severity=BugPattern.SeverityLevel.ERROR)
public class SystemExitOutsideMain
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> CALLS_TO_SYSTEM_EXIT = Matchers.staticMethod().onClass("java.lang.System").named("exit");
    private static final Matcher<ExpressionTree> CALLS_TO_SYSTEM_EXIT_OUTSIDE_MAIN = Matchers.allOf((Matcher[])new Matcher[]{CALLS_TO_SYSTEM_EXIT, Matchers.not((Matcher)Matchers.enclosingMethod((Matcher)Matchers.MAIN_METHOD))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (CALLS_TO_SYSTEM_EXIT_OUTSIDE_MAIN.matches((Tree)tree, state)) {
            Optional<Tree> mainMethodInThisClass = ((ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class)).getMembers().stream().filter(t -> t instanceof MethodTree).filter(t -> Matchers.MAIN_METHOD.matches((Tree)((MethodTree)t), state)).findAny();
            return mainMethodInThisClass.isPresent() ? Description.NO_MATCH : this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

