/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Prefer positive boolean names", severity=BugPattern.SeverityLevel.WARNING)
public final class NegativeBoolean
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Pattern NEGATIVE_NAME = Pattern.compile("^not?[A-Z].*$");

    public Description matchVariable(VariableTree node, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)node);
        if (!((Symbol)symbol).getKind().equals((Object)ElementKind.LOCAL_VARIABLE)) {
            return Description.NO_MATCH;
        }
        if (!((Symbol)symbol).asType().getKind().equals((Object)TypeKind.BOOLEAN)) {
            return Description.NO_MATCH;
        }
        if (NegativeBoolean.isNegativeName(((Symbol)symbol).getSimpleName().toString())) {
            return this.describeMatch(node);
        }
        return Description.NO_MATCH;
    }

    private static boolean isNegativeName(String name) {
        Matcher m = NEGATIVE_NAME.matcher(name);
        return m.matches();
    }
}

