/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMustBeClosedChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;
import java.util.List;
import javax.lang.model.type.TypeMirror;

@BugPattern(altNames={"MustBeClosed"}, summary="This method returns a resource which must be managed carefully, not just left for garbage collection. If it is a constant that will persist for the lifetime of your program, move it to a private static final field. Otherwise, you should use it in a try-with-resources.", severity=BugPattern.SeverityLevel.ERROR)
public class MustBeClosedChecker
extends AbstractMustBeClosedChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final Matcher<Tree> IS_AUTOCLOSEABLE = Matchers.isSubtypeOf(AutoCloseable.class);
    private static final Matcher<MethodTree> METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.methodIsConstructor()), Matchers.methodReturns(IS_AUTOCLOSEABLE)});
    private static final Matcher<MethodTree> AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf(AutoCloseable.class))});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        state.reportMatch(this.scanEntireMethodFor((Matcher<? super ExpressionTree>)(Matcher & Serializable)(t, s) -> {
            if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches(t, s)) {
                return false;
            }
            return !(t instanceof MethodInvocationTree) || !ASTHelpers.getSymbol((Tree)t).isConstructor();
        }, tree, state));
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        boolean isAConstructor = Matchers.methodIsConstructor().matches((Tree)tree, state);
        if (isAConstructor && !AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate constructors of AutoCloseables.").build();
        }
        if (!isAConstructor && !METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate methods that return an AutoCloseable.").build();
        }
        return Description.NO_MATCH;
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!IS_AUTOCLOSEABLE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        for (Tree tree2 : tree.getMembers()) {
            MethodTree methodTree;
            if (!(tree2 instanceof MethodTree) || !ASTHelpers.getSymbol((MethodTree)(methodTree = (MethodTree)tree2)).isConstructor() || ASTHelpers.hasAnnotation((Tree)methodTree, (String)"com.google.errorprone.annotations.MustBeClosed", (VisitorState)state) || !MustBeClosedChecker.invokedConstructorMustBeClosed(state, methodTree)) continue;
            if (ASTHelpers.isGeneratedConstructor((MethodTree)methodTree)) {
                state.reportMatch(this.buildDescription(tree).setMessage("Implicitly invoked constructor is marked @MustBeClosed, so this class must have an explicit constructor with @MustBeClosed also.").build());
                continue;
            }
            SuggestedFix.Builder builder = SuggestedFix.builder();
            String suggestedFixName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (TypeMirror)state.getTypeFromString("com.google.errorprone.annotations.MustBeClosed"));
            SuggestedFix fix = builder.prefixWith((Tree)methodTree, "@" + suggestedFixName + " ").build();
            state.reportMatch(this.buildDescription(methodTree).addFix((Fix)fix).setMessage("Invoked constructor is marked @MustBeClosed, so this constructor must be marked @MustBeClosed too.").build());
        }
        return Description.NO_MATCH;
    }

    private static boolean invokedConstructorMustBeClosed(VisitorState state, MethodTree methodTree) {
        List<? extends StatementTree> statements = methodTree.getBody().getStatements();
        if (statements.isEmpty()) {
            return false;
        }
        ExpressionStatementTree est = (ExpressionStatementTree)statements.get(0);
        MethodInvocationTree mit = (MethodInvocationTree)est.getExpression();
        Symbol.MethodSymbol invokedConstructorSymbol = ASTHelpers.getSymbol((MethodInvocationTree)mit);
        return ASTHelpers.hasAnnotation((Symbol)invokedConstructorSymbol, (String)"com.google.errorprone.annotations.MustBeClosed", (VisitorState)state);
    }
}

