/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Calls to Lock#lock should be immediately followed by a try block which releases the lock.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public final class LockNotBeforeTry
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> LOCK = MethodMatchers.instanceMethod().onDescendantOf("java.util.concurrent.locks.Lock").named("lock");
    private static final Matcher<ExpressionTree> UNLOCK = MethodMatchers.instanceMethod().onDescendantOf("java.util.concurrent.locks.Lock").named("unlock");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        StatementTree nextStatement;
        if (!LOCK.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof StatementTree)) {
            return Description.NO_MATCH;
        }
        Tree enclosing = state.getPath().getParentPath().getParentPath().getLeaf();
        if (!(enclosing instanceof BlockTree)) {
            return Description.NO_MATCH;
        }
        BlockTree block = (BlockTree)enclosing;
        int index = block.getStatements().indexOf(parent);
        if (index + 1 < block.getStatements().size() && (nextStatement = block.getStatements().get(index + 1)) instanceof TryTree) {
            return Description.NO_MATCH;
        }
        return this.describe(tree, state.getPath().getParentPath(), state);
    }

    private Description describe(MethodInvocationTree lockInvocation, TreePath statementPath, VisitorState state) {
        Tree lockStatement = statementPath.getLeaf();
        ExpressionTree lockee = ASTHelpers.getReceiver((ExpressionTree)lockInvocation);
        if (lockee == null) {
            return Description.NO_MATCH;
        }
        TryTree enclosingTry = (TryTree)state.findEnclosing(new Class[]{TryTree.class});
        if (enclosingTry != null && LockNotBeforeTry.releases(enclosingTry, lockee, state)) {
            Description.Builder description = this.buildDescription(lockInvocation);
            if (enclosingTry.getBlock().getStatements().indexOf(lockStatement) == 0) {
                description.addFix((Fix)SuggestedFix.builder().replace(lockStatement, "").prefixWith((Tree)enclosingTry, state.getSourceForNode(lockStatement)).build());
            }
            return description.setMessage(String.format("Prefer obtaining the lock for %s outside the try block. That way, if #lock throws, the lock is not erroneously released.", state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)lockInvocation)))).build();
        }
        Tree enclosing = state.getPath().getParentPath().getParentPath().getLeaf();
        if (!(enclosing instanceof BlockTree)) {
            return Description.NO_MATCH;
        }
        BlockTree block = (BlockTree)enclosing;
        int index = block.getStatements().indexOf(lockStatement);
        for (StatementTree statement : Iterables.skip(block.getStatements(), (int)(index + 1))) {
            TryTree tryTree;
            if (statement instanceof TryTree && LockNotBeforeTry.releases(tryTree = (TryTree)statement, lockee, state)) {
                int start = ASTHelpers.getStartPosition((Tree)statement);
                int end = ASTHelpers.getStartPosition((Tree)tryTree.getBlock().getStatements().get(0));
                SuggestedFix fix = SuggestedFix.builder().replace(start, end, "").postfixWith(lockStatement, state.getSourceCode().subSequence(start, end).toString()).build();
                return this.buildDescription(lockInvocation).addFix((Fix)fix).setMessage("Prefer locking *immediately* before the try block which releases the lock to avoid the possibility of any intermediate statements throwing.").build();
            }
            if (!(statement instanceof ExpressionStatementTree)) continue;
            ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)statement;
            ExpressionTree expression = expressionStatementTree.getExpression();
            if (LockNotBeforeTry.acquires(expression, lockee, state)) {
                return this.buildDescription(lockInvocation).setMessage(String.format("Did you forget to release the lock on %s?", state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)lockInvocation)))).build();
            }
            if (!LockNotBeforeTry.releases(expression, lockee, state)) continue;
            SuggestedFix fix = SuggestedFix.builder().postfixWith(lockStatement, "try {").prefixWith((Tree)statement, "} finally {").postfixWith((Tree)statement, "}").build();
            return this.buildDescription(lockInvocation).addFix((Fix)fix).setMessage(String.format("Prefer releasing the lock on %s inside a finally block.", state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)lockInvocation)))).build();
        }
        return Description.NO_MATCH;
    }

    private static boolean releases(TryTree tryTree, final ExpressionTree lockee, final VisitorState state) {
        if (tryTree.getFinallyBlock() == null) {
            return false;
        }
        Boolean released = (Boolean)new TreeScanner<Boolean, Void>(){

            @Override
            public @Nullable Boolean reduce(Boolean r1, Boolean r2) {
                return r1 == null ? r2 : (r2 == null ? null : Boolean.valueOf(r1 != false && r2 != false));
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree node, Void unused) {
                if (UNLOCK.matches((Tree)node, state)) {
                    return LockNotBeforeTry.releases(node, lockee, state);
                }
                return (Boolean)super.visitMethodInvocation(node, null);
            }
        }.scan(tryTree.getFinallyBlock(), null);
        return released == null ? false : released;
    }

    private static boolean releases(ExpressionTree node, ExpressionTree lockee, VisitorState state) {
        if (!UNLOCK.matches((Tree)node, state)) {
            return false;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)node);
        return receiver != null && UNLOCK.matches((Tree)node, state) && state.getSourceForNode((Tree)receiver).equals(state.getSourceForNode((Tree)lockee));
    }

    private static boolean acquires(ExpressionTree node, ExpressionTree lockee, VisitorState state) {
        if (!LOCK.matches((Tree)node, state)) {
            return false;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)node);
        return receiver != null && LOCK.matches((Tree)node, state) && state.getSourceForNode((Tree)receiver).equals(state.getSourceForNode((Tree)lockee));
    }
}

