/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.WellKnownKeep;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@BugPattern(summary="This field is only assigned during initialization; consider making it final", severity=BugPattern.SeverityLevel.SUGGESTION)
public class FieldCanBeFinal
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableSet<String> IMPLICIT_VAR_ANNOTATIONS = ImmutableSet.of((Object)"com.beust.jcommander.Parameter", (Object)"com.google.common.annotations.NonFinalForGwt", (Object)"com.google.errorprone.annotations.Var", (Object)"com.google.gwt.uibinder.client.UiField", (Object)"com.google.inject.Inject", (Object)"com.google.inject.testing.fieldbinder.Bind", (Object[])new String[]{"com.google.testing.junit.testparameterinjector.TestParameter", "jakarta.inject.Inject", "jakarta.jdo.annotations.Persistent", "jakarta.persistence.Id", "jakarta.xml.bind.annotation.XmlAttribute", "javax.inject.Inject", "javax.jdo.annotations.Persistent", "javax.persistence.Id", "javax.xml.bind.annotation.XmlAttribute", "org.kohsuke.args4j.Argument", "org.kohsuke.args4j.Option", "org.mockito.Spy", "picocli.CommandLine.Option"});
    private static final String OBJECTIFY_PREFIX = "com.googlecode.objectify.";
    private static final ImmutableSet<String> IMPLICIT_VAR_ANNOTATION_SIMPLE_NAMES = ImmutableSet.of((Object)"NonFinalForTesting", (Object)"NotFinalForTesting");
    private static final ImmutableSet<Tree.Kind> UNARY_ASSIGNMENT = Sets.immutableEnumSet((Enum)Tree.Kind.PREFIX_DECREMENT, (Enum[])new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_INCREMENT});
    private final WellKnownKeep wellKnownKeep;

    @Inject
    FieldCanBeFinal(WellKnownKeep wellKnownKeep) {
        this.wellKnownKeep = wellKnownKeep;
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        VariableAssignmentRecords writes = new VariableAssignmentRecords();
        new FinalScanner(writes, state).scan(state.getPath(), InitializationContext.NONE);
        for (VariableAssignments var : writes.getAssignments()) {
            if (!var.isEffectivelyFinal() || !ASTHelpers.canBeRemoved((Symbol.VarSymbol)var.sym) || this.wellKnownKeep.shouldKeep(var.declaration) || IMPLICIT_VAR_ANNOTATIONS.stream().anyMatch(a -> ASTHelpers.hasAnnotation((Symbol)var.sym, (String)a, (VisitorState)state))) continue;
            for (Attribute.Compound anno : var.sym.getAnnotationMirrors()) {
                TypeElement annoElement = (TypeElement)anno.getAnnotationType().asElement();
                if (IMPLICIT_VAR_ANNOTATION_SIMPLE_NAMES.contains((Object)annoElement.getSimpleName().toString())) {
                    return Description.NO_MATCH;
                }
                if (!annoElement.getQualifiedName().toString().startsWith(OBJECTIFY_PREFIX)) continue;
                return Description.NO_MATCH;
            }
            VariableTree varDecl = var.declaration();
            SuggestedFixes.addModifiers((Tree)varDecl, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).filter(f -> SuggestedFixes.compilesWithFix((Fix)f, (VisitorState)state)).ifPresent(f -> state.reportMatch(this.describeMatch(varDecl, (Fix)f)));
        }
        return Description.NO_MATCH;
    }

    private static class VariableAssignmentRecords {
        private final Map<Symbol.VarSymbol, VariableAssignments> assignments = new LinkedHashMap<Symbol.VarSymbol, VariableAssignments>();

        private VariableAssignmentRecords() {
        }

        private Collection<VariableAssignments> getAssignments() {
            return this.assignments.values();
        }

        private void recordAssignment(Tree tree, InitializationContext init) {
            Symbol sym = ASTHelpers.getSymbol((Tree)tree);
            if (sym != null && sym.getKind() == ElementKind.FIELD) {
                this.recordAssignment((Symbol.VarSymbol)sym, init);
            }
        }

        private void recordAssignment(Symbol.VarSymbol sym, InitializationContext init) {
            this.getDeclaration(sym).recordAssignment(init);
        }

        private VariableAssignments getDeclaration(Symbol.VarSymbol sym) {
            return this.assignments.computeIfAbsent(sym, VariableAssignments::new);
        }

        private void recordDeclaration(Symbol.VarSymbol sym, VariableTree tree) {
            this.getDeclaration(sym).recordDeclaration(tree);
        }
    }

    private class FinalScanner
    extends TreePathScanner<Void, InitializationContext> {
        private final VariableAssignmentRecords writes;
        private final VisitorState compilationState;

        private FinalScanner(VariableAssignmentRecords writes, VisitorState compilationState) {
            this.writes = writes;
            this.compilationState = compilationState;
        }

        @Override
        public Void visitVariable(VariableTree node, InitializationContext init) {
            Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)node);
            if (sym.getKind() == ElementKind.FIELD && !FieldCanBeFinal.this.isSuppressed(node, this.compilationState)) {
                this.writes.recordDeclaration(sym, node);
            }
            return (Void)super.visitVariable(node, InitializationContext.NONE);
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, InitializationContext init) {
            return (Void)super.visitLambdaExpression(lambdaExpressionTree, InitializationContext.NONE);
        }

        @Override
        public Void visitBlock(BlockTree node, InitializationContext init) {
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.CLASS) {
                init = node.isStatic() ? InitializationContext.STATIC : InitializationContext.INSTANCE;
            }
            return (Void)super.visitBlock(node, init);
        }

        @Override
        public Void visitMethod(MethodTree node, InitializationContext init) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)node);
            if (sym.isConstructor()) {
                init = InitializationContext.INSTANCE;
            }
            return (Void)super.visitMethod(node, init);
        }

        @Override
        public Void visitAssignment(AssignmentTree node, InitializationContext init) {
            if (init == InitializationContext.INSTANCE && !this.isThisAccess(node.getVariable())) {
                init = InitializationContext.NONE;
            }
            this.writes.recordAssignment(node.getVariable(), init);
            return (Void)super.visitAssignment(node, init);
        }

        private boolean isThisAccess(Tree tree) {
            IdentifierTree ident;
            MemberSelectTree memberSelectTree;
            ExpressionTree expressionTree;
            if (tree instanceof IdentifierTree) {
                return true;
            }
            return tree instanceof MemberSelectTree && (expressionTree = (memberSelectTree = (MemberSelectTree)tree).getExpression()) instanceof IdentifierTree && (ident = (IdentifierTree)expressionTree).getName().contentEquals("this");
        }

        @Override
        public Void visitClass(ClassTree node, InitializationContext init) {
            VisitorState state = this.compilationState.withPath(this.getCurrentPath());
            if (FieldCanBeFinal.this.isSuppressed(node, state)) {
                return null;
            }
            for (Attribute.Compound anno : ASTHelpers.getSymbol((ClassTree)node).getAnnotationMirrors()) {
                TypeElement annoElement = (TypeElement)anno.getAnnotationType().asElement();
                if (!annoElement.getQualifiedName().toString().startsWith(FieldCanBeFinal.OBJECTIFY_PREFIX)) continue;
                return null;
            }
            return (Void)super.visitClass(node, InitializationContext.NONE);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, InitializationContext init) {
            init = InitializationContext.NONE;
            this.writes.recordAssignment(node.getVariable(), init);
            return (Void)super.visitCompoundAssignment(node, init);
        }

        @Override
        public Void visitUnary(UnaryTree node, InitializationContext init) {
            if (UNARY_ASSIGNMENT.contains((Object)node.getKind())) {
                init = InitializationContext.NONE;
                this.writes.recordAssignment(node.getExpression(), init);
            }
            return (Void)super.visitUnary(node, init);
        }
    }

    private static enum InitializationContext {
        STATIC,
        INSTANCE,
        NONE;

    }

    private static class VariableAssignments {
        private final Symbol.VarSymbol sym;
        private final EnumSet<InitializationContext> writes = EnumSet.noneOf(InitializationContext.class);
        private VariableTree declaration;

        VariableAssignments(Symbol.VarSymbol sym) {
            this.sym = sym;
        }

        private void recordAssignment(InitializationContext init) {
            this.writes.add(init);
        }

        private void recordDeclaration(VariableTree tree) {
            this.declaration = tree;
        }

        private boolean isEffectivelyFinal() {
            InitializationContext other;
            InitializationContext wanted;
            if (this.declaration == null) {
                return false;
            }
            if (this.sym.getModifiers().contains((Object)Modifier.FINAL)) {
                return false;
            }
            if (this.writes.contains((Object)InitializationContext.NONE)) {
                return false;
            }
            if (this.sym.isStatic()) {
                wanted = InitializationContext.STATIC;
                other = InitializationContext.INSTANCE;
            } else {
                wanted = InitializationContext.INSTANCE;
                other = InitializationContext.STATIC;
            }
            if (this.writes.contains((Object)other)) {
                return false;
            }
            return this.writes.contains((Object)wanted) || (this.sym.flags() & 0x40000L) == 262144L;
        }

        private VariableTree declaration() {
            return this.declaration;
        }
    }
}

