/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntPredicate;

@BugPattern(summary="Comparison to value that is out of range for the compared type", explanation="This checker looks for comparisons to values that are too high or too low for the compared type.  For example, bytes may have a value in the range -128 to 127. Comparing a byte for equality with a value outside that range will always evaluate to false and usually indicates an error in the code.", severity=BugPattern.SeverityLevel.ERROR)
public class ComparisonOutOfRange
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final ImmutableMap<Supplier<Type>, Range<Long>> BOUNDS_FOR_PRIMITIVES = ImmutableMap.of((Object)Suppliers.BYTE_TYPE, ComparisonOutOfRange.range(-128L, 127L), (Object)Suppliers.CHAR_TYPE, ComparisonOutOfRange.range(0L, 65535L), (Object)Suppliers.SHORT_TYPE, ComparisonOutOfRange.range(-32768L, 32767L), (Object)Suppliers.INT_TYPE, ComparisonOutOfRange.range(Integer.MIN_VALUE, Integer.MAX_VALUE), (Object)Suppliers.LONG_TYPE, ComparisonOutOfRange.range(Long.MIN_VALUE, Long.MAX_VALUE));

    public Description matchBinary(final BinaryTree tree, final VisitorState state) {
        BOUNDS_FOR_PRIMITIVES.forEach((testedValueType, range) -> {
            Number numericConstantValue;
            List binaryTreeMatches = ASTHelpers.matchBinaryTree((BinaryTree)tree, Arrays.asList(ComparisonOutOfRange::hasNumericConstantValue, Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType((Supplier)testedValueType), Matchers.isSameType((Supplier & Serializable)s -> s.getTypes().boxedTypeOrType((Type)testedValueType.get(s)))})), (VisitorState)state);
            if (binaryTreeMatches == null) {
                return;
            }
            final Tree constant = (Tree)binaryTreeMatches.get(0);
            Object patt0$temp = ASTHelpers.constValue((Tree)constant);
            if (patt0$temp instanceof Character) {
                Character c = (Character)patt0$temp;
                v0 = (long)c.charValue();
            } else {
                v0 = numericConstantValue = (Number)ASTHelpers.constValue((Tree)constant);
            }
            class MatchAttempt<N extends Number> {
                final N constantValue;
                final N minValue;
                final N maxValue;
                final /* synthetic */ ComparisonOutOfRange this$0;

                MatchAttempt(Function<Number, N> numericPromotion) {
                    this.this$0 = this$0;
                    this.constantValue = (Number)numericPromotion.apply(var3_3);
                    this.minValue = (Number)numericPromotion.apply((Number)((Object)var4_4.lowerEndpoint()));
                    this.maxValue = (Number)numericPromotion.apply((Number)((Object)var4_4.upperEndpoint()));
                }

                Description matchConstantResult() {
                    return switch (tree.getKind()) {
                        case Tree.Kind.EQUAL_TO -> this.matchOutOfBounds(false);
                        case Tree.Kind.NOT_EQUAL_TO -> this.matchOutOfBounds(true);
                        case Tree.Kind.LESS_THAN -> this.matchDoesNotSplitNumberLine(cmp -> cmp < 0);
                        case Tree.Kind.LESS_THAN_EQUAL -> this.matchDoesNotSplitNumberLine(cmp -> cmp <= 0);
                        case Tree.Kind.GREATER_THAN -> this.matchDoesNotSplitNumberLine(cmp -> cmp > 0);
                        case Tree.Kind.GREATER_THAN_EQUAL -> this.matchDoesNotSplitNumberLine(cmp -> cmp >= 0);
                        default -> Description.NO_MATCH;
                    };
                }

                Description matchOutOfBounds(boolean willEvaluateTo) {
                    return ((Comparable)this.constantValue).compareTo(this.minValue) < 0 || ((Comparable)this.constantValue).compareTo(this.maxValue) > 0 ? this.describeMatch(willEvaluateTo) : Description.NO_MATCH;
                }

                Description matchDoesNotSplitNumberLine(IntPredicate op) {
                    boolean maxResult;
                    boolean minResult;
                    if (constant == tree.getRightOperand()) {
                        minResult = op.test(((Comparable)this.minValue).compareTo(this.constantValue));
                        maxResult = op.test(((Comparable)this.maxValue).compareTo(this.constantValue));
                    } else {
                        minResult = op.test(((Comparable)this.constantValue).compareTo(this.minValue));
                        maxResult = op.test(((Comparable)this.constantValue).compareTo(this.maxValue));
                    }
                    return minResult == maxResult ? this.describeMatch(minResult) : Description.NO_MATCH;
                }

                Description describeMatch(boolean willEvaluateTo) {
                    boolean byteEqualityMatch = ASTHelpers.isSameType((Type)((Type)testedValueType.get(state)), (Type)state.getSymtab().byteType, (VisitorState)state) && (tree.getKind() == Tree.Kind.EQUAL_TO || tree.getKind() == Tree.Kind.NOT_EQUAL_TO);
                    return this.this$0.buildDescription(tree).addFix((Fix)(byteEqualityMatch ? SuggestedFix.replace((Tree)constant, (String)Byte.toString(((Number)this.constantValue).byteValue())) : SuggestedFix.replace((Tree)tree, (String)Boolean.toString(willEvaluateTo)))).setMessage(String.format("%ss may have a value in the range %d to %d; therefore, this comparison to %s will always evaluate to %s", ((Type)testedValueType.get((VisitorState)state)).tsym.name, range.lowerEndpoint(), range.upperEndpoint(), state.getSourceForNode(constant), willEvaluateTo)).build();
                }
            }
            MatchAttempt matchAttempt = numericConstantValue instanceof Double ? new MatchAttempt(this, Number::doubleValue) : (numericConstantValue instanceof Float ? new MatchAttempt(this, Number::floatValue) : new MatchAttempt(this, Number::longValue));
            state.reportMatch(matchAttempt.matchConstantResult());
        });
        return Description.NO_MATCH;
    }

    private static Range<Long> range(long min, long max) {
        return Range.closed((Comparable)Long.valueOf(min), (Comparable)Long.valueOf(max));
    }

    private static boolean hasNumericConstantValue(ExpressionTree tree, VisitorState state) {
        return ASTHelpers.constValue((Tree)tree) instanceof Number || ASTHelpers.constValue((Tree)tree) instanceof Character;
    }
}

