/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.IterableOfProtosSubject;
import com.google.common.truth.extensions.proto.MultimapWithProtoValuesFluentAssertion;
import com.google.common.truth.extensions.proto.ProtoSubjectBuilder;
import com.google.common.truth.extensions.proto.ProtoTruth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MultimapWithProtoValuesSubject<M extends Message>
extends MultimapSubject {
    private final FailureMetadata metadata;
    private final Multimap<?, M> actual;
    private final FluentEqualityConfig config;

    protected MultimapWithProtoValuesSubject(FailureMetadata failureMetadata, @Nullable Multimap<?, M> multimap) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), multimap);
    }

    MultimapWithProtoValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable Multimap<?, M> multimap) {
        super(failureMetadata, multimap);
        this.metadata = failureMetadata;
        this.actual = multimap;
        this.config = config;
    }

    public IterableOfProtosSubject<M> valuesForKey(@Nullable Object key) {
        return ((ProtoSubjectBuilder)this.check("valuesForKey(%s)", new Object[]{key}).about(ProtoTruth.protos())).that(this.actual.get(key));
    }

    MultimapWithProtoValuesFluentAssertion<M> usingConfig(FluentEqualityConfig newConfig) {
        return new MultimapWithProtoValuesFluentAssertionImpl<M>(new MultimapWithProtoValuesSubject<M>(this.metadata, newConfig, this.actual));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(fieldNumbers));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(fieldDescriptors));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(fieldNumbers));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(fieldDescriptors));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsForValues() {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElements());
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(fieldNumbers));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(fieldDescriptors));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForValues(double tolerance) {
        return this.usingConfig(this.config.usingDoubleTolerance(tolerance));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldsForValues(double tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldsForValues(double tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, fieldNumbers));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldDescriptorsForValues(double tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldDescriptorsForValues(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForValues(float tolerance) {
        return this.usingConfig(this.config.usingFloatTolerance(tolerance));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldsForValues(float tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldsForValues(float tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, fieldNumbers));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldDescriptorsForValues(float tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldDescriptorsForValues(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    public MultimapWithProtoValuesFluentAssertion<M> comparingExpectedFieldsOnlyForValues() {
        return this.usingConfig(this.config.comparingExpectedFieldsOnly());
    }

    public MultimapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.ignoringFieldsForValues(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptorsForValues(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MultimapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    public MultimapWithProtoValuesFluentAssertion<M> unpackingAnyUsingForValues(TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
        return this.usingConfig(this.config.unpackingAnyUsing(typeRegistry, extensionRegistry));
    }

    private MultimapSubject.UsingCorrespondence<M, M> usingCorrespondence(Iterable<? extends M> expectedValues) {
        return this.comparingValuesUsing(this.config.withExpectedMessages(expectedValues).toCorrespondence(FieldScopeUtil.getSingleDescriptor(this.actual.values())));
    }

    private static final class MultimapWithProtoValuesFluentAssertionImpl<M extends Message>
    implements MultimapWithProtoValuesFluentAssertion<M> {
        private final MultimapWithProtoValuesSubject<M> subject;

        MultimapWithProtoValuesFluentAssertionImpl(MultimapWithProtoValuesSubject<M> subject) {
            this.subject = subject;
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
            return this.subject.ignoringFieldAbsenceForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFieldAbsenceOfFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFieldAbsenceOfFieldsForValues(fieldNumbers);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldAbsenceOfFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldAbsenceOfFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
            return this.subject.ignoringRepeatedFieldOrderForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldsForValues(fieldNumbers);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsForValues() {
            return this.subject.ignoringExtraRepeatedFieldElementsForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldsForValues(fieldNumbers);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForValues(double tolerance) {
            return this.subject.usingDoubleToleranceForValues(tolerance);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldsForValues(double tolerance, int firstFieldNumber, int ... rest) {
            return this.subject.usingDoubleToleranceForFieldsForValues(tolerance, firstFieldNumber, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldsForValues(double tolerance, Iterable<Integer> fieldNumbers) {
            return this.subject.usingDoubleToleranceForFieldsForValues(tolerance, fieldNumbers);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldDescriptorsForValues(double tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.usingDoubleToleranceForFieldDescriptorsForValues(tolerance, firstFieldDescriptor, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForFieldDescriptorsForValues(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.usingDoubleToleranceForFieldDescriptorsForValues(tolerance, fieldDescriptors);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForValues(float tolerance) {
            return this.subject.usingFloatToleranceForValues(tolerance);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldsForValues(float tolerance, int firstFieldNumber, int ... rest) {
            return this.subject.usingFloatToleranceForFieldsForValues(tolerance, firstFieldNumber, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldsForValues(float tolerance, Iterable<Integer> fieldNumbers) {
            return this.subject.usingFloatToleranceForFieldsForValues(tolerance, fieldNumbers);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldDescriptorsForValues(float tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.usingFloatToleranceForFieldDescriptorsForValues(tolerance, firstFieldDescriptor, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForFieldDescriptorsForValues(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.usingFloatToleranceForFieldDescriptorsForValues(tolerance, fieldDescriptors);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> comparingExpectedFieldsOnlyForValues() {
            return this.subject.comparingExpectedFieldsOnlyForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
            return this.subject.withPartialScopeForValues(fieldScope);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFieldsForValues(fieldNumbers);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
            return this.subject.ignoringFieldScopeForValues(fieldScope);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
            return this.subject.reportingMismatchesOnlyForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> unpackingAnyUsingForValues(TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
            return this.subject.unpackingAnyUsingForValues(typeRegistry, extensionRegistry);
        }

        @Override
        public void containsEntry(@Nullable Object expectedKey, @Nullable M expectedValue) {
            ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence(Arrays.asList(expectedValue)).containsEntry(expectedKey, expectedValue);
        }

        @Override
        public void doesNotContainEntry(@Nullable Object excludedKey, @Nullable M excludedValue) {
            ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence(Arrays.asList(excludedValue)).doesNotContainEntry(excludedKey, excludedValue);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Multimap<?, ? extends M> expectedMap) {
            return ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence(expectedMap.values()).containsExactlyEntriesIn(expectedMap);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly() {
            return ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence((Iterable)ImmutableList.of()).containsExactly();
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly(@Nullable Object k0, @Nullable M v0, Object ... rest) {
            ArrayList<Object> expectedValues = new ArrayList<Object>();
            expectedValues.add(v0);
            for (int i = 1; i < rest.length; i += 2) {
                expectedValues.add((Message)rest[i]);
            }
            return ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence(expectedValues).containsExactly(k0, v0, rest);
        }

        @Override
        @Deprecated
        public boolean equals(Object o) {
            return this.subject.equals(o);
        }

        @Override
        @Deprecated
        public int hashCode() {
            return this.subject.hashCode();
        }
    }
}

