/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.NestHostAttribute;
import proguard.classfile.attribute.NestMembersAttribute;
import proguard.classfile.attribute.PermittedSubclassesAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDebugExtensionAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.module.ModuleAttribute;
import proguard.classfile.attribute.module.ModuleMainClassAttribute;
import proguard.classfile.attribute.module.ModulePackagesAttribute;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;

public class ChangedCodePrinter
implements AttributeVisitor {
    private static final Logger logger = LogManager.getLogger(ChangedCodePrinter.class);
    private final AttributeVisitor attributeVisitor;

    public ChangedCodePrinter(AttributeVisitor attributeVisitor) {
        this.attributeVisitor = attributeVisitor;
    }

    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        this.attributeVisitor.visitUnknownAttribute(clazz, unknownAttribute);
    }

    public void visitSourceDebugExtensionAttribute(Clazz clazz, SourceDebugExtensionAttribute sourceDebugExtensionAttribute) {
        this.attributeVisitor.visitSourceDebugExtensionAttribute(clazz, sourceDebugExtensionAttribute);
    }

    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        this.attributeVisitor.visitBootstrapMethodsAttribute(clazz, bootstrapMethodsAttribute);
    }

    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        this.attributeVisitor.visitSourceFileAttribute(clazz, sourceFileAttribute);
    }

    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        this.attributeVisitor.visitSourceDirAttribute(clazz, sourceDirAttribute);
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.attributeVisitor.visitInnerClassesAttribute(clazz, innerClassesAttribute);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.attributeVisitor.visitEnclosingMethodAttribute(clazz, enclosingMethodAttribute);
    }

    public void visitNestHostAttribute(Clazz clazz, NestHostAttribute nestHostAttribute) {
        this.attributeVisitor.visitNestHostAttribute(clazz, nestHostAttribute);
    }

    public void visitNestMembersAttribute(Clazz clazz, NestMembersAttribute nestMembersAttribute) {
        this.attributeVisitor.visitNestMembersAttribute(clazz, nestMembersAttribute);
    }

    public void visitPermittedSubclassesAttribute(Clazz clazz, PermittedSubclassesAttribute permittedSubclassesAttribute) {
        this.attributeVisitor.visitPermittedSubclassesAttribute(clazz, permittedSubclassesAttribute);
    }

    public void visitModuleAttribute(Clazz clazz, ModuleAttribute moduleAttribute) {
        this.attributeVisitor.visitModuleAttribute(clazz, moduleAttribute);
    }

    public void visitModuleMainClassAttribute(Clazz clazz, ModuleMainClassAttribute moduleMainClassAttribute) {
        this.attributeVisitor.visitModuleMainClassAttribute(clazz, moduleMainClassAttribute);
    }

    public void visitModulePackagesAttribute(Clazz clazz, ModulePackagesAttribute modulePackagesAttribute) {
        this.attributeVisitor.visitModulePackagesAttribute(clazz, modulePackagesAttribute);
    }

    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        this.attributeVisitor.visitDeprecatedAttribute(clazz, deprecatedAttribute);
    }

    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        this.attributeVisitor.visitSyntheticAttribute(clazz, syntheticAttribute);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute syntheticAttribute) {
        this.attributeVisitor.visitSignatureAttribute(clazz, syntheticAttribute);
    }

    public void visitDeprecatedAttribute(Clazz clazz, Field field, DeprecatedAttribute deprecatedAttribute) {
        this.attributeVisitor.visitDeprecatedAttribute(clazz, field, deprecatedAttribute);
    }

    public void visitSyntheticAttribute(Clazz clazz, Field field, SyntheticAttribute syntheticAttribute) {
        this.attributeVisitor.visitSyntheticAttribute(clazz, field, syntheticAttribute);
    }

    public void visitSignatureAttribute(Clazz clazz, Field field, SignatureAttribute syntheticAttribute) {
        this.attributeVisitor.visitSignatureAttribute(clazz, field, syntheticAttribute);
    }

    public void visitDeprecatedAttribute(Clazz clazz, Method method, DeprecatedAttribute deprecatedAttribute) {
        this.attributeVisitor.visitDeprecatedAttribute(clazz, method, deprecatedAttribute);
    }

    public void visitSyntheticAttribute(Clazz clazz, Method method, SyntheticAttribute syntheticAttribute) {
        this.attributeVisitor.visitSyntheticAttribute(clazz, method, syntheticAttribute);
    }

    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute syntheticAttribute) {
        this.attributeVisitor.visitSignatureAttribute(clazz, method, syntheticAttribute);
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.attributeVisitor.visitConstantValueAttribute(clazz, field, constantValueAttribute);
    }

    public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute exceptionsAttribute) {
        this.attributeVisitor.visitMethodParametersAttribute(clazz, method, exceptionsAttribute);
    }

    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        this.attributeVisitor.visitExceptionsAttribute(clazz, method, exceptionsAttribute);
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.attributeVisitor.visitStackMapAttribute(clazz, method, codeAttribute, stackMapAttribute);
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.attributeVisitor.visitStackMapTableAttribute(clazz, method, codeAttribute, stackMapTableAttribute);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.attributeVisitor.visitLineNumberTableAttribute(clazz, method, codeAttribute, lineNumberTableAttribute);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        this.attributeVisitor.visitLocalVariableTableAttribute(clazz, method, codeAttribute, localVariableTableAttribute);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        this.attributeVisitor.visitLocalVariableTypeTableAttribute(clazz, method, codeAttribute, localVariableTypeTableAttribute);
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeVisibleAnnotationsAttribute(clazz, runtimeVisibleAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeInvisibleAnnotationsAttribute(clazz, runtimeInvisibleAnnotationsAttribute);
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, Field field, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeVisibleAnnotationsAttribute(clazz, field, runtimeVisibleAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, Field field, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeInvisibleAnnotationsAttribute(clazz, field, runtimeInvisibleAnnotationsAttribute);
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeVisibleAnnotationsAttribute(clazz, method, runtimeVisibleAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeInvisibleAnnotationsAttribute(clazz, method, runtimeInvisibleAnnotationsAttribute);
    }

    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeVisibleParameterAnnotationsAttribute(clazz, method, runtimeVisibleParameterAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeInvisibleParameterAnnotationsAttribute(clazz, method, runtimeInvisibleParameterAnnotationsAttribute);
    }

    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeVisibleTypeAnnotationsAttribute(clazz, runtimeVisibleTypeAnnotationsAttribute);
    }

    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, Field field, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeVisibleTypeAnnotationsAttribute(clazz, field, runtimeVisibleTypeAnnotationsAttribute);
    }

    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeVisibleTypeAnnotationsAttribute(clazz, method, runtimeVisibleTypeAnnotationsAttribute);
    }

    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeVisibleTypeAnnotationsAttribute(clazz, method, codeAttribute, runtimeVisibleTypeAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleTypeAnnotationsAttribute(Clazz clazz, RuntimeInvisibleTypeAnnotationsAttribute runtimeInvisibleTypeAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeInvisibleTypeAnnotationsAttribute(clazz, runtimeInvisibleTypeAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleTypeAnnotationsAttribute(Clazz clazz, Field field, RuntimeInvisibleTypeAnnotationsAttribute runtimeInvisibleTypeAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeInvisibleTypeAnnotationsAttribute(clazz, field, runtimeInvisibleTypeAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleTypeAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleTypeAnnotationsAttribute runtimeInvisibleTypeAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeInvisibleTypeAnnotationsAttribute(clazz, method, runtimeInvisibleTypeAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleTypeAnnotationsAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, RuntimeInvisibleTypeAnnotationsAttribute runtimeInvisibleTypeAnnotationsAttribute) {
        this.attributeVisitor.visitRuntimeInvisibleTypeAnnotationsAttribute(clazz, method, codeAttribute, runtimeInvisibleTypeAnnotationsAttribute);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        this.attributeVisitor.visitAnnotationDefaultAttribute(clazz, method, annotationDefaultAttribute);
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        byte[] code = codeAttribute.code;
        byte[] oldCode = new byte[code.length];
        System.arraycopy(code, 0, oldCode, 0, codeAttribute.u4codeLength);
        this.attributeVisitor.visitCodeAttribute(clazz, method, codeAttribute);
        if (this.codeHasChanged(codeAttribute, oldCode)) {
            this.printChangedCode(clazz, method, codeAttribute, oldCode);
        }
    }

    private boolean codeHasChanged(CodeAttribute codeAttribute, byte[] oldCode) {
        if (oldCode.length != codeAttribute.u4codeLength) {
            return true;
        }
        for (int index = 0; index < codeAttribute.u4codeLength; ++index) {
            if (oldCode[index] == codeAttribute.code[index]) continue;
            return true;
        }
        return false;
    }

    private void printChangedCode(Clazz clazz, Method method, CodeAttribute codeAttribute, byte[] oldCode) {
        logger.info("Class {}", (Object)ClassUtil.externalClassName((String)clazz.getName()));
        logger.info("Method {}", (Object)ClassUtil.externalFullMethodDescription((String)clazz.getName(), (int)0, (String)method.getName(clazz), (String)method.getDescriptor(clazz)));
        for (int index = 0; index < codeAttribute.u4codeLength; ++index) {
            logger.info("{}{}: {} {}", (Object)(oldCode[index] == codeAttribute.code[index] ? "  -- " : "  => "), (Object)index, (Object)Integer.toHexString(0x100 | oldCode[index] & 0xFF).substring(1), (Object)Integer.toHexString(0x100 | codeAttribute.code[index] & 0xFF).substring(1));
        }
    }
}

