/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.common.collect.ImmutableList;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineDiagnostic;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.TurbineJavadoc;
import com.google.turbine.parse.Lexer;
import com.google.turbine.parse.Token;
import com.google.turbine.parse.UnicodeEscapePreprocessor;
import org.jspecify.annotations.Nullable;

public class StreamLexer
implements Lexer {
    private final UnicodeEscapePreprocessor reader;
    private int ch;
    private int position;
    private int readFrom;
    private String value = null;
    private TurbineJavadoc javadoc = null;

    public StreamLexer(UnicodeEscapePreprocessor reader) {
        this.reader = reader;
        this.eat();
    }

    private void saveValue(String value) {
        this.value = value;
    }

    private void readFrom() {
        this.value = null;
        this.readFrom = this.reader.position();
    }

    private void eat() {
        this.ch = this.reader.next();
    }

    @Override
    public @Nullable TurbineJavadoc javadoc() {
        TurbineJavadoc result = this.javadoc;
        this.javadoc = null;
        if (result == null) {
            return null;
        }
        return result;
    }

    @Override
    public String stringValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.reader.readString(this.readFrom, this.reader.position());
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public SourceFile source() {
        return this.reader.source();
    }

    @Override
    public Token next() {
        block57: while (true) {
            this.position = this.reader.position();
            switch (this.ch) {
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    this.eat();
                    continue block57;
                }
                case 47: {
                    this.eat();
                    switch (this.ch) {
                        case 47: {
                            block58: while (true) {
                                this.eat();
                                switch (this.ch) {
                                    case 10: 
                                    case 13: {
                                        this.eat();
                                        continue block57;
                                    }
                                    case 26: {
                                        if (this.reader.done()) {
                                            return Token.EOF;
                                        }
                                        this.eat();
                                        continue block58;
                                    }
                                }
                            }
                        }
                        case 42: {
                            this.eat();
                            boolean sawStar = false;
                            boolean isJavadoc = false;
                            if (this.ch == 42) {
                                this.eat();
                                if (this.ch == 47) {
                                    this.eat();
                                    continue block57;
                                }
                                isJavadoc = true;
                                this.readFrom();
                            }
                            block59: while (true) {
                                switch (this.ch) {
                                    case 42: {
                                        this.eat();
                                        sawStar = true;
                                        continue block59;
                                    }
                                    case 47: {
                                        if (sawStar) {
                                            if (isJavadoc) {
                                                this.javadoc = new TurbineJavadoc(this.position, this.reader.position(), this.source().source());
                                            }
                                            this.eat();
                                            continue block57;
                                        }
                                        sawStar = false;
                                        this.eat();
                                        continue block59;
                                    }
                                    case 26: {
                                        if (this.reader.done()) {
                                            throw TurbineError.format(this.reader.source(), this.position, TurbineError.ErrorKind.UNCLOSED_COMMENT, new Object[0]);
                                        }
                                        this.eat();
                                        sawStar = false;
                                        continue block59;
                                    }
                                }
                                this.eat();
                                sawStar = false;
                            }
                        }
                    }
                    if (this.ch == 61) {
                        this.eat();
                        return Token.DIVEQ;
                    }
                    return Token.DIV;
                }
                case 36: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    return this.identifier();
                }
                case 26: {
                    if (!this.reader.done()) {
                        throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
                    }
                    return Token.EOF;
                }
                case 33: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 94: 
                case 124: 
                case 126: {
                    return this.operator();
                }
                case 40: {
                    this.eat();
                    return Token.LPAREN;
                }
                case 41: {
                    this.eat();
                    return Token.RPAREN;
                }
                case 123: {
                    this.eat();
                    return Token.LBRACE;
                }
                case 125: {
                    this.eat();
                    return Token.RBRACE;
                }
                case 91: {
                    this.eat();
                    return Token.LBRACK;
                }
                case 93: {
                    this.eat();
                    return Token.RBRACK;
                }
                case 59: {
                    this.eat();
                    return Token.SEMI;
                }
                case 44: {
                    this.eat();
                    return Token.COMMA;
                }
                case 64: {
                    this.eat();
                    return Token.AT;
                }
                case 48: {
                    this.readFrom();
                    this.eat();
                    return switch (this.ch) {
                        case 88, 120 -> {
                            this.eat();
                            yield this.hexLiteral();
                        }
                        case 66, 98 -> {
                            this.eat();
                            yield this.boolLiteral();
                        }
                        case 48, 49, 50, 51, 52, 53, 54, 55, 95 -> this.octalLiteral();
                        case 46 -> {
                            this.eat();
                            yield this.floatLiteral();
                        }
                        case 70, 102 -> {
                            this.eat();
                            yield Token.FLOAT_LITERAL;
                        }
                        case 68, 100 -> {
                            this.eat();
                            yield Token.DOUBLE_LITERAL;
                        }
                        case 76, 108 -> {
                            this.eat();
                            yield Token.LONG_LITERAL;
                        }
                        default -> Token.INT_LITERAL;
                    };
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.readFrom();
                    return this.decimalLiteral();
                }
                case 46: {
                    this.readFrom();
                    this.eat();
                    return switch (this.ch) {
                        case 46 -> {
                            this.eat();
                            if (this.ch == 46) {
                                this.eat();
                                yield Token.ELLIPSIS;
                            }
                            throw this.inputError();
                        }
                        case 48, 49, 50, 51, 52, 53, 54, 55, 56, 57 -> this.floatLiteral();
                        default -> Token.DOT;
                    };
                }
                case 39: {
                    char value;
                    this.eat();
                    switch (this.ch) {
                        case 92: {
                            this.eat();
                            value = this.escape();
                            break;
                        }
                        case 39: {
                            throw this.error(TurbineError.ErrorKind.EMPTY_CHARACTER_LITERAL, new Object[0]);
                        }
                        default: {
                            value = (char)this.ch;
                            this.eat();
                        }
                    }
                    if (this.ch == 39) {
                        this.saveValue(String.valueOf(value));
                        this.eat();
                        return Token.CHAR_LITERAL;
                    }
                    throw this.error(TurbineError.ErrorKind.UNTERMINATED_CHARACTER_LITERAL, new Object[0]);
                }
                case 34: {
                    this.eat();
                    if (this.ch == 34) {
                        this.eat();
                        if (this.ch != 34) {
                            this.saveValue("");
                            return Token.STRING_LITERAL;
                        }
                        this.eat();
                        return this.textBlock();
                    }
                    this.readFrom();
                    StringBuilder sb = new StringBuilder();
                    block60: while (true) {
                        switch (this.ch) {
                            case 92: {
                                this.eat();
                                sb.append(this.escape());
                                continue block60;
                            }
                            case 34: {
                                this.saveValue(sb.toString());
                                this.eat();
                                return Token.STRING_LITERAL;
                            }
                            case 10: {
                                throw this.error(TurbineError.ErrorKind.UNTERMINATED_STRING, new Object[0]);
                            }
                            case 26: {
                                if (!this.reader.done()) break;
                                return Token.EOF;
                            }
                        }
                        sb.appendCodePoint(this.ch);
                        this.eat();
                    }
                }
            }
            break;
        }
        if (Character.isJavaIdentifierStart(this.ch)) {
            return this.identifier();
        }
        throw this.inputError();
    }

    private Token textBlock() {
        block12: while (true) {
            switch (this.ch) {
                case 9: 
                case 13: 
                case 32: {
                    this.eat();
                    continue block12;
                }
            }
            break;
        }
        switch (this.ch) {
            case 13: {
                this.eat();
                if (this.ch != 10) break;
                this.eat();
                break;
            }
            case 10: {
                this.eat();
                break;
            }
            default: {
                throw this.inputError();
            }
        }
        this.readFrom();
        StringBuilder sb = new StringBuilder();
        block13: while (true) {
            switch (this.ch) {
                case 34: {
                    this.eat();
                    if (this.ch != 34) {
                        sb.append("\"");
                        continue block13;
                    }
                    this.eat();
                    if (this.ch != 34) {
                        sb.append("\"\"");
                        continue block13;
                    }
                    this.eat();
                    String value = sb.toString();
                    value = StreamLexer.stripIndent(value);
                    value = this.translateEscapes(value);
                    this.saveValue(value);
                    return Token.STRING_LITERAL;
                }
                case 92: {
                    sb.appendCodePoint(this.ch);
                    this.eat();
                    if (this.ch == 26 && this.reader.done()) {
                        return Token.EOF;
                    }
                    sb.appendCodePoint(this.ch);
                    this.eat();
                    continue block13;
                }
                case 26: {
                    if (!this.reader.done()) break;
                    return Token.EOF;
                }
            }
            sb.appendCodePoint(this.ch);
            this.eat();
        }
    }

    static String stripIndent(String value) {
        boolean trailingNewline;
        if (value.isEmpty()) {
            return value;
        }
        ImmutableList lines = (ImmutableList)value.lines().collect(ImmutableList.toImmutableList());
        int strip = Integer.MAX_VALUE;
        char last = value.charAt(value.length() - 1);
        boolean bl = trailingNewline = last == '\n' || last == '\r';
        if (trailingNewline) {
            strip = 0;
        } else {
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                int nonWhitespaceStart = StreamLexer.nonWhitespaceStart(line);
                if (nonWhitespaceStart == line.length()) continue;
                strip = Math.min(strip, nonWhitespaceStart);
            }
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String line : lines) {
            int end;
            if (!first) {
                result.append('\n');
            }
            if (strip <= (end = StreamLexer.trailingWhitespaceStart(line))) {
                result.append(line, strip, end);
            }
            first = false;
        }
        if (trailingNewline) {
            result.append('\n');
        }
        return result.toString();
    }

    private static int nonWhitespaceStart(String value) {
        int i;
        for (i = 0; i < value.length() && Character.isWhitespace(value.charAt(i)); ++i) {
        }
        return i;
    }

    private static int trailingWhitespaceStart(String value) {
        int i;
        for (i = value.length() - 1; i >= 0 && Character.isWhitespace(value.charAt(i)); --i) {
        }
        return i + 1;
    }

    private String translateEscapes(String value) {
        StreamLexer lexer = new StreamLexer(new UnicodeEscapePreprocessor(new SourceFile(null, value + "\u001a")));
        try {
            return lexer.translateEscapes();
        }
        catch (TurbineError e) {
            throw new TurbineError((ImmutableList<TurbineDiagnostic>)((ImmutableList)e.diagnostics().stream().map(d -> d.withPosition(this.reader.source(), this.reader.position())).collect(ImmutableList.toImmutableList())));
        }
    }

    private String translateEscapes() {
        this.readFrom();
        StringBuilder sb = new StringBuilder();
        block8: while (true) {
            switch (this.ch) {
                case 92: {
                    this.eat();
                    switch (this.ch) {
                        case 13: {
                            this.eat();
                            if (this.ch != 10) continue block8;
                            this.eat();
                            continue block8;
                        }
                        case 10: {
                            this.eat();
                            continue block8;
                        }
                    }
                    sb.append(this.escape());
                    continue block8;
                }
                case 26: {
                    break block8;
                }
                default: {
                    sb.appendCodePoint(this.ch);
                    this.eat();
                    continue block8;
                }
            }
            break;
        }
        return sb.toString();
    }

    private char escape() {
        boolean zeroToThree = false;
        switch (this.ch) {
            case 98: {
                this.eat();
                return '\b';
            }
            case 116: {
                this.eat();
                return '\t';
            }
            case 110: {
                this.eat();
                return '\n';
            }
            case 102: {
                this.eat();
                return '\f';
            }
            case 114: {
                this.eat();
                return '\r';
            }
            case 115: {
                this.eat();
                return ' ';
            }
            case 34: {
                this.eat();
                return '\"';
            }
            case 39: {
                this.eat();
                return '\'';
            }
            case 92: {
                this.eat();
                return '\\';
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                zeroToThree = true;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                char value = (char)(this.ch - 48);
                this.eat();
                return switch (this.ch) {
                    case 48, 49, 50, 51, 52, 53, 54, 55 -> {
                        value = (char)(value << 3 | this.ch - 48);
                        this.eat();
                        if (zeroToThree) {
                            switch (this.ch) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: {
                                    value = (char)(value << 3 | this.ch - 48);
                                    this.eat();
                                    yield value;
                                }
                            }
                            yield value;
                        }
                        yield value;
                    }
                    default -> value;
                };
            }
        }
        throw this.inputError();
    }

    private Token decimalLiteral() {
        this.readDigits();
        return switch (this.ch) {
            case 69, 101 -> this.floatLiteral();
            case 46 -> {
                this.eat();
                yield this.floatLiteral();
            }
            case 70, 102 -> {
                this.eat();
                yield Token.FLOAT_LITERAL;
            }
            case 68, 100 -> {
                this.eat();
                yield Token.DOUBLE_LITERAL;
            }
            case 76, 108 -> {
                this.eat();
                yield Token.LONG_LITERAL;
            }
            default -> Token.INT_LITERAL;
        };
    }

    private Token hexFloatLiteral() {
        this.readHexDigits();
        switch (this.ch) {
            case 80: 
            case 112: {
                this.eat();
                this.signedInteger();
                break;
            }
        }
        return this.floatTypeSuffix();
    }

    private Token floatLiteral() {
        if (48 <= this.ch && this.ch <= 57) {
            this.readDigits();
        }
        switch (this.ch) {
            case 69: 
            case 101: {
                this.eat();
                this.signedInteger();
                break;
            }
        }
        return this.floatTypeSuffix();
    }

    private Token floatTypeSuffix() {
        return switch (this.ch) {
            case 68, 100 -> {
                this.eat();
                yield Token.DOUBLE_LITERAL;
            }
            case 70, 102 -> {
                this.eat();
                yield Token.FLOAT_LITERAL;
            }
            default -> Token.DOUBLE_LITERAL;
        };
    }

    private void signedInteger() {
        switch (this.ch) {
            case 43: 
            case 45: {
                this.eat();
                break;
            }
        }
        this.readDigits();
    }

    private void readHexDigits() {
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.eat();
                break;
            }
            default: {
                throw this.inputError();
            }
        }
        block10: while (true) {
            switch (this.ch) {
                case 95: {
                    do {
                        this.eat();
                    } while (this.ch == 95);
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            continue block10;
                        }
                    }
                    throw this.inputError();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    this.eat();
                    continue block10;
                }
            }
            break;
        }
    }

    private void readDigits() {
        if (48 > this.ch || this.ch > 57) {
            throw this.inputError();
        }
        this.eat();
        block4: while (true) {
            switch (this.ch) {
                case 95: {
                    do {
                        this.eat();
                    } while (this.ch == 95);
                    if (48 <= this.ch && this.ch <= 57) continue block4;
                    throw this.inputError();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.eat();
                    continue block4;
                }
            }
            break;
        }
    }

    private Token boolLiteral() {
        this.readBinaryDigits();
        return switch (this.ch) {
            case 76, 108 -> {
                this.eat();
                yield Token.LONG_LITERAL;
            }
            default -> Token.INT_LITERAL;
        };
    }

    private void readBinaryDigits() {
        switch (this.ch) {
            case 48: 
            case 49: {
                this.eat();
                break;
            }
            default: {
                throw this.inputError();
            }
        }
        block10: while (true) {
            switch (this.ch) {
                case 95: {
                    do {
                        this.eat();
                    } while (this.ch == 95);
                    switch (this.ch) {
                        case 48: 
                        case 49: {
                            continue block10;
                        }
                    }
                    throw this.inputError();
                }
                case 48: 
                case 49: {
                    this.eat();
                    continue block10;
                }
            }
            break;
        }
    }

    private Token octalLiteral() {
        this.readOctalDigits();
        return switch (this.ch) {
            case 76, 108 -> {
                this.eat();
                yield Token.LONG_LITERAL;
            }
            default -> Token.INT_LITERAL;
        };
    }

    private void readOctalDigits() {
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 95: {
                this.eat();
                break;
            }
            default: {
                throw this.inputError();
            }
        }
        block10: while (true) {
            switch (this.ch) {
                case 95: {
                    do {
                        this.eat();
                    } while (this.ch == 95);
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            continue block10;
                        }
                    }
                    throw this.inputError();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    this.eat();
                    continue block10;
                }
            }
            break;
        }
    }

    private Token hexLiteral() {
        this.readHexDigits();
        return switch (this.ch) {
            case 46 -> {
                this.eat();
                yield this.hexFloatLiteral();
            }
            case 76, 108 -> {
                this.eat();
                yield Token.LONG_LITERAL;
            }
            case 80, 112 -> {
                this.eat();
                this.signedInteger();
                yield this.floatTypeSuffix();
            }
            default -> Token.INT_LITERAL;
        };
    }

    private Token operator() {
        switch (this.ch) {
            case 61: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.EQ;
                }
                return Token.ASSIGN;
            }
            case 62: {
                this.eat();
                return switch (this.ch) {
                    case 61 -> {
                        this.eat();
                        yield Token.GTE;
                    }
                    case 62 -> {
                        this.eat();
                        switch (this.ch) {
                            case 62: {
                                this.eat();
                                if (this.ch == 61) {
                                    this.eat();
                                    yield Token.GTGTGTE;
                                }
                                yield Token.GTGTGT;
                            }
                            case 61: {
                                this.eat();
                                yield Token.GTGTE;
                            }
                        }
                        yield Token.GTGT;
                    }
                    default -> Token.GT;
                };
            }
            case 60: {
                this.eat();
                return switch (this.ch) {
                    case 61 -> {
                        this.eat();
                        yield Token.LTE;
                    }
                    case 60 -> {
                        this.eat();
                        if (this.ch == 61) {
                            this.eat();
                            yield Token.LTLTE;
                        }
                        yield Token.LTLT;
                    }
                    default -> Token.LT;
                };
            }
            case 33: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.NOTEQ;
                }
                return Token.NOT;
            }
            case 126: {
                this.eat();
                return Token.TILDE;
            }
            case 63: {
                this.eat();
                return Token.COND;
            }
            case 58: {
                this.eat();
                if (this.ch == 58) {
                    this.eat();
                    return Token.COLONCOLON;
                }
                return Token.COLON;
            }
            case 45: {
                this.eat();
                return switch (this.ch) {
                    case 62 -> {
                        this.eat();
                        yield Token.ARROW;
                    }
                    case 45 -> {
                        this.eat();
                        yield Token.DECR;
                    }
                    case 61 -> {
                        this.eat();
                        yield Token.MINUSEQ;
                    }
                    default -> Token.MINUS;
                };
            }
            case 38: {
                this.eat();
                return switch (this.ch) {
                    case 38 -> {
                        this.eat();
                        yield Token.ANDAND;
                    }
                    case 61 -> {
                        this.eat();
                        yield Token.ANDEQ;
                    }
                    default -> Token.AND;
                };
            }
            case 124: {
                this.eat();
                return switch (this.ch) {
                    case 61 -> {
                        this.eat();
                        yield Token.OREQ;
                    }
                    case 124 -> {
                        this.eat();
                        yield Token.OROR;
                    }
                    default -> Token.OR;
                };
            }
            case 43: {
                this.eat();
                return switch (this.ch) {
                    case 43 -> {
                        this.eat();
                        yield Token.INCR;
                    }
                    case 61 -> {
                        this.eat();
                        yield Token.PLUSEQ;
                    }
                    default -> Token.PLUS;
                };
            }
            case 42: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.MULTEQ;
                }
                return Token.MULT;
            }
            case 47: {
                throw this.inputError();
            }
            case 37: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.MODEQ;
                }
                return Token.MOD;
            }
            case 94: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.XOREQ;
                }
                return Token.XOR;
            }
        }
        throw this.inputError();
    }

    private Token identifier() {
        this.readFrom();
        this.eat();
        while (Character.isJavaIdentifierPart(this.ch) && (this.ch != 26 || !this.reader.done())) {
            this.eat();
        }
        return StreamLexer.makeIdent(this.stringValue());
    }

    private static Token makeIdent(String s) {
        return switch (s) {
            case "abstract" -> Token.ABSTRACT;
            case "assert" -> Token.ASSERT;
            case "boolean" -> Token.BOOLEAN;
            case "break" -> Token.BREAK;
            case "byte" -> Token.BYTE;
            case "case" -> Token.CASE;
            case "catch" -> Token.CATCH;
            case "char" -> Token.CHAR;
            case "class" -> Token.CLASS;
            case "const" -> Token.CONST;
            case "continue" -> Token.CONTINUE;
            case "default" -> Token.DEFAULT;
            case "do" -> Token.DO;
            case "double" -> Token.DOUBLE;
            case "else" -> Token.ELSE;
            case "enum" -> Token.ENUM;
            case "extends" -> Token.EXTENDS;
            case "final" -> Token.FINAL;
            case "finally" -> Token.FINALLY;
            case "float" -> Token.FLOAT;
            case "for" -> Token.FOR;
            case "goto" -> Token.GOTO;
            case "if" -> Token.IF;
            case "implements" -> Token.IMPLEMENTS;
            case "import" -> Token.IMPORT;
            case "instanceof" -> Token.INSTANCEOF;
            case "int" -> Token.INT;
            case "interface" -> Token.INTERFACE;
            case "long" -> Token.LONG;
            case "native" -> Token.NATIVE;
            case "new" -> Token.NEW;
            case "package" -> Token.PACKAGE;
            case "private" -> Token.PRIVATE;
            case "protected" -> Token.PROTECTED;
            case "public" -> Token.PUBLIC;
            case "return" -> Token.RETURN;
            case "short" -> Token.SHORT;
            case "static" -> Token.STATIC;
            case "strictfp" -> Token.STRICTFP;
            case "super" -> Token.SUPER;
            case "switch" -> Token.SWITCH;
            case "synchronized" -> Token.SYNCHRONIZED;
            case "this" -> Token.THIS;
            case "throw" -> Token.THROW;
            case "throws" -> Token.THROWS;
            case "transient" -> Token.TRANSIENT;
            case "try" -> Token.TRY;
            case "void" -> Token.VOID;
            case "volatile" -> Token.VOLATILE;
            case "while" -> Token.WHILE;
            case "true" -> Token.TRUE;
            case "false" -> Token.FALSE;
            case "null" -> Token.NULL;
            default -> Token.IDENT;
        };
    }

    private TurbineError inputError() {
        return this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.isBmpCodePoint(this.ch) ? Character.toString((char)this.ch) : String.format("U+%X", this.ch));
    }

    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.reader.source(), this.reader.position(), kind, args);
    }
}

