/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode.sig;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.model.TurbineConstantTypeKind;

public class SigParser {
    private final String sig;
    private int idx = 0;

    char peek() {
        return this.sig.charAt(this.idx);
    }

    @CanIgnoreReturnValue
    char eat() {
        return this.sig.charAt(this.idx++);
    }

    boolean hasNext() {
        return this.idx < this.sig.length();
    }

    public SigParser(String sig) {
        this.sig = sig;
    }

    public Sig.TySig parseFieldSig() {
        return switch (this.peek()) {
            case '[' -> this.parseArraySig();
            case 'T' -> this.parseTyVar();
            case 'L' -> this.parseClassTySig();
            case '+' -> {
                this.eat();
                yield new Sig.UpperBoundTySig(this.parseFieldSig());
            }
            case '-' -> {
                this.eat();
                yield new Sig.LowerBoundTySig(this.parseFieldSig());
            }
            case '*' -> {
                this.eat();
                yield new Sig.WildTyArgSig();
            }
            default -> throw new AssertionError(this.peek());
        };
    }

    public Sig.MethodSig parseMethodSig() {
        ImmutableList<Sig.TyParamSig> tyParams = this.parseTyParams();
        if (this.peek() != '(') {
            throw new AssertionError();
        }
        this.eat();
        ImmutableList.Builder params = ImmutableList.builder();
        while (this.peek() != ')') {
            params.add((Object)this.parseType());
        }
        this.eat();
        ImmutableList.Builder exceptions = ImmutableList.builder();
        Sig.TySig result = this.parseType();
        while (this.hasNext() && this.eat() == '^') {
            exceptions.add((Object)this.parseFieldSig());
        }
        return new Sig.MethodSig(tyParams, (ImmutableList<Sig.TySig>)params.build(), result, (ImmutableList<Sig.TySig>)exceptions.build());
    }

    public Sig.ClassSig parseClassSig() {
        ImmutableList<Sig.TyParamSig> tyParams = this.parseTyParams();
        Sig.ClassTySig superClass = this.parseClassTySig();
        ImmutableList.Builder interfaces = ImmutableList.builder();
        while (this.hasNext()) {
            interfaces.add((Object)this.parseClassTySig());
        }
        return new Sig.ClassSig(tyParams, superClass, (ImmutableList<Sig.ClassTySig>)interfaces.build());
    }

    private ImmutableList<Sig.TyParamSig> parseTyParams() {
        ImmutableList.Builder tyParams = ImmutableList.builder();
        if (this.peek() == '<') {
            this.eat();
            do {
                char ch;
                StringBuilder identifier = new StringBuilder();
                while ((ch = this.eat()) != ':') {
                    identifier.append(ch);
                }
                Sig.TySig classBound = null;
                switch (this.peek()) {
                    case 'L': 
                    case 'T': 
                    case '[': {
                        classBound = this.parseFieldSig();
                        break;
                    }
                }
                ImmutableList.Builder interfaceBounds = ImmutableList.builder();
                while (this.peek() == ':') {
                    this.eat();
                    interfaceBounds.add((Object)this.parseFieldSig());
                }
                tyParams.add((Object)new Sig.TyParamSig(identifier.toString(), classBound, (ImmutableList<Sig.TySig>)interfaceBounds.build()));
            } while (this.peek() != '>');
            this.eat();
        }
        return tyParams.build();
    }

    public Sig.TySig parseType() {
        return switch (this.peek()) {
            case 'Z' -> {
                this.eat();
                yield new Sig.BaseTySig(TurbineConstantTypeKind.BOOLEAN);
            }
            case 'C' -> {
                this.eat();
                yield new Sig.BaseTySig(TurbineConstantTypeKind.CHAR);
            }
            case 'B' -> {
                this.eat();
                yield new Sig.BaseTySig(TurbineConstantTypeKind.BYTE);
            }
            case 'S' -> {
                this.eat();
                yield new Sig.BaseTySig(TurbineConstantTypeKind.SHORT);
            }
            case 'I' -> {
                this.eat();
                yield new Sig.BaseTySig(TurbineConstantTypeKind.INT);
            }
            case 'F' -> {
                this.eat();
                yield new Sig.BaseTySig(TurbineConstantTypeKind.FLOAT);
            }
            case 'J' -> {
                this.eat();
                yield new Sig.BaseTySig(TurbineConstantTypeKind.LONG);
            }
            case 'D' -> {
                this.eat();
                yield new Sig.BaseTySig(TurbineConstantTypeKind.DOUBLE);
            }
            case 'V' -> {
                this.eat();
                yield Sig.VOID;
            }
            default -> this.parseFieldSig();
        };
    }

    private Sig.ArrayTySig parseArraySig() {
        this.eat();
        Sig.TySig elementType = this.parseType();
        return new Sig.ArrayTySig(elementType);
    }

    private Sig.TyVarSig parseTyVar() {
        char ch;
        this.eat();
        StringBuilder name = new StringBuilder();
        while ((ch = this.eat()) != ';') {
            name.append(ch);
        }
        return new Sig.TyVarSig(name.toString());
    }

    private Sig.ClassTySig parseClassTySig() {
        this.eat();
        ImmutableList.Builder simples = ImmutableList.builder();
        StringBuilder name = new StringBuilder();
        StringBuilder pkg = new StringBuilder();
        ImmutableList.Builder tyArgs = ImmutableList.builder();
        block6: while (true) {
            switch (this.peek()) {
                case '/': {
                    this.eat();
                    if (pkg.length() > 0) {
                        pkg.append('/');
                    }
                    pkg.append((CharSequence)name);
                    name = new StringBuilder();
                    continue block6;
                }
                case '<': {
                    this.eat();
                    do {
                        tyArgs.add((Object)this.parseFieldSig());
                    } while (this.peek() != '>');
                    this.eat();
                    continue block6;
                }
                case '.': {
                    this.eat();
                    simples.add((Object)new Sig.SimpleClassTySig(name.toString(), (ImmutableList<Sig.TySig>)tyArgs.build()));
                    tyArgs = ImmutableList.builder();
                    name = new StringBuilder();
                    continue block6;
                }
                case ';': {
                    break block6;
                }
                default: {
                    name.append(this.eat());
                    continue block6;
                }
            }
            break;
        }
        simples.add((Object)new Sig.SimpleClassTySig(name.toString(), (ImmutableList<Sig.TySig>)tyArgs.build()));
        this.eat();
        return new Sig.ClassTySig(pkg.toString(), (ImmutableList<Sig.SimpleClassTySig>)simples.build());
    }
}

