/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bound;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.bound.AnnotationMetadata;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.lookup.CompoundScope;
import com.google.turbine.binder.lookup.MemberImportIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import org.jspecify.annotations.Nullable;

public class SourceTypeBoundClass
implements TypeBoundClass {
    private final TurbineTyKind kind;
    private final @Nullable ClassSymbol owner;
    private final ImmutableMap<String, ClassSymbol> children;
    private final int access;
    private final ImmutableMap<String, TyVarSymbol> typeParameters;
    private final ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes;
    private final @Nullable Type superClassType;
    private final ImmutableList<Type> interfaceTypes;
    private final ImmutableList<ClassSymbol> permits;
    private final ImmutableList<TypeBoundClass.RecordComponentInfo> components;
    private final ImmutableList<TypeBoundClass.MethodInfo> methods;
    private final ImmutableList<TypeBoundClass.FieldInfo> fields;
    private final CompoundScope enclosingScope;
    private final CompoundScope scope;
    private final MemberImportIndex memberImports;
    private final @Nullable AnnotationMetadata annotationMetadata;
    private final ImmutableList<AnnoInfo> annotations;
    private final Tree.TyDecl decl;
    private final SourceFile source;

    public SourceTypeBoundClass(ImmutableList<Type> interfaceTypes, ImmutableList<ClassSymbol> permits, @Nullable Type superClassType, ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes, int access, ImmutableList<TypeBoundClass.RecordComponentInfo> components, ImmutableList<TypeBoundClass.MethodInfo> methods, ImmutableList<TypeBoundClass.FieldInfo> fields, @Nullable ClassSymbol owner, TurbineTyKind kind, ImmutableMap<String, ClassSymbol> children, ImmutableMap<String, TyVarSymbol> typeParameters, CompoundScope enclosingScope, CompoundScope scope, MemberImportIndex memberImports, @Nullable AnnotationMetadata annotationMetadata, ImmutableList<AnnoInfo> annotations, SourceFile source, Tree.TyDecl decl) {
        this.interfaceTypes = interfaceTypes;
        this.permits = permits;
        this.superClassType = superClassType;
        this.typeParameterTypes = typeParameterTypes;
        this.access = access;
        this.components = components;
        this.methods = methods;
        this.fields = fields;
        this.owner = owner;
        this.kind = kind;
        this.children = children;
        this.typeParameters = typeParameters;
        this.enclosingScope = enclosingScope;
        this.scope = scope;
        this.memberImports = memberImports;
        this.annotationMetadata = annotationMetadata;
        this.annotations = annotations;
        this.source = source;
        this.decl = decl;
    }

    @Override
    public @Nullable ClassSymbol superclass() {
        if (this.superClassType == null) {
            return null;
        }
        if (this.superClassType.tyKind() != Type.TyKind.CLASS_TY) {
            return null;
        }
        return ((Type.ClassTy)this.superClassType).sym();
    }

    @Override
    public ImmutableList<ClassSymbol> interfaces() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : this.interfaceTypes) {
            if (type.tyKind() != Type.TyKind.CLASS_TY) continue;
            result.add((Object)((Type.ClassTy)type).sym());
        }
        return result.build();
    }

    @Override
    public ImmutableList<ClassSymbol> permits() {
        return this.permits;
    }

    @Override
    public int access() {
        return this.access;
    }

    @Override
    public TurbineTyKind kind() {
        return this.kind;
    }

    @Override
    public @Nullable ClassSymbol owner() {
        return this.owner;
    }

    @Override
    public ImmutableMap<String, ClassSymbol> children() {
        return this.children;
    }

    @Override
    public ImmutableMap<String, TyVarSymbol> typeParameters() {
        return this.typeParameters;
    }

    @Override
    public ImmutableList<Type> interfaceTypes() {
        return this.interfaceTypes;
    }

    @Override
    public @Nullable Type superClassType() {
        return this.superClassType;
    }

    @Override
    public ImmutableList<TypeBoundClass.RecordComponentInfo> components() {
        return this.components;
    }

    @Override
    public ImmutableList<TypeBoundClass.MethodInfo> methods() {
        return this.methods;
    }

    @Override
    public @Nullable AnnotationMetadata annotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public ImmutableList<TypeBoundClass.FieldInfo> fields() {
        return this.fields;
    }

    @Override
    public ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes() {
        return this.typeParameterTypes;
    }

    public CompoundScope enclosingScope() {
        return this.enclosingScope;
    }

    public CompoundScope scope() {
        return this.scope;
    }

    public MemberImportIndex memberImports() {
        return this.memberImports;
    }

    @Override
    public ImmutableList<AnnoInfo> annotations() {
        return this.annotations;
    }

    public SourceFile source() {
        return this.source;
    }

    public Tree.TyDecl decl() {
        return this.decl;
    }
}

