/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import com.google.testing.junit.testparameterinjector.TestParameterValidator;
import com.google.testing.junit.testparameterinjector.TestParameterValueProvider;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.ANNOTATION_TYPE})
@interface TestParameterAnnotation {
    public Class<? extends TestParameterValidator> validator() default DefaultValidator.class;

    public Class<? extends TestParameterValueProvider> valueProvider() default DefaultValueProvider.class;

    public static class DefaultValueProvider
    implements TestParameterValueProvider {
        @Override
        public List<Object> provideValues(Annotation annotation, Optional<Class<?>> parameterClass) {
            Object parameters = DefaultValueProvider.getParametersAnnotationValues(annotation, annotation.annotationType());
            Preconditions.checkState((boolean)parameters.getClass().isArray(), (Object)"The return value of the value method should be an array");
            int parameterCount = Array.getLength(parameters);
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            for (int i = 0; i < parameterCount; ++i) {
                Object value = Array.get(parameters, i);
                if (parameterClass.isPresent()) {
                    Verify.verify((boolean)Primitives.wrap((Class)((Class)parameterClass.get())).isInstance(value), (String)"Found %s annotation next to a parameter of type %s which doesn't match (annotation = %s)", (Object)annotation.annotationType().getSimpleName(), (Object)((Class)parameterClass.get()).getSimpleName(), (Object)annotation);
                }
                resultBuilder.add(value);
            }
            return resultBuilder.build();
        }

        @Override
        public Class<?> getValueType(Class<? extends Annotation> annotationType, Optional<Class<?>> parameterClass) {
            try {
                Method valueMethod = annotationType.getMethod("value", new Class[0]);
                return valueMethod.getReturnType().getComponentType();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("The @TestParameterAnnotation annotation should have a single value() method.", e);
            }
        }

        private static Object getParametersAnnotationValues(Annotation annotation, Class<? extends Annotation> annotationType) {
            Object parameters;
            Method valueMethod;
            try {
                valueMethod = annotationType.getMethod("value", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("The @TestParameterAnnotation annotation should have a single value() method.", e);
            }
            try {
                parameters = valueMethod.invoke((Object)annotation, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IllegalAccessError) {
                    throw new RuntimeException(String.format("Could not access %s.value(). This is probably because %s is not visible to the annotation proxy. To fix this, make %s public.", annotationType.getSimpleName(), valueMethod.getReturnType().getSimpleName(), valueMethod.getReturnType().getSimpleName()));
                }
                throw new RuntimeException("Unexpected exception while invoking " + valueMethod, e);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception while invoking " + valueMethod, e);
            }
            return parameters;
        }
    }

    public static class DefaultValidator
    implements TestParameterValidator {
        @Override
        public boolean shouldSkip(TestParameterValidator.Context context) {
            return false;
        }
    }
}

