/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode.sig;

import com.google.turbine.bytecode.sig.Sig;

public class SigWriter {
    private final StringBuilder sb = new StringBuilder();

    public static String classSig(Sig.ClassSig classSig) {
        SigWriter writer = new SigWriter();
        writer.printClassSig(classSig);
        return writer.toString();
    }

    public static String type(Sig.TySig tySig) {
        SigWriter writer = new SigWriter();
        writer.writeTySig(tySig);
        return writer.toString();
    }

    public static String method(Sig.MethodSig methodSig) {
        SigWriter writer = new SigWriter();
        writer.writeMethodSig(methodSig);
        return writer.toString();
    }

    public String toString() {
        return this.sb.toString();
    }

    private void writeFormalTyParamSig(Sig.TyParamSig tyParamSig) {
        this.sb.append(tyParamSig.name());
        this.sb.append(':');
        if (tyParamSig.classBound() != null) {
            this.writeTySig(tyParamSig.classBound());
        }
        for (Sig.TySig f : tyParamSig.interfaceBounds()) {
            this.sb.append(':');
            this.writeTySig(f);
        }
    }

    private void writeClassTySig(Sig.ClassTySig classTySig) {
        this.sb.append('L');
        if (!classTySig.pkg().isEmpty()) {
            this.sb.append(classTySig.pkg()).append('/');
        }
        boolean first = true;
        for (Sig.SimpleClassTySig c : classTySig.classes()) {
            if (first) {
                first = false;
            } else {
                this.sb.append('.');
            }
            this.writeSimpleClassTySig(c);
        }
        this.sb.append(';');
    }

    public void writeSimpleClassTySig(Sig.SimpleClassTySig simpleClassTySig) {
        this.sb.append(simpleClassTySig.simpleName());
        if (!simpleClassTySig.tyArgs().isEmpty()) {
            this.sb.append('<');
            for (Sig.TySig x : simpleClassTySig.tyArgs()) {
                this.writeTySig(x);
            }
            this.sb.append('>');
        }
    }

    private void wildTyArgSig(Sig.WildTySig sig) {
        switch (sig.boundKind()) {
            case NONE: {
                this.sb.append('*');
                break;
            }
            case LOWER: {
                this.sb.append('-');
                this.writeTySig(((Sig.LowerBoundTySig)sig).bound());
                break;
            }
            case UPPER: {
                this.sb.append('+');
                this.writeTySig(((Sig.UpperBoundTySig)sig).bound());
            }
        }
    }

    public void writeArrayTySig(Sig.ArrayTySig arrayTySig) {
        this.sb.append('[');
        this.writeTySig(arrayTySig.elementType());
    }

    public void writeTyVarSig(Sig.TyVarSig tyVarSig) {
        this.sb.append('T').append(tyVarSig.name()).append(';');
    }

    public void writePrimitiveTySig(Sig.BaseTySig ty) {
        switch (ty.type()) {
            case BYTE: {
                this.sb.append('B');
                break;
            }
            case CHAR: {
                this.sb.append('C');
                break;
            }
            case DOUBLE: {
                this.sb.append('D');
                break;
            }
            case FLOAT: {
                this.sb.append('F');
                break;
            }
            case INT: {
                this.sb.append('I');
                break;
            }
            case LONG: {
                this.sb.append('J');
                break;
            }
            case SHORT: {
                this.sb.append('S');
                break;
            }
            case BOOLEAN: {
                this.sb.append('Z');
                break;
            }
            default: {
                throw new AssertionError((Object)ty.type());
            }
        }
    }

    private void writeMethodSig(Sig.MethodSig methodSig) {
        if (!methodSig.tyParams().isEmpty()) {
            this.sb.append('<');
            for (Sig.TyParamSig x : methodSig.tyParams()) {
                this.writeFormalTyParamSig(x);
            }
            this.sb.append('>');
        }
        this.sb.append('(');
        for (Sig.TySig p : methodSig.params()) {
            this.writeTySig(p);
        }
        this.sb.append(')');
        this.writeTySig(methodSig.returnType());
        for (Sig.TySig e : methodSig.exceptions()) {
            this.sb.append('^');
            this.writeTySig(e);
        }
    }

    private void writeTySig(Sig.TySig p) {
        switch (p.kind()) {
            case VOID_TY_SIG: {
                this.sb.append('V');
                break;
            }
            case BASE_TY_SIG: {
                this.writePrimitiveTySig((Sig.BaseTySig)p);
                break;
            }
            case CLASS_TY_SIG: {
                this.writeClassTySig((Sig.ClassTySig)p);
                break;
            }
            case ARRAY_TY_SIG: {
                this.writeArrayTySig((Sig.ArrayTySig)p);
                break;
            }
            case TY_VAR_SIG: {
                this.writeTyVarSig((Sig.TyVarSig)p);
                break;
            }
            case WILD_TY_SIG: {
                this.wildTyArgSig((Sig.WildTySig)p);
            }
        }
    }

    private void printClassSig(Sig.ClassSig classSig) {
        if (!classSig.tyParams().isEmpty()) {
            this.sb.append('<');
            for (Sig.TyParamSig x : classSig.tyParams()) {
                this.writeFormalTyParamSig(x);
            }
            this.sb.append('>');
        }
        this.writeClassTySig(classSig.superClass());
        for (Sig.ClassTySig i : classSig.interfaces()) {
            this.writeClassTySig(i);
        }
    }
}

