/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.turbine.bytecode.AnnotationWriter;
import com.google.turbine.bytecode.Attribute;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ConstantPool;
import com.google.turbine.model.Const;
import java.util.List;

public class AttributeWriter {
    private final ConstantPool pool;

    public AttributeWriter(ConstantPool pool) {
        this.pool = pool;
    }

    public void write(ByteArrayDataOutput output, Attribute attribute) {
        switch (attribute.kind()) {
            case SIGNATURE: {
                this.writeSignatureAttribute(output, (Attribute.Signature)attribute);
                break;
            }
            case EXCEPTIONS: {
                this.writeExceptionsAttribute(output, (Attribute.ExceptionsAttribute)attribute);
                break;
            }
            case INNER_CLASSES: {
                this.writeInnerClasses(output, (Attribute.InnerClasses)attribute);
                break;
            }
            case CONSTANT_VALUE: {
                this.writeConstantValue(output, (Attribute.ConstantValue)attribute);
                break;
            }
            case RUNTIME_VISIBLE_ANNOTATIONS: 
            case RUNTIME_INVISIBLE_ANNOTATIONS: {
                this.writeAnnotation(output, (Attribute.Annotations)attribute);
                break;
            }
            case ANNOTATION_DEFAULT: {
                this.writeAnnotationDefault(output, (Attribute.AnnotationDefault)attribute);
                break;
            }
            case RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS: 
            case RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS: {
                this.writeParameterAnnotations(output, (Attribute.ParameterAnnotations)attribute);
                break;
            }
            case DEPRECATED: {
                this.writeDeprecated(output, attribute);
                break;
            }
            case RUNTIME_INVISIBLE_TYPE_ANNOTATIONS: 
            case RUNTIME_VISIBLE_TYPE_ANNOTATIONS: {
                this.writeTypeAnnotation(output, (Attribute.TypeAnnotations)attribute);
                break;
            }
            case METHOD_PARAMETERS: {
                this.writeMethodParameters(output, (Attribute.MethodParameters)attribute);
                break;
            }
            case MODULE: {
                this.writeModule(output, (Attribute.Module)attribute);
                break;
            }
            case NEST_HOST: {
                this.writeNestHost(output, (Attribute.NestHost)attribute);
                break;
            }
            case NEST_MEMBERS: {
                this.writeNestMembers(output, (Attribute.NestMembers)attribute);
                break;
            }
            case RECORD: {
                this.writeRecord(output, (Attribute.Record)attribute);
                break;
            }
            case PERMITTED_SUBCLASSES: {
                this.writePermittedSubclasses(output, (Attribute.PermittedSubclasses)attribute);
                break;
            }
            case TURBINE_TRANSITIVE_JAR: {
                this.writeTurbineTransitiveJar(output, (Attribute.TurbineTransitiveJar)attribute);
            }
        }
    }

    private void writeInnerClasses(ByteArrayDataOutput output, Attribute.InnerClasses attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(attribute.inners.size() * 8 + 2);
        output.writeShort(attribute.inners.size());
        for (ClassFile.InnerClass inner : attribute.inners) {
            output.writeShort(this.pool.classInfo(inner.innerClass()));
            output.writeShort(this.pool.classInfo(inner.outerClass()));
            output.writeShort(this.pool.utf8(inner.innerName()));
            output.writeShort(inner.access());
        }
    }

    private void writeExceptionsAttribute(ByteArrayDataOutput output, Attribute.ExceptionsAttribute attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(2 + attribute.exceptions.size() * 2);
        output.writeShort(attribute.exceptions.size());
        for (String exception : attribute.exceptions) {
            output.writeShort(this.pool.classInfo(exception));
        }
    }

    private void writeSignatureAttribute(ByteArrayDataOutput output, Attribute.Signature attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(2);
        output.writeShort(this.pool.utf8(attribute.signature));
    }

    public void writeConstantValue(ByteArrayDataOutput output, Attribute.ConstantValue attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(2);
        Const.Value value = attribute.value;
        switch (value.constantTypeKind()) {
            case INT: {
                output.writeShort(this.pool.integer(((Const.IntValue)value).value()));
                break;
            }
            case CHAR: {
                output.writeShort(this.pool.integer(((Const.CharValue)value).value()));
                break;
            }
            case SHORT: {
                output.writeShort(this.pool.integer(((Const.ShortValue)value).value()));
                break;
            }
            case BYTE: {
                output.writeShort(this.pool.integer(((Const.ByteValue)value).value()));
                break;
            }
            case LONG: {
                output.writeShort(this.pool.longInfo(((Const.LongValue)value).value()));
                break;
            }
            case DOUBLE: {
                output.writeShort(this.pool.doubleInfo(((Const.DoubleValue)value).value()));
                break;
            }
            case FLOAT: {
                output.writeShort(this.pool.floatInfo(((Const.FloatValue)value).value()));
                break;
            }
            case BOOLEAN: {
                output.writeShort(this.pool.integer(((Const.BooleanValue)value).value() ? 1 : 0));
                break;
            }
            case STRING: {
                output.writeShort(this.pool.string(((Const.StringValue)value).value()));
                break;
            }
            case NULL: {
                throw new AssertionError((Object)value.constantTypeKind());
            }
        }
    }

    public void writeAnnotation(ByteArrayDataOutput output, Attribute.Annotations attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeShort(attribute.annotations().size());
        for (ClassFile.AnnotationInfo annotation : attribute.annotations()) {
            new AnnotationWriter(this.pool, tmp).writeAnnotation(annotation);
        }
        byte[] data = tmp.toByteArray();
        output.writeInt(data.length);
        output.write(data);
    }

    public void writeAnnotationDefault(ByteArrayDataOutput output, Attribute.AnnotationDefault attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        new AnnotationWriter(this.pool, tmp).writeElementValue(attribute.value());
        byte[] data = tmp.toByteArray();
        output.writeInt(data.length);
        output.write(data);
    }

    public void writeParameterAnnotations(ByteArrayDataOutput output, Attribute.ParameterAnnotations attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeByte(attribute.annotations().size());
        for (List<ClassFile.AnnotationInfo> parameterAnnotations : attribute.annotations()) {
            tmp.writeShort(parameterAnnotations.size());
            for (ClassFile.AnnotationInfo annotation : parameterAnnotations) {
                new AnnotationWriter(this.pool, tmp).writeAnnotation(annotation);
            }
        }
        byte[] data = tmp.toByteArray();
        output.writeInt(data.length);
        output.write(data);
    }

    private void writeDeprecated(ByteArrayDataOutput output, Attribute attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(0);
    }

    private void writeTypeAnnotation(ByteArrayDataOutput output, Attribute.TypeAnnotations attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeShort(attribute.annotations().size());
        for (ClassFile.TypeAnnotationInfo annotation : attribute.annotations()) {
            new AnnotationWriter(this.pool, tmp).writeTypeAnnotation(annotation);
        }
        byte[] data = tmp.toByteArray();
        output.writeInt(data.length);
        output.write(data);
    }

    private void writeMethodParameters(ByteArrayDataOutput output, Attribute.MethodParameters attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(attribute.parameters().size() * 4 + 1);
        output.writeByte(attribute.parameters().size());
        for (ClassFile.MethodInfo.ParameterInfo parameter : attribute.parameters()) {
            output.writeShort(parameter.name() != null ? this.pool.utf8(parameter.name()) : 0);
            output.writeShort(parameter.access());
        }
    }

    private void writeModule(ByteArrayDataOutput output, Attribute.Module attribute) {
        ClassFile.ModuleInfo module = attribute.module();
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeShort(this.pool.moduleInfo(module.name()));
        tmp.writeShort(module.flags());
        tmp.writeShort(module.version() != null ? this.pool.utf8(module.version()) : 0);
        tmp.writeShort(module.requires().size());
        for (ClassFile.ModuleInfo.RequireInfo require : module.requires()) {
            tmp.writeShort(this.pool.moduleInfo(require.moduleName()));
            tmp.writeShort(require.flags());
            tmp.writeShort(require.version() != null ? this.pool.utf8(require.version()) : 0);
        }
        tmp.writeShort(module.exports().size());
        for (ClassFile.ModuleInfo.ExportInfo export : module.exports()) {
            tmp.writeShort(this.pool.packageInfo(export.moduleName()));
            tmp.writeShort(export.flags());
            tmp.writeShort(export.modules().size());
            for (String exportedModule : export.modules()) {
                tmp.writeShort(this.pool.moduleInfo(exportedModule));
            }
        }
        tmp.writeShort(module.opens().size());
        for (ClassFile.ModuleInfo.OpenInfo opens : module.opens()) {
            tmp.writeShort(this.pool.packageInfo(opens.moduleName()));
            tmp.writeShort(opens.flags());
            tmp.writeShort(opens.modules().size());
            for (String openModule : opens.modules()) {
                tmp.writeShort(this.pool.moduleInfo(openModule));
            }
        }
        tmp.writeShort(module.uses().size());
        for (ClassFile.ModuleInfo.UseInfo use : module.uses()) {
            tmp.writeShort(this.pool.classInfo(use.descriptor()));
        }
        tmp.writeShort(module.provides().size());
        for (ClassFile.ModuleInfo.ProvideInfo provide : module.provides()) {
            tmp.writeShort(this.pool.classInfo(provide.descriptor()));
            tmp.writeShort(provide.implDescriptors().size());
            for (String impl : provide.implDescriptors()) {
                tmp.writeShort(this.pool.classInfo(impl));
            }
        }
        byte[] data = tmp.toByteArray();
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(data.length);
        output.write(data);
    }

    private void writeNestHost(ByteArrayDataOutput output, Attribute.NestHost attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(2);
        output.writeShort(this.pool.classInfo(attribute.hostClass()));
    }

    private void writeNestMembers(ByteArrayDataOutput output, Attribute.NestMembers attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(2 + attribute.classes().size() * 2);
        output.writeShort(attribute.classes().size());
        for (String classes : attribute.classes()) {
            output.writeShort(this.pool.classInfo(classes));
        }
    }

    private void writeRecord(ByteArrayDataOutput output, Attribute.Record attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeShort(attribute.components().size());
        for (Attribute.Record.Component c : attribute.components()) {
            tmp.writeShort(this.pool.utf8(c.name()));
            tmp.writeShort(this.pool.utf8(c.descriptor()));
            tmp.writeShort(c.attributes().size());
            for (Attribute a : c.attributes()) {
                this.write(tmp, a);
            }
        }
        byte[] data = tmp.toByteArray();
        output.writeInt(data.length);
        output.write(data);
    }

    private void writePermittedSubclasses(ByteArrayDataOutput output, Attribute.PermittedSubclasses attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(2 + attribute.permits.size() * 2);
        output.writeShort(attribute.permits.size());
        for (String permits : attribute.permits) {
            output.writeShort(this.pool.classInfo(permits));
        }
    }

    private void writeTurbineTransitiveJar(ByteArrayDataOutput output, Attribute.TurbineTransitiveJar attribute) {
        output.writeShort(this.pool.utf8(attribute.kind().signature()));
        output.writeInt(2);
        output.writeShort(this.pool.utf8(attribute.transitiveJar));
    }
}

