/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.names;

import com.google.common.base.Ascii;
import com.google.common.primitives.Ints;

public final class NeedlemanWunschEditDistance {
    private NeedlemanWunschEditDistance() {
    }

    public static int getEditDistance(String source, String target, boolean caseSensitive, int changeCost, int openGapCost, int continueGapCost) {
        int i;
        if (!caseSensitive) {
            source = Ascii.toLowerCase((String)source);
            target = Ascii.toLowerCase((String)target);
        }
        int sourceLength = source.length();
        int targetLength = target.length();
        if (sourceLength == 0) {
            return NeedlemanWunschEditDistance.scriptCost(openGapCost, continueGapCost, targetLength);
        }
        if (targetLength == 0) {
            return NeedlemanWunschEditDistance.scriptCost(openGapCost, continueGapCost, sourceLength);
        }
        int[][] mMatrix = new int[sourceLength + 1][targetLength + 1];
        int[][] dMatrix = new int[sourceLength + 1][targetLength + 1];
        int[][] iMatrix = new int[sourceLength + 1][targetLength + 1];
        iMatrix[0][0] = 0;
        dMatrix[0][0] = 0;
        mMatrix[0][0] = 0;
        for (i = 1; i <= sourceLength; ++i) {
            int n = NeedlemanWunschEditDistance.scriptCost(openGapCost, continueGapCost, i);
            dMatrix[i][0] = n;
            mMatrix[i][0] = n;
            iMatrix[i][0] = 0x3FFFFFFF;
        }
        for (int j = 1; j <= targetLength; ++j) {
            int n = NeedlemanWunschEditDistance.scriptCost(openGapCost, continueGapCost, j);
            iMatrix[0][j] = n;
            mMatrix[0][j] = n;
            dMatrix[0][j] = 0x3FFFFFFF;
        }
        for (i = 1; i <= sourceLength; ++i) {
            char sourceI = source.charAt(i - 1);
            for (int j = 1; j <= targetLength; ++j) {
                char targetJ = target.charAt(j - 1);
                int cost = sourceI == targetJ ? 0 : changeCost;
                mMatrix[i][j] = cost + Ints.min((int[])new int[]{mMatrix[i - 1][j - 1], iMatrix[i - 1][j - 1], dMatrix[i - 1][j - 1]});
                dMatrix[i][j] = Math.min(mMatrix[i - 1][j] + openGapCost + continueGapCost, dMatrix[i - 1][j] + continueGapCost);
                iMatrix[i][j] = Math.min(mMatrix[i][j - 1] + openGapCost + continueGapCost, iMatrix[i][j - 1] + continueGapCost);
            }
        }
        int costOfEditScriptEndingWithMatch = mMatrix[sourceLength][targetLength];
        int costOfEditScriptEndingWithDelete = dMatrix[sourceLength][targetLength];
        int costOfEditScriptEndingWithInsert = iMatrix[sourceLength][targetLength];
        return Ints.min((int[])new int[]{costOfEditScriptEndingWithMatch, costOfEditScriptEndingWithDelete, costOfEditScriptEndingWithInsert});
    }

    public static int getWorstCaseEditDistance(int sourceLength, int targetLength, int changeCost, int openGapCost, int continueGapCost) {
        int maxLen = Math.max(sourceLength, targetLength);
        int minLen = Math.min(sourceLength, targetLength);
        int totChangeCost = NeedlemanWunschEditDistance.scriptCost(openGapCost, continueGapCost, maxLen - minLen) + minLen * changeCost;
        int blowAwayCost = NeedlemanWunschEditDistance.scriptCost(openGapCost, continueGapCost, sourceLength) + NeedlemanWunschEditDistance.scriptCost(openGapCost, continueGapCost, targetLength);
        return Math.min(totChangeCost, blowAwayCost);
    }

    public static double getNormalizedEditDistance(String source, String target, boolean caseSensitive, int changeCost, int openGapCost, int continueGapCost) {
        if (source.isEmpty() && target.isEmpty()) {
            return 0.0;
        }
        return (double)NeedlemanWunschEditDistance.getEditDistance(source, target, caseSensitive, changeCost, openGapCost, continueGapCost) / (double)NeedlemanWunschEditDistance.getWorstCaseEditDistance(source.length(), target.length(), changeCost, openGapCost, continueGapCost);
    }

    private static int scriptCost(int openGapCost, int continueGapCost, int scriptLength) {
        return scriptLength == 0 ? 0 : openGapCost + scriptLength * continueGapCost;
    }
}

