/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneError;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.ErrorPronePlugins;
import com.google.errorprone.ErrorProneTimings;
import com.google.errorprone.ErrorProneVersion;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.JavacErrorDescriptionListener;
import com.google.errorprone.RefactoringCollection;
import com.google.errorprone.SubContext;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.PropagatedException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.tools.JavaFileObject;

@ClientCodeWrapper.Trusted
public class ErrorProneAnalyzer
implements TaskListener {
    private final Set<Tree> seen = new HashSet<Tree>();
    private final Supplier<CodeTransformer> transformer;
    private final ErrorProneOptions errorProneOptions;
    private final Context context;
    private final DescriptionListener.Factory descriptionListenerFactory;
    private int errorProneErrors = 0;

    public static ErrorProneAnalyzer createAnalyzer(ScannerSupplier scannerSupplier, ErrorProneOptions epOptions, Context context, RefactoringCollection[] refactoringCollection) {
        if (!epOptions.patchingOptions().doRefactor()) {
            return ErrorProneAnalyzer.createByScanningForPlugins(scannerSupplier, epOptions, context);
        }
        refactoringCollection[0] = RefactoringCollection.refactor(epOptions.patchingOptions(), context);
        Supplier codeTransformer = (Supplier)epOptions.patchingOptions().customRefactorer().or((Object)Suppliers.memoize(() -> {
            ImmutableSet<String> namedCheckers = epOptions.patchingOptions().namedCheckers();
            ScannerSupplier toUse = ErrorPronePlugins.loadPlugins(scannerSupplier, context).applyOverrides(epOptions).filter((Predicate<? super BugCheckerInfo>)((Predicate)bci -> {
                String name = bci.canonicalName();
                return epOptions.getSeverityMap().get((Object)name) != ErrorProneOptions.Severity.OFF && (namedCheckers.isEmpty() || namedCheckers.contains((Object)name));
            }));
            return ErrorProneScannerTransformer.create((Scanner)toUse.get());
        }));
        return ErrorProneAnalyzer.createWithCustomDescriptionListener((Supplier<CodeTransformer>)codeTransformer, epOptions, context, refactoringCollection[0]);
    }

    public static ErrorProneAnalyzer createByScanningForPlugins(ScannerSupplier scannerSupplier, ErrorProneOptions errorProneOptions, Context context) {
        return new ErrorProneAnalyzer(ErrorProneAnalyzer.scansPlugins(scannerSupplier, errorProneOptions, context), errorProneOptions, context, JavacErrorDescriptionListener.provider(context));
    }

    private static Supplier<CodeTransformer> scansPlugins(ScannerSupplier scannerSupplier, ErrorProneOptions errorProneOptions, Context context) {
        return Suppliers.memoize(() -> {
            ErrorProneScannerTransformer errorProneScannerTransformer;
            block9: {
                ErrorProneTimings timings = ErrorProneTimings.instance(context);
                AutoCloseable unused = timings.initializationTimeSpan();
                try {
                    errorProneScannerTransformer = ErrorProneScannerTransformer.create((Scanner)ErrorPronePlugins.loadPlugins(scannerSupplier, context).applyOverrides(errorProneOptions).get());
                    if (unused == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (unused != null) {
                            try {
                                unused.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidCommandLineOptionException e) {
                        throw new PropagatedException(e);
                    }
                    catch (Exception e) {
                        throw new AssertionError((Object)e);
                    }
                }
                unused.close();
            }
            return errorProneScannerTransformer;
        });
    }

    static ErrorProneAnalyzer createWithCustomDescriptionListener(Supplier<CodeTransformer> codeTransformer, ErrorProneOptions errorProneOptions, Context context, DescriptionListener.Factory descriptionListenerFactory) {
        return new ErrorProneAnalyzer(codeTransformer, errorProneOptions, context, descriptionListenerFactory);
    }

    private ErrorProneAnalyzer(Supplier<CodeTransformer> transformer, ErrorProneOptions errorProneOptions, Context context, DescriptionListener.Factory descriptionListenerFactory) {
        this.transformer = (Supplier)Preconditions.checkNotNull(transformer);
        this.errorProneOptions = (ErrorProneOptions)Preconditions.checkNotNull((Object)errorProneOptions);
        this.descriptionListenerFactory = (DescriptionListener.Factory)Preconditions.checkNotNull((Object)descriptionListenerFactory);
        SubContext errorProneContext = new SubContext(context);
        errorProneContext.put(ErrorProneOptions.class, errorProneOptions);
        this.context = errorProneContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        if (JavaCompiler.instance(this.context).errorCount() > this.errorProneErrors) {
            return;
        }
        TreePath path = JavacTrees.instance(this.context).getPath(taskEvent.getTypeElement());
        if (path == null) {
            path = new TreePath(taskEvent.getCompilationUnit());
        }
        Verify.verify((boolean)this.seen.add(path.getLeaf()), (String)"Duplicate FLOW event for: %s", (Object)taskEvent.getTypeElement());
        Log log = Log.instance(this.context);
        JCTree.JCCompilationUnit compilation = (JCTree.JCCompilationUnit)path.getCompilationUnit();
        DescriptionListener descriptionListener = this.descriptionListenerFactory.getDescriptionListener(log, compilation);
        DescriptionListener countingDescriptionListener = d -> {
            if (d.severity() == BugPattern.SeverityLevel.ERROR) {
                ++this.errorProneErrors;
            }
            descriptionListener.onDescribed(d);
        };
        JavaFileObject originalSource = log.useSource(compilation.getSourceFile());
        try {
            if (this.shouldExcludeSourceFile(compilation)) {
                return;
            }
            if (path.getLeaf() instanceof CompilationUnitTree) {
                ((CodeTransformer)this.transformer.get()).apply(path, this.context, countingDescriptionListener);
            } else if (this.finishedCompilation(path.getCompilationUnit())) {
                ((CodeTransformer)this.transformer.get()).apply(new TreePath(compilation), this.context, countingDescriptionListener);
            }
        }
        catch (ErrorProneError e) {
            e.logFatalError(log, this.context);
            throw e;
        }
        catch (LinkageError e) {
            String version = (String)ErrorProneVersion.loadVersionFromPom().or((Object)"unknown version");
            log.error("error.prone.crash", Throwables.getStackTraceAsString((Throwable)e), version, "(see stack trace)");
            throw e;
        }
        catch (Symbol.CompletionFailure e) {
            log.error("proc.cant.access", e.sym, e.getDetailValue(), Throwables.getStackTraceAsString((Throwable)e));
        }
        finally {
            log.useSource(originalSource);
        }
    }

    private boolean shouldExcludeSourceFile(CompilationUnitTree tree) {
        Pattern excludedPattern = this.errorProneOptions.getExcludedPattern();
        return excludedPattern != null && excludedPattern.matcher(ASTHelpers.getFileName(tree)).matches();
    }

    private boolean finishedCompilation(CompilationUnitTree tree) {
        block4: for (Tree tree2 : tree.getTypeDecls()) {
            switch (tree2.getKind()) {
                case EMPTY_STATEMENT: {
                    continue block4;
                }
                case IMPORT: {
                    continue block4;
                }
            }
            if (this.seen.contains(tree2)) continue;
            return false;
        }
        return true;
    }

    public static class RefactoringTask
    implements TaskListener {
        private final Context context;
        private final RefactoringCollection refactoringCollection;

        public RefactoringTask(Context context, RefactoringCollection refactoringCollection) {
            this.context = context;
            this.refactoringCollection = refactoringCollection;
        }

        @Override
        public void started(TaskEvent event) {
        }

        @Override
        public void finished(TaskEvent event) {
            RefactoringCollection.RefactoringResult refactoringResult;
            if (event.getKind() != TaskEvent.Kind.GENERATE) {
                return;
            }
            try {
                refactoringResult = this.refactoringCollection.applyChanges(event.getSourceFile().toUri());
            }
            catch (Exception e) {
                PrintWriter out = Log.instance(this.context).getWriter(Log.WriterKind.ERROR);
                out.println(e.getMessage());
                out.flush();
                return;
            }
            if (refactoringResult.type() == RefactoringCollection.RefactoringResultType.CHANGED) {
                PrintWriter out = Log.instance(this.context).getWriter(Log.WriterKind.NOTICE);
                out.println(refactoringResult.message());
                out.flush();
            }
        }
    }
}

